/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import weblogic.common.T3Exception;
import weblogic.common.T3MiscLogger;
import weblogic.common.T3ServicesDef;
import weblogic.io.common.internal.OneWayInputClient;
import weblogic.io.common.internal.OneWayInputServer;
import weblogic.io.common.internal.OneWayOutputClient;
import weblogic.io.common.internal.OneWayOutputServer;
import weblogic.io.common.internal.T3FileSystemProxy;
import weblogic.io.common.internal.T3RemoteInputStreamProxy;
import weblogic.io.common.internal.T3RemoteOutputStreamProxy;
import weblogic.t3.srvr.T3Srvr;

public class T3FileSystemProxyImpl
implements T3FileSystemProxy {
    private String fileSystemName;
    private String prefix;
    private String canonicalPrefix;
    private T3ServicesDef svc;

    public String getName() {
        return this.fileSystemName;
    }

    public T3FileSystemProxyImpl(String string, String string2) {
        this.fileSystemName = string;
        this.svc = T3Srvr.getT3Srvr().getT3Services();
        this.prefix = string2;
        try {
            this.canonicalPrefix = this.validatePath(string2);
        }
        catch (IOException iOException) {
            this.canonicalPrefix = null;
            T3MiscLogger.logBadCreate((String)string2, (Exception)iOException);
            return;
        }
        T3MiscLogger.logCreate((String)string2);
    }

    private String validatePath(String string) throws IOException {
        String string2;
        File file;
        try {
            file = new File(string);
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            throw new IOException("Problem with path " + string + ", " + iOException);
        }
        if (!file.isDirectory()) {
            throw new IOException("Problem with path " + string2 + ", it is NOT a directory");
        }
        return string2;
    }

    private String getCanonicalPrefix() throws IOException {
        if (this.canonicalPrefix == null) {
            throw new IOException();
        }
        return this.canonicalPrefix;
    }

    private File getActualFile(String string) throws IllegalArgumentException {
        File file = new File(this.prefix + File.separator + string);
        try {
            String string2 = file.getCanonicalPath();
            if (!string2.startsWith(this.getCanonicalPrefix())) {
                throw new IllegalArgumentException("Remote file name " + string + " references above the mount point");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    private File getAbsoluteFile(String string) throws IllegalArgumentException {
        return this.getActualFile(string);
    }

    public boolean absoluteExists(String string) {
        File file = this.getAbsoluteFile(string);
        return file.exists();
    }

    public boolean isAbsoluteDirectory(String string) {
        File file = this.getAbsoluteFile(string);
        return file.isDirectory();
    }

    public String separator() {
        return File.separator;
    }

    public String pathSeparator() {
        return File.pathSeparator;
    }

    public OneWayInputServer createInputStream(OneWayInputClient oneWayInputClient, String string, int n, int n2) throws T3Exception {
        File file = this.getAbsoluteFile(string);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            T3MiscLogger.logFindRemote((String)file.getPath(), (Exception)fileNotFoundException);
            throw new T3Exception("Unable to find remote file " + string);
        }
        T3RemoteInputStreamProxy t3RemoteInputStreamProxy = new T3RemoteInputStreamProxy(this.fileSystemName + ":" + string, fileInputStream, n, n2, oneWayInputClient);
        return t3RemoteInputStreamProxy;
    }

    public OneWayOutputServer createOutputStream(OneWayOutputClient oneWayOutputClient, String string, int n) throws T3Exception {
        File file = this.getAbsoluteFile(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            T3MiscLogger.logOpenRemote((String)file.getPath(), (Exception)iOException);
            throw new T3Exception("Unable to open remote file " + string);
        }
        T3RemoteOutputStreamProxy t3RemoteOutputStreamProxy = new T3RemoteOutputStreamProxy(this.fileSystemName + ":" + string, fileOutputStream, n, oneWayOutputClient);
        return t3RemoteOutputStreamProxy;
    }

    public String getName(String string) {
        if (string == null || string.equals("")) {
            return this.fileSystemName;
        }
        File file = this.getAbsoluteFile(string);
        return file.getName();
    }

    public String getCanonicalPath(String string) throws IOException {
        File file = this.getAbsoluteFile(string);
        String string2 = file.getCanonicalPath();
        int n = string2.indexOf(this.getCanonicalPrefix());
        if (n != -1) {
            if (this.getCanonicalPrefix().length() >= string2.length()) {
                return "";
            }
            return string2.substring(this.getCanonicalPrefix().length() + 1);
        }
        throw new IOException("Invalid path name");
    }

    public String getParent(String string) {
        File file = this.getAbsoluteFile(string);
        String string2 = file.getParent();
        if (string2 != null && string2.length() > this.prefix.length()) {
            return string2.substring(this.prefix.length() + 1);
        }
        return null;
    }

    public boolean exists(String string) {
        File file = this.getAbsoluteFile(string);
        return file.exists();
    }

    public boolean canWrite(String string) {
        File file = this.getAbsoluteFile(string);
        return file.canWrite();
    }

    public boolean canRead(String string) {
        File file = this.getAbsoluteFile(string);
        return file.canRead();
    }

    public boolean isFile(String string) {
        File file = this.getAbsoluteFile(string);
        return file.isFile();
    }

    public boolean isDirectory(String string) {
        File file = this.getAbsoluteFile(string);
        return file.isDirectory();
    }

    public long lastModified(String string) {
        File file = this.getAbsoluteFile(string);
        return file.lastModified();
    }

    public long length(String string) {
        File file = this.getAbsoluteFile(string);
        return file.length();
    }

    public boolean mkdir(String string) {
        File file = this.getAbsoluteFile(string);
        return file.mkdir();
    }

    public boolean mkdirs(String string) {
        File file = this.getAbsoluteFile(string);
        return file.mkdirs();
    }

    public String[] list(String string) {
        File file = this.getAbsoluteFile(string);
        return file.list();
    }

    public String[] list(String string, FilenameFilter filenameFilter) {
        File file = this.getAbsoluteFile(string);
        return file.list(filenameFilter);
    }

    public boolean delete(String string) {
        File file = this.getAbsoluteFile(string);
        return file.delete();
    }

    public boolean renameTo(String string, String string2) {
        File file = this.getAbsoluteFile(string);
        File file2 = this.getAbsoluteFile(string2);
        return file.renameTo(file2);
    }
}

