/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import weblogic.common.T3Exception;
import weblogic.common.T3ServicesDef;
import weblogic.io.common.T3File;
import weblogic.io.common.T3FileInputStream;
import weblogic.io.common.T3FileOutputStream;
import weblogic.io.common.T3FileSystem;
import weblogic.io.common.internal.T3FileRemote;
import weblogic.io.common.internal.T3FileSystemProxy;

public final class T3FileSystemRemote
implements T3FileSystem {
    private T3FileSystemProxy rfs;
    private T3ServicesDef svc;
    private String separator = null;
    private String pathSeparator = null;

    public T3FileSystemRemote(T3ServicesDef t3ServicesDef, T3FileSystemProxy t3FileSystemProxy) {
        this.svc = t3ServicesDef;
        this.rfs = t3FileSystemProxy;
    }

    public String separator() {
        if (this.separator == null) {
            this.separator = this.rfs.separator();
        }
        return this.separator;
    }

    public String pathSeparator() {
        if (this.pathSeparator == null) {
            this.pathSeparator = this.rfs.pathSeparator();
        }
        return this.pathSeparator;
    }

    public String getName() {
        return this.rfs.getName();
    }

    public T3File getFile(String string) {
        return new T3FileRemote(this.svc, this.rfs, string);
    }

    public T3File getFile(String string, String string2) {
        return this.getFile(string + this.separator() + string2);
    }

    public T3FileInputStream getFileInputStream(String string) throws T3Exception {
        return this.getFile(string).getFileInputStream();
    }

    public T3FileInputStream getFileInputStream(String string, int n, int n2) throws T3Exception {
        return this.getFile(string).getFileInputStream(n, n2);
    }

    public T3FileOutputStream getFileOutputStream(String string) throws T3Exception {
        return this.getFile(string).getFileOutputStream();
    }

    public T3FileOutputStream getFileOutputStream(String string, int n, int n2) throws T3Exception {
        return this.getFile(string).getFileOutputStream(n, n2);
    }
}

