/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;
import weblogic.common.T3Exception;
import weblogic.io.common.internal.OneWayInputClient;
import weblogic.io.common.internal.OneWayInputServer;
import weblogic.io.common.internal.SkipResponse;
import weblogic.io.common.internal.T3RemoteConstants;
import weblogic.io.common.internal.WaitHashtable;

public final class T3RemoteInputStream
implements T3RemoteConstants,
OneWayInputClient {
    private int bufferSize;
    private int readAhead;
    private int currentBufferNum;
    private int nextBufferNum;
    private boolean closed;
    private WaitHashtable buffers;
    private SkipResponse skipRes;
    private byte[] source;
    private int sourceOffset;
    private String abortError;
    private boolean stopReadAhead;
    private OneWayInputServer onewayServer;
    private byte[] tmpb = new byte[1];

    public T3RemoteInputStream(int n, int n2) throws T3Exception {
        this.bufferSize = n;
        this.readAhead = n2;
        if (n < 1) {
            throw new T3Exception("bufferSize must be positive");
        }
        if (n2 < 0) {
            throw new T3Exception("readAhead cannot be negative");
        }
        this.closed = false;
        this.skipRes = new SkipResponse();
        this.buffers = new WaitHashtable(2 * (n2 + 1), 1.0f);
        this.source = null;
        this.currentBufferNum = 0;
        this.stopReadAhead = false;
        this.nextBufferNum = n2 + 1;
    }

    public void setOneWayRemote(OneWayInputServer oneWayInputServer) {
        this.onewayServer = oneWayInputServer;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (this.closed) {
            throw new IOException("Attempt to read from closed file");
        }
        if (n2 > byArray.length - n) {
            throw new IOException("Insufficient space for read: " + n2 + " requested, " + (byArray.length - n) + " available");
        }
        while (n2 > 0) {
            if (this.source == null) {
                this.source = (byte[])this.buffers.removeWait(new Integer(this.currentBufferNum));
                if (this.source == null) {
                    if (this.abortError == null) {
                        this.abortError = this.buffers.getError();
                    }
                    throw new IOException(this.abortError);
                }
                this.sourceOffset = 0;
            }
            if (this.source.length == 0) {
                if (n3 != 0) break;
                n3 = -1;
                break;
            }
            int n4 = Math.min(this.source.length - this.sourceOffset, n2);
            System.arraycopy(this.source, this.sourceOffset, byArray, n, n4);
            n += n4;
            this.sourceOffset += n4;
            n3 += n4;
            n2 -= n4;
            if (this.sourceOffset != this.source.length) continue;
            this.source = null;
            ++this.currentBufferNum;
            if (this.stopReadAhead) continue;
            this.sendRead(this.nextBufferNum);
            ++this.nextBufferNum;
        }
        return n3;
    }

    public synchronized int read() throws IOException {
        int n = this.read(this.tmpb, 0, 1);
        if (n == -1) {
            return -1;
        }
        return this.tmpb[0] & 0xFF;
    }

    public synchronized long skip(long l) throws IOException {
        int n = 0;
        if (this.closed) {
            throw new IOException("Attempt to skip in closed file");
        }
        int n2 = this.currentBufferNum;
        while (l > 0L && this.currentBufferNum < this.nextBufferNum) {
            if (this.source == null) {
                this.source = (byte[])this.buffers.removeWait(new Integer(this.currentBufferNum));
                if (this.source == null) {
                    throw new IOException(this.abortError);
                }
                this.sourceOffset = 0;
            }
            if (this.source.length == 0) break;
            int n3 = (int)Math.min((long)(this.source.length - this.sourceOffset), l);
            this.sourceOffset += n3;
            n += n3;
            l -= (long)n3;
            if (this.sourceOffset != this.source.length) continue;
            this.source = null;
            ++this.currentBufferNum;
        }
        if (l > 0L) {
            l = this.sendSkip(l);
            n = (int)((long)n + l);
        }
        if (n2 < this.currentBufferNum && !this.stopReadAhead) {
            this.nextBufferNum = this.currentBufferNum + this.readAhead + 1;
            this.sendRead(this.nextBufferNum - 1);
        }
        return n;
    }

    public synchronized int available() throws IOException {
        byte[] byArray;
        int n = 0;
        if (this.closed) {
            throw new IOException("Attempt to check availability of closed file");
        }
        if (this.source != null) {
            n = this.source.length - this.sourceOffset;
        }
        int n2 = this.currentBufferNum + 1;
        while ((byArray = (byte[])this.buffers.get(new Integer(n2))) != null) {
            n += byArray.length;
            ++n2;
        }
        return n;
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.source == null || this.source.length > 0) {
                while (this.currentBufferNum < this.nextBufferNum) {
                    this.source = (byte[])this.buffers.removeWait(new Integer(this.currentBufferNum));
                    if (this.source == null || this.source.length == 0) break;
                    ++this.currentBufferNum;
                }
            }
            this.sendClose();
        }
    }

    private void readCallback(int n, byte[] byArray) {
        this.buffers.put(new Integer(n), byArray);
        if (byArray.length < this.bufferSize) {
            this.stopReadAhead = true;
            if (byArray.length > 0) {
                this.buffers.put(new Integer(n + 1), new byte[0]);
            }
        }
    }

    private void cancel(String string) {
        this.stopReadAhead = true;
        this.abortError = string;
        this.buffers.cancel(string);
        this.skipRes.cancel(string);
    }

    private long sendSkip(long l) throws IOException {
        this.onewayServer.skip(l);
        Object object = this.skipRes.waitAround();
        if (object != null) {
            return (Long)object;
        }
        throw new IOException("Error waiting for result from skip");
    }

    private void sendRead(int n) {
        this.onewayServer.read(n);
    }

    private void sendClose() {
        this.onewayServer.close();
    }

    public void readResult(int n, byte[] byArray) {
        this.readCallback(n, byArray);
    }

    public void skipResult(long l) {
        this.skipRes.signal(new Long(l));
    }

    public void error(Exception exception) {
        String string = exception.getMessage();
        this.cancel(string);
    }
}

