/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;
import java.io.InputStream;
import weblogic.common.T3MiscLogger;
import weblogic.io.common.internal.OneWayInputClient;
import weblogic.io.common.internal.OneWayInputServer;
import weblogic.io.common.internal.T3RemoteConstants;

public final class T3RemoteInputStreamProxy
implements T3RemoteConstants,
OneWayInputServer {
    private InputStream is;
    private int bufferSize;
    private int nextBufferNum;
    private int requestedBufferNum;
    private boolean atEOF;
    private OneWayInputClient onewayClient;

    public T3RemoteInputStreamProxy(String string, InputStream inputStream, int n, int n2, OneWayInputClient oneWayInputClient) {
        this.is = inputStream;
        this.bufferSize = n;
        this.onewayClient = oneWayInputClient;
        this.nextBufferNum = 0;
        this.requestedBufferNum = -1;
        this.atEOF = false;
        this.read(n2);
    }

    public synchronized void read(int n) {
        if (n > this.requestedBufferNum) {
            this.requestedBufferNum = n;
            while (this.nextBufferNum <= this.requestedBufferNum && !this.atEOF) {
                int n2;
                byte[] byArray = new byte[this.bufferSize];
                for (int i = 0; i < this.bufferSize; i += n2) {
                    try {
                        n2 = this.is.read(byArray, i, this.bufferSize - i);
                    }
                    catch (IOException iOException) {
                        System.out.println("Calling onewayClient's error method.");
                        this.onewayClient.error(iOException);
                        return;
                    }
                    if (n2 != -1) continue;
                    this.atEOF = true;
                    byte[] byArray2 = new byte[i];
                    System.arraycopy(byArray, 0, byArray2, 0, i);
                    byArray = byArray2;
                    break;
                }
                this.onewayClient.readResult(this.nextBufferNum, byArray);
                ++this.nextBufferNum;
            }
        }
    }

    public synchronized void skip(long l) {
        try {
            this.onewayClient.skipResult(this.is.skip(l));
        }
        catch (IOException iOException) {
            this.onewayClient.error(iOException);
        }
    }

    public synchronized void close() {
        try {
            this.is.close();
        }
        catch (IOException iOException) {
            T3MiscLogger.logCloseException((Throwable)iOException);
        }
    }
}

