/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;
import weblogic.common.T3Exception;
import weblogic.io.common.internal.CommandResponse;
import weblogic.io.common.internal.OneWayOutputClient;
import weblogic.io.common.internal.OneWayOutputServer;
import weblogic.io.common.internal.T3RemoteConstants;
import weblogic.io.common.internal.WriteResponse;

public final class T3RemoteOutputStream
implements T3RemoteConstants,
OneWayOutputClient {
    private int bufferSize;
    private int currentBufferNum;
    private boolean closed;
    private WriteResponse writeRes;
    private CommandResponse flushRes;
    private CommandResponse closeRes;
    private byte[] target;
    private int targetOffset;
    private boolean aborted;
    private String abortError;
    private boolean flushRequired;
    private OneWayOutputServer onewayServer;

    public T3RemoteOutputStream(int n, int n2) throws T3Exception {
        this.bufferSize = n;
        if (n < 1) {
            throw new T3Exception("bufferSize must be positive");
        }
        if (n2 < 0) {
            throw new T3Exception("writeBehind cannot be negative");
        }
        this.closed = false;
        this.writeRes = new WriteResponse(n2);
        this.flushRes = new CommandResponse();
        this.closeRes = new CommandResponse();
        this.target = null;
        this.currentBufferNum = 0;
        this.aborted = false;
        this.flushRequired = false;
    }

    public void setOneWayRemote(OneWayOutputServer oneWayOutputServer) {
        this.onewayServer = oneWayOutputServer;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("Attempt to write to closed file");
        }
        if (this.aborted) {
            throw new IOException(this.abortError);
        }
        if (n2 > byArray.length - n) {
            throw new IOException("Insufficient data for write: " + n2 + " requested, " + (byArray.length - n) + " available");
        }
        while (n2 > 0) {
            if (this.target == null) {
                this.target = new byte[this.bufferSize];
                this.targetOffset = 0;
            }
            int n3 = Math.min(this.bufferSize - this.targetOffset, n2);
            System.arraycopy(byArray, n, this.target, this.targetOffset, n3);
            this.targetOffset += n3;
            n += n3;
            n2 -= n3;
            if (this.targetOffset != this.bufferSize) continue;
            this.writeRes.waitAround(this.currentBufferNum);
            this.sendWrite(this.currentBufferNum, this.target);
            this.flushRequired = true;
            this.target = null;
            ++this.currentBufferNum;
        }
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void flush() throws IOException {
        if (this.closed) {
            throw new IOException("Attempt to flush closed file");
        }
        if (this.aborted) {
            throw new IOException(this.abortError);
        }
        if (this.target != null && this.targetOffset != 0) {
            this.writeRes.waitAround(this.currentBufferNum);
            byte[] byArray = new byte[this.targetOffset];
            System.arraycopy(this.target, 0, byArray, 0, this.targetOffset);
            this.sendWrite(this.currentBufferNum, byArray);
            this.flushRequired = true;
            this.target = null;
            ++this.currentBufferNum;
        }
        if (this.flushRequired) {
            this.sendFlush(this.currentBufferNum - 1);
            this.flushRequired = false;
        }
    }

    public void close() throws IOException {
        if (this.aborted) {
            throw new IOException(this.abortError);
        }
        if (!this.closed) {
            this.flush();
            this.closed = true;
            this.sendClose();
            this.writeRes.waitAroundExactly(this.currentBufferNum - 1);
        }
    }

    private void cancel(String string) {
        this.aborted = true;
        this.abortError = string;
        this.writeRes.cancel(string);
        this.flushRes.cancel(string);
        this.closeRes.cancel(string);
    }

    private void sendWrite(int n, byte[] byArray) {
        this.onewayServer.write(n, byArray);
    }

    private void sendFlush(int n) throws IOException {
        this.onewayServer.flush(n);
        this.flushRes.waitAround();
    }

    private void sendClose() throws IOException {
        this.onewayServer.close();
        this.closeRes.waitAround();
    }

    public void writeResult(int n) {
        this.writeRes.signal(n);
    }

    public void flushResult() {
        this.flushRes.signal();
    }

    public void closeResult() {
        this.closeRes.signal();
    }

    public void error(Exception exception) {
        this.cancel(exception.getMessage());
    }
}

