/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;
import java.io.OutputStream;
import weblogic.common.T3MiscLogger;
import weblogic.io.common.internal.OneWayOutputClient;
import weblogic.io.common.internal.OneWayOutputServer;
import weblogic.io.common.internal.T3RemoteConstants;

public final class T3RemoteOutputStreamProxy
implements T3RemoteConstants,
OneWayOutputServer {
    private OutputStream os;
    private int nextBufferNum;
    private OneWayOutputClient onewayClient;
    private static final int SERVER_TIMEOUT_MILLSECS = 120000;

    public T3RemoteOutputStreamProxy(String string, OutputStream outputStream, int n, OneWayOutputClient oneWayOutputClient) {
        this.os = outputStream;
        this.onewayClient = oneWayOutputClient;
        this.nextBufferNum = 0;
    }

    public synchronized void write(int n, byte[] byArray) {
        while (n != this.nextBufferNum) {
            int n2 = this.nextBufferNum;
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n2 != this.nextBufferNum) continue;
            T3MiscLogger.logWriteTimed((int)this.nextBufferNum, (int)n);
            return;
        }
        try {
            this.os.write(byArray);
        }
        catch (IOException iOException) {
            this.onewayClient.error(iOException);
        }
        this.onewayClient.writeResult(this.nextBufferNum);
        ++this.nextBufferNum;
        this.notifyAll();
    }

    public synchronized void flush(int n) {
        while (this.nextBufferNum <= n) {
            int n2 = this.nextBufferNum;
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n2 != this.nextBufferNum) continue;
            T3MiscLogger.logFlushTimed((int)this.nextBufferNum, (int)n);
            return;
        }
        try {
            this.os.flush();
        }
        catch (IOException iOException) {
            this.onewayClient.error(iOException);
        }
        this.onewayClient.flushResult();
    }

    public synchronized void close() {
        try {
            this.os.close();
            this.onewayClient.closeResult();
        }
        catch (IOException iOException) {
            T3MiscLogger.logCloseException((Throwable)iOException);
        }
    }
}

