/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.util.Hashtable;

class WaitHashtable
extends Hashtable {
    boolean cancelled = false;
    private String error = "";
    int numPut = 0;
    private static final int CLIENT_TIMEOUT_MILLSECS = 120000;

    public WaitHashtable(int n) {
        super(n);
    }

    public WaitHashtable(int n, float f) {
        super(n, f);
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3 = super.put(object, object2);
        ++this.numPut;
        this.notifyAll();
        return object3;
    }

    public synchronized void cancel(String string) {
        this.cancelled = true;
        this.error = string;
        this.notifyAll();
    }

    public synchronized String getError() {
        return this.error;
    }

    public synchronized Object getWait(Object object) {
        if (this.cancelled) {
            return null;
        }
        Object v = this.get(object);
        while (v == null && !this.cancelled) {
            int n = this.numPut;
            boolean bl = false;
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            if (n == this.numPut && !this.cancelled) {
                if (bl) {
                    this.cancel("T3RemoteInputStream was interrupted before numPut could increase from " + this.numPut);
                }
                this.cancel("Supplier to T3RemoteInputStream made no progress in 120000 ms, numPut=" + this.numPut);
            }
            v = this.get(object);
        }
        return v;
    }

    public synchronized Object removeWait(Object object) {
        if (this.cancelled) {
            return null;
        }
        Object v = this.remove(object);
        while (v == null && !this.cancelled) {
            int n = this.numPut;
            boolean bl = false;
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            if (n == this.numPut && !this.cancelled) {
                if (bl) {
                    this.cancel("T3RemoteInputStream was interrupted before numPut could increase from " + this.numPut);
                }
                this.cancel("Supplier to T3RemoteInputStream made no progress in 120000 ms, numPut=" + this.numPut);
            }
            v = this.remove(object);
        }
        return v;
    }
}

