/*
 * Decompiled with CFR 0.152.
 */
package weblogic.io.common.internal;

import java.io.IOException;

class WriteResponse {
    private int bufferWritten = -1;
    private boolean cancelled = false;
    private String error = "";
    private int writeBehind;
    private static final int CLIENT_TIMEOUT_MILLSECS = 120000;

    public WriteResponse(int n) {
        this.writeBehind = n;
    }

    public synchronized void waitAroundExactly(int n) throws IOException {
        this.waitAround(n + this.writeBehind + 1);
    }

    public synchronized void waitAround(int n) throws IOException {
        if (this.cancelled) {
            throw new IOException(this.error);
        }
        while (n - this.writeBehind - 1 > this.bufferWritten && !this.cancelled) {
            int n2 = this.bufferWritten;
            try {
                this.wait(120000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n2 != this.bufferWritten || this.cancelled) continue;
            this.cancel("Timed out or interrupted waiting for write response");
        }
        if (this.cancelled) {
            throw new IOException(this.error);
        }
    }

    public synchronized void signal(int n) {
        if (n > this.bufferWritten) {
            this.bufferWritten = n;
            this.notify();
        }
    }

    public synchronized void cancel(String string) {
        this.error = string;
        this.cancelled = true;
        this.notify();
    }
}

