/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import java.net.MalformedURLException;
import java.rmi.server.RMIClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Map;
import java.util.WeakHashMap;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.descriptor.DescriptorClassLoader;
import weblogic.j2ee.J2EELogger;
import weblogic.kernel.KernelStatus;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.URLClassFinder;

public final class ApplicationManager {
    private static final AppClassLoaderManager APPCLASSLOADER_MANAGER = AppClassLoaderManager.getAppClassLoaderManager();
    private static final DebugCategory classFinderDebugging = Debug.getCategory((String)"weblogic.ClassFinder");
    private static Map networkLoaders = new WeakHashMap();
    private static String INSTALL_HELP_MSG = ":  This error could indicate that a component was deployed on a  cluster member but not other members of that cluster. Make sure that any component deployed on a server that is part of a cluster is also deployed on all other members of that cluster";

    private static ApplicationContextInternal getApplicationContext(String string) {
        return ApplicationAccess.getApplicationAccess().getApplicationContext(string);
    }

    public static ClassLoader getApplicationClassLoader(Annotation annotation) {
        ApplicationContextInternal applicationContextInternal = ApplicationManager.getApplicationContext(annotation.getApplicationName());
        return applicationContextInternal == null ? null : applicationContextInternal.getAppClassLoader();
    }

    public static Class loadClass(String string, String string2) throws ClassNotFoundException {
        return ApplicationManager.loadClass(string, string2, null);
    }

    public static Class loadClass(String string, String string2, boolean bl) throws ClassNotFoundException {
        return ApplicationManager.loadClass(string, string2, null, Thread.currentThread().getContextClassLoader(), bl);
    }

    public static Class loadClassWithNoDependencyClassLoader(String string, String string2) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (!(classLoader instanceof GenericClassLoader) && string2 != null) {
            return APPCLASSLOADER_MANAGER.loadApplicationClass(new Annotation(string2), string);
        }
        return ApplicationManager.loadClass(string, string2, null, classLoader);
    }

    public static Class loadClass(String string, String string2, String string3) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ApplicationManager.loadClass(string, string2, string3, classLoader);
    }

    public static Class loadClass(String string, String string2, String string3, ClassLoader classLoader) throws ClassNotFoundException {
        return ApplicationManager.loadClass(string, string2, string3, classLoader, false);
    }

    public static Class loadClass(String string, String string2, String string3, ClassLoader classLoader, boolean bl) throws ClassNotFoundException {
        String string4;
        block17: {
            Class<?> clazz;
            string4 = null;
            if (classFinderDebugging.isEnabled()) {
                ApplicationManager.log("loadClass: [" + string + "] [" + string2 + "] [" + string3 + "] [" + classLoader + "]");
            }
            try {
                clazz = Class.forName(string, true, classLoader);
                if (classFinderDebugging.isEnabled()) {
                    ApplicationManager.log("found " + clazz + " in current classloader: " + classLoader);
                }
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                string4 = classNotFoundException.getMessage();
            }
            if (classFinderDebugging.isEnabled()) {
                ApplicationManager.log(string + " not found in current classloader [" + classLoader + "], looking elsewhere");
            }
            if (string2 != null && string2.length() > 0) {
                clazz = new Annotation(string2);
                Class clazz2 = null;
                clazz2 = ApplicationManager.loadClassFromApplication(string, (Annotation)clazz, classLoader, bl);
                if (clazz2 != null) {
                    return clazz2;
                }
            }
            try {
                clazz = DescriptorClassLoader.loadClass((String)string);
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                clazz = ApplicationManager.loadFromNetwork(classLoader, string, string2, string3);
                if (clazz != null) {
                    return clazz;
                }
                if (string2 == null && (clazz = Class.forName(string, true, ApplicationManager.class.getClassLoader())) != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!KernelStatus.isServer()) break block17;
                string4 = classNotFoundException.getMessage();
            }
        }
        if (classFinderDebugging.isEnabled()) {
            ApplicationManager.log("Could not find " + string);
        }
        if (string4 != null) {
            throw new ClassNotFoundException(string4 + INSTALL_HELP_MSG);
        }
        throw new ClassNotFoundException(string + INSTALL_HELP_MSG);
    }

    private static Class loadClassFromApplication(String string, Annotation annotation, ClassLoader classLoader, boolean bl) {
        String string2 = annotation.getModuleName();
        String string3 = annotation.getApplicationName();
        if (classFinderDebugging.isEnabled()) {
            ApplicationManager.log("loadClass: Looking for " + string + " in app containers");
        }
        if (KernelStatus.isServer()) {
            try {
                Class clazz = null;
                if (classFinderDebugging.isEnabled()) {
                    ApplicationManager.log("Looking in new app list");
                }
                if ((clazz = ApplicationManager.loadClassFromNewStyleApplication(string, annotation, string3, string2, classLoader, bl)) != null) {
                    if (classFinderDebugging.isEnabled()) {
                        ApplicationManager.log("found " + clazz);
                    }
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Class loadClassFromNewStyleApplication(String string, Annotation annotation, String string2, String string3, ClassLoader classLoader, boolean bl) throws ClassNotFoundException {
        GenericClassLoader genericClassLoader = bl ? APPCLASSLOADER_MANAGER.findOrCreateInterAppLoader(annotation, classLoader) : APPCLASSLOADER_MANAGER.findOrCreateIntraAppLoader(annotation, classLoader);
        if (genericClassLoader != null) {
            return Class.forName(string, true, (ClassLoader)genericClassLoader);
        }
        throw new ClassNotFoundException("ClassLoader not found for " + string3);
    }

    private static boolean isNetworkClassLoadingEnabled() {
        if (!KernelStatus.isServer()) {
            return true;
        }
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ServerMBean serverMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServer();
        if (serverMBean == null) {
            return false;
        }
        return serverMBean.isNetworkClassLoadingEnabled();
    }

    private static Class loadFromNetwork(ClassLoader classLoader, String string, String string2, String string3) throws ClassNotFoundException {
        if (string.indexOf("java.lang.") > -1) {
            return null;
        }
        if (!ApplicationManager.isNetworkClassLoadingEnabled()) {
            return null;
        }
        if (classFinderDebugging.isEnabled()) {
            ApplicationManager.log("loadClass: Going to network with annotation " + string2 + " and codebase " + string3 + " looking for " + string);
        }
        if (classLoader instanceof GenericClassLoader && string3 != null) {
            ClassFinder classFinder = ApplicationManager.getNetworkFinder(string2, string3);
            GenericClassLoader genericClassLoader = (GenericClassLoader)classLoader;
            genericClassLoader.addClassFinder(classFinder);
            return Class.forName(string, true, (ClassLoader)genericClassLoader);
        }
        GenericClassLoader genericClassLoader = ApplicationManager.getNetworkLoader(classLoader, string2);
        if (genericClassLoader == null && string3 != null) {
            try {
                genericClassLoader = ApplicationManager.createNetworkLoader(classLoader, string2, string3);
                return Class.forName(string, true, (ClassLoader)genericClassLoader);
            }
            catch (AccessControlException accessControlException) {
                try {
                    if (classFinderDebugging.isEnabled()) {
                        ApplicationManager.log("loadClass: Going to rmi classloader with codebase " + string3 + " looking for " + string);
                    }
                    return RMIClassLoader.loadClass(string3, string);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                accessControlException.printStackTrace();
            }
        } else {
            return Class.forName(string, true, (ClassLoader)genericClassLoader);
        }
        return null;
    }

    private static ClassFinder getNetworkFinder(String string, String string2) {
        String string3 = string != null && string.length() > 0 ? string2 + string + "/" : string2;
        return new URLClassFinder(string3);
    }

    private static synchronized GenericClassLoader getNetworkLoader(ClassLoader classLoader, String string) {
        Map map = (Map)networkLoaders.get(classLoader);
        if (map == null) {
            networkLoaders.put(classLoader, new WeakHashMap());
            return null;
        }
        return (GenericClassLoader)map.get(string);
    }

    private static synchronized GenericClassLoader createNetworkLoader(ClassLoader classLoader, String string, String string2) {
        GenericClassLoader genericClassLoader = ApplicationManager.getNetworkLoader(classLoader, string);
        if (genericClassLoader == null && string2 != null) {
            ClassFinder classFinder = ApplicationManager.getNetworkFinder(string, string2);
            genericClassLoader = new GenericClassLoader(classFinder, classLoader);
            genericClassLoader.setAnnotation(new Annotation(string));
            ApplicationManager.addNetworkLoader(classLoader, string, genericClassLoader);
        }
        return genericClassLoader;
    }

    private static void addNetworkLoader(ClassLoader classLoader, String string, GenericClassLoader genericClassLoader) {
        WeakHashMap<String, GenericClassLoader> weakHashMap = (WeakHashMap<String, GenericClassLoader>)networkLoaders.get(classLoader);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<String, GenericClassLoader>();
            networkLoaders.put(classLoader, weakHashMap);
        }
        weakHashMap.put(string, genericClassLoader);
    }

    private static void log(String string) {
        Debug.say((String)string);
        J2EELogger.logDebug((String)string);
    }
}

