/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

public class DeploymentInfo {
    public static final int UNKNOWN = 0;
    public static final int ARCHIVED_EAR = 1;
    public static final int EXPLODED_EAR = 2;
    public static final int ARCHIVED_WEB = 3;
    public static final int EXPLODED_WEB = 4;
    public static final int ARCHIVED_RAR = 5;
    public static final int EXPLODED_RAR = 6;
    public static final int ARCHIVED_EJB = 7;
    public static final int EXPLODED_EJB = 8;
    public static final int ARCHIVED_WEBSERVICE = 9;
    public static final int EXPLODED_WEBSERVICE = 10;
    public static final int ARCHIVED_CAR = 11;
    public static final int EXPLODED_CAR = 12;
    public static final String UNKNOWN_STRING = "UNKNOWN";
    public static final String ARCHIVED_EAR_STRING = "j2ee.ARCHIVED_EAR";
    public static final String EXPLODED_EAR_STRING = "j2ee.EXPLODED_EAR";
    public static final String ARCHIVED_WEB_STRING = "j2ee.ARCHIVED_WEB";
    public static final String EXPLODED_WEB_STRING = "j2ee.EXPLODED_WEB";
    public static final String ARCHIVED_RAR_STRING = "j2ee.ARCHIVED_RAR";
    public static final String EXPLODED_RAR_STRING = "j2ee.EXPLODED_RAR";
    public static final String ARCHIVED_EJB_STRING = "j2ee.ARCHIVED_EJB";
    public static final String EXPLODED_EJB_STRING = "j2ee.EXPLODED_EJB";
    public static final String ARCHIVED_CAR_STRING = "j2ee.ARCHIVED_CAR";
    public static final String EXPLODED_CAR_STRING = "j2ee.EXPLODED_CAR";
    public static final String ARCHIVED_WEBSERVICE_STRING = "ARCHIVED_WEBSERVICE";
    public static final String EXPLODED_WEBSERVICE_STRING = "EXPLODED_WEBSERVICE";
    public static String TYPE_EAR = "EAR";
    public static String TYPE_EXPLODED_EAR = "EXPLODED EAR";
    public static String TYPE_COMPONENT = "COMPONENT";
    public static String TYPE_EXPLODED_COMPONENT = "EXPLODED COMPONENT";
    public static String TYPE_UNKNOWN = "UNKNOWN";
    private int type;
    private String uri;
    private boolean exploded;

    DeploymentInfo(int n, String string) {
        this.type = n;
        this.uri = string;
        switch (n) {
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 12: {
                this.exploded = true;
                break;
            }
            default: {
                this.exploded = false;
            }
        }
    }

    public boolean isExploded() {
        return this.exploded;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getURI() {
        return this.uri;
    }

    public void setURI(String string) {
        this.uri = string;
    }

    public String toString() {
        String string = DeploymentInfo.asString(this.type);
        return "DeploymentInfo{" + this.uri + ", " + string + "}";
    }

    public static String asString(int n) {
        switch (n) {
            case 1: {
                return ARCHIVED_EAR_STRING;
            }
            case 2: {
                return EXPLODED_EAR_STRING;
            }
            case 3: {
                return ARCHIVED_WEB_STRING;
            }
            case 4: {
                return EXPLODED_WEB_STRING;
            }
            case 5: {
                return ARCHIVED_RAR_STRING;
            }
            case 6: {
                return EXPLODED_RAR_STRING;
            }
            case 7: {
                return ARCHIVED_EJB_STRING;
            }
            case 8: {
                return EXPLODED_EJB_STRING;
            }
            case 11: {
                return ARCHIVED_CAR_STRING;
            }
            case 12: {
                return EXPLODED_CAR_STRING;
            }
            case 9: {
                return ARCHIVED_WEBSERVICE_STRING;
            }
            case 10: {
                return EXPLODED_WEBSERVICE_STRING;
            }
        }
        return UNKNOWN_STRING;
    }

    public static String asStringCategory(int n) {
        switch (n) {
            case 1: {
                return TYPE_EAR;
            }
            case 2: {
                return TYPE_EXPLODED_EAR;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                return TYPE_COMPONENT;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                return TYPE_EXPLODED_COMPONENT;
            }
        }
        return UNKNOWN_STRING;
    }

    public static int asType(String string) {
        if (ARCHIVED_EAR_STRING.equals(string)) {
            return 1;
        }
        if (EXPLODED_EAR_STRING.equals(string)) {
            return 2;
        }
        if (ARCHIVED_WEB_STRING.equals(string)) {
            return 3;
        }
        if (EXPLODED_WEB_STRING.equals(string)) {
            return 4;
        }
        if (ARCHIVED_RAR_STRING.equals(string)) {
            return 5;
        }
        if (EXPLODED_RAR_STRING.equals(string)) {
            return 6;
        }
        if (ARCHIVED_EJB_STRING.equals(string)) {
            return 7;
        }
        if (EXPLODED_EJB_STRING.equals(string)) {
            return 8;
        }
        if (ARCHIVED_CAR_STRING.equals(string)) {
            return 11;
        }
        if (EXPLODED_CAR_STRING.equals(string)) {
            return 12;
        }
        if (ARCHIVED_WEBSERVICE_STRING.equals(string)) {
            return 9;
        }
        if (EXPLODED_WEBSERVICE_STRING.equals(string)) {
            return 10;
        }
        return 0;
    }
}

