/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import com.bea.wls.redef.runtime.ClassRedefinitionRuntimeMBean;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.descriptor.DescriptorBean;
import weblogic.ejb.spi.QueryCache;
import weblogic.ejb.spi.ReInitializableCache;
import weblogic.health.HealthMonitorService;
import weblogic.health.HealthState;
import weblogic.kodo.monitoring.KodoPersistenceUnitParent;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ApplicationRuntimeMBean;
import weblogic.management.runtime.CoherenceClusterRuntimeMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.management.runtime.KodoPersistenceUnitRuntimeMBean;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.management.runtime.MaxThreadsConstraintRuntimeMBean;
import weblogic.management.runtime.MinThreadsConstraintRuntimeMBean;
import weblogic.management.runtime.QueryCacheRuntimeMBean;
import weblogic.management.runtime.RequestClassRuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.management.runtime.WseeRuntimeMBean;
import weblogic.management.runtime.WseeV2RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.work.RequestClassRuntimeMBeanImpl;
import weblogic.work.WorkManager;

public final class J2EEApplicationRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements ApplicationRuntimeMBean,
KodoPersistenceUnitParent {
    private static final long serialVersionUID = 5618173476456700945L;
    private final String appName;
    private final String appId;
    private final String appVersion;
    private int activeVersionState = 0;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ReInitializableCache[] applicationCaches;
    private Set workManagerRuntimes = new HashSet();
    private Set minThreadsConstraintRuntimes = new HashSet();
    private Set maxThreadsConstraintRuntimes = new HashSet();
    private Set requestClassRuntimes = new HashSet();
    private ClassRedefinitionRuntimeMBean classRedefRuntime;
    private LibraryRuntimeMBean[] libraryRuntimes = null;
    private LibraryRuntimeMBean[] optionalPackages = null;
    private Set wseeRuntimes = new HashSet();
    private Map queryCacheRuntimes = new HashMap();
    private Map m_runtimePersistenUnit = new HashMap();
    private CoherenceClusterRuntimeMBean coherenceClusterRuntimeMBean;
    private final HashSet<WseeV2RuntimeMBean> wseeV2Runtimes = new HashSet();

    public J2EEApplicationRuntimeMBeanImpl(String string, SystemResourceMBean systemResourceMBean) throws ManagementException {
        super(string, null, true, (DescriptorBean)null);
        this.appName = systemResourceMBean.getName();
        this.appId = systemResourceMBean.getName();
        this.appVersion = null;
    }

    public J2EEApplicationRuntimeMBeanImpl(String string, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        super(string, null, true, (DescriptorBean)null);
        this.appName = appDeploymentMBean.getApplicationName();
        this.appId = appDeploymentMBean.getApplicationIdentifier();
        this.appVersion = appDeploymentMBean.getVersionIdentifier();
        HealthMonitorService.register(this.appId + "(Application)", this, false);
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getApplicationVersion() {
        return this.appVersion;
    }

    public int getActiveVersionState() {
        return this.activeVersionState;
    }

    public void setActiveVersionState(int n) {
        int n2 = this.activeVersionState;
        this.activeVersionState = n;
        this._postSet("ActiveVersionState", n2, this.activeVersionState);
    }

    public WorkManagerRuntimeMBean[] getWorkManagerRuntimes() {
        int n = this.workManagerRuntimes.size();
        return this.workManagerRuntimes.toArray(new WorkManagerRuntimeMBean[n]);
    }

    public WorkManagerRuntimeMBean lookupWorkManagerRuntime(String string, String string2) {
        WorkManagerRuntimeMBean[] workManagerRuntimeMBeanArray;
        if (string != null) {
            ComponentRuntimeMBean componentRuntimeMBean = this.lookupComponentRuntime(string);
            if (componentRuntimeMBean == null) {
                return null;
            }
            workManagerRuntimeMBeanArray = componentRuntimeMBean.getWorkManagerRuntimes();
        } else {
            workManagerRuntimeMBeanArray = this.getWorkManagerRuntimes();
        }
        for (int i = 0; i < workManagerRuntimeMBeanArray.length; ++i) {
            if (!workManagerRuntimeMBeanArray[i].getName().equals(string2)) continue;
            return workManagerRuntimeMBeanArray[i];
        }
        return null;
    }

    public WorkManagerRuntimeMBean lookupWorkManagerRuntime(WorkManager workManager) {
        if (workManager == null) {
            return null;
        }
        return this.lookupWorkManagerRuntime(workManager.getModuleName(), workManager.getName());
    }

    private ComponentRuntimeMBean lookupComponentRuntime(String string) {
        ComponentRuntimeMBean[] componentRuntimeMBeanArray = this.getComponentRuntimes();
        for (int i = 0; i < componentRuntimeMBeanArray.length; ++i) {
            if (!componentRuntimeMBeanArray[i].getName().equals(string)) continue;
            return componentRuntimeMBeanArray[i];
        }
        return null;
    }

    public boolean addWorkManager(WorkManagerRuntimeMBean workManagerRuntimeMBean) {
        return this.workManagerRuntimes.add(workManagerRuntimeMBean);
    }

    public QueryCacheRuntimeMBean[] getQueryCacheRuntimes() {
        Collection collection = this.queryCacheRuntimes.values();
        return collection.toArray(new QueryCacheRuntimeMBean[0]);
    }

    public QueryCacheRuntimeMBean lookupQueryCacheRuntime(String string) {
        return (QueryCacheRuntimeMBean)this.queryCacheRuntimes.get(string);
    }

    public void setQueryCacheRuntimes(Map map) throws ManagementException {
        for (String string : map.keySet()) {
            QueryCache queryCache = (QueryCache)map.get(string);
            QueryCacheRuntimeMBean queryCacheRuntimeMBean = queryCache.createRuntimeMBean(string, this);
            this.queryCacheRuntimes.put(string, queryCacheRuntimeMBean);
        }
    }

    public void setLibraryRuntimes(LibraryRuntimeMBean[] libraryRuntimeMBeanArray) {
        this.libraryRuntimes = libraryRuntimeMBeanArray;
    }

    public void setOptionalPackageRuntimes(LibraryRuntimeMBean[] libraryRuntimeMBeanArray) {
        this.optionalPackages = libraryRuntimeMBeanArray;
    }

    public LibraryRuntimeMBean[] getOptionalPackageRuntimes() {
        return this.optionalPackages;
    }

    public LibraryRuntimeMBean[] getLibraryRuntimes() {
        return this.libraryRuntimes;
    }

    public void addWseeRuntime(WseeRuntimeMBean wseeRuntimeMBean) {
        this.wseeRuntimes.add(wseeRuntimeMBean);
    }

    public WseeRuntimeMBean[] getWseeRuntimes() {
        int n = this.wseeRuntimes.size();
        return this.wseeRuntimes.toArray(new WseeRuntimeMBean[n]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeV2RuntimeMBean[] getWseeV2Runtimes() {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            int n = this.wseeV2Runtimes.size();
            return this.wseeV2Runtimes.toArray(new WseeV2RuntimeMBean[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WseeV2RuntimeMBean lookupWseeV2Runtime(String string) {
        WseeV2RuntimeMBean wseeV2RuntimeMBean = null;
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            for (WseeV2RuntimeMBean wseeV2RuntimeMBean2 : this.wseeV2Runtimes) {
                if (!wseeV2RuntimeMBean2.getName().equals(string)) continue;
                wseeV2RuntimeMBean = wseeV2RuntimeMBean2;
                break;
            }
        }
        return wseeV2RuntimeMBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWseeV2Runtime(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            this.wseeV2Runtimes.add(wseeV2RuntimeMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWseeV2Runtime(WseeV2RuntimeMBean wseeV2RuntimeMBean) {
        HashSet<WseeV2RuntimeMBean> hashSet = this.wseeV2Runtimes;
        synchronized (hashSet) {
            this.wseeV2Runtimes.remove(wseeV2RuntimeMBean);
        }
    }

    public MinThreadsConstraintRuntimeMBean lookupMinThreadsConstraintRuntime(String string) {
        MinThreadsConstraintRuntimeMBean[] minThreadsConstraintRuntimeMBeanArray = this.getMinThreadsConstraintRuntimes();
        for (int i = 0; i < minThreadsConstraintRuntimeMBeanArray.length; ++i) {
            if (!minThreadsConstraintRuntimeMBeanArray[i].getName().equals(string)) continue;
            return minThreadsConstraintRuntimeMBeanArray[i];
        }
        return null;
    }

    public RequestClassRuntimeMBean lookupRequestClassRuntime(String string) {
        RequestClassRuntimeMBean[] requestClassRuntimeMBeanArray = this.getRequestClassRuntimes();
        for (int i = 0; i < requestClassRuntimeMBeanArray.length; ++i) {
            if (!requestClassRuntimeMBeanArray[i].getName().equals(string)) continue;
            return requestClassRuntimeMBeanArray[i];
        }
        return null;
    }

    public MaxThreadsConstraintRuntimeMBean lookupMaxThreadsConstraintRuntime(String string) {
        MaxThreadsConstraintRuntimeMBean[] maxThreadsConstraintRuntimeMBeanArray = this.getMaxThreadsConstraintRuntimes();
        for (int i = 0; i < maxThreadsConstraintRuntimeMBeanArray.length; ++i) {
            if (!maxThreadsConstraintRuntimeMBeanArray[i].getName().equals(string)) continue;
            return maxThreadsConstraintRuntimeMBeanArray[i];
        }
        return null;
    }

    public boolean addMaxThreadsConstraint(MaxThreadsConstraintRuntimeMBean maxThreadsConstraintRuntimeMBean) {
        return this.maxThreadsConstraintRuntimes.add(maxThreadsConstraintRuntimeMBean);
    }

    public MaxThreadsConstraintRuntimeMBean[] getMaxThreadsConstraintRuntimes() {
        int n = this.maxThreadsConstraintRuntimes.size();
        return this.maxThreadsConstraintRuntimes.toArray(new MaxThreadsConstraintRuntimeMBean[n]);
    }

    public boolean addMinThreadsConstraint(MinThreadsConstraintRuntimeMBean minThreadsConstraintRuntimeMBean) {
        return this.minThreadsConstraintRuntimes.add(minThreadsConstraintRuntimeMBean);
    }

    public boolean addRequestClass(RequestClassRuntimeMBeanImpl requestClassRuntimeMBeanImpl) {
        return this.requestClassRuntimes.add(requestClassRuntimeMBeanImpl);
    }

    public RequestClassRuntimeMBean[] getRequestClassRuntimes() {
        int n = this.requestClassRuntimes.size();
        return this.requestClassRuntimes.toArray(new RequestClassRuntimeMBean[n]);
    }

    public MinThreadsConstraintRuntimeMBean[] getMinThreadsConstraintRuntimes() {
        int n = this.minThreadsConstraintRuntimes.size();
        return this.minThreadsConstraintRuntimes.toArray(new MinThreadsConstraintRuntimeMBean[n]);
    }

    public synchronized void removeChild(RuntimeMBeanDelegate runtimeMBeanDelegate) {
        if (runtimeMBeanDelegate instanceof WorkManagerRuntimeMBean) {
            this.workManagerRuntimes.remove(runtimeMBeanDelegate);
        } else if (runtimeMBeanDelegate instanceof RequestClassRuntimeMBean) {
            this.requestClassRuntimes.remove(runtimeMBeanDelegate);
        } else if (runtimeMBeanDelegate instanceof MinThreadsConstraintRuntimeMBean) {
            this.minThreadsConstraintRuntimes.remove(runtimeMBeanDelegate);
        } else if (runtimeMBeanDelegate instanceof MaxThreadsConstraintRuntimeMBean) {
            this.maxThreadsConstraintRuntimes.remove(runtimeMBeanDelegate);
        } else if (runtimeMBeanDelegate instanceof WseeRuntimeMBean) {
            this.wseeRuntimes.remove(runtimeMBeanDelegate);
        } else if (runtimeMBeanDelegate instanceof KodoPersistenceUnitRuntimeMBean) {
            this.m_runtimePersistenUnit.remove(((KodoPersistenceUnitRuntimeMBean)runtimeMBeanDelegate).getPersistenceUnitName());
        }
        super.removeChild(runtimeMBeanDelegate);
    }

    public void unregister() throws ManagementException {
        ServerRuntimeMBean serverRuntimeMBean;
        Object object6;
        super.unregister();
        HealthMonitorService.unregister(this.appId + "(Application)");
        for (Object object2 : this.workManagerRuntimes) {
            object2.unregister();
        }
        for (Object object3 : this.maxThreadsConstraintRuntimes) {
            object3.unregister();
        }
        for (Object object4 : this.minThreadsConstraintRuntimes) {
            object4.unregister();
        }
        for (Object object5 : this.requestClassRuntimes) {
            object5.unregister();
        }
        for (Object object6 : this.wseeRuntimes) {
            object6.unregister();
        }
        object6 = this.queryCacheRuntimes.keySet().iterator();
        while (object6.hasNext()) {
            serverRuntimeMBean = (RuntimeMBeanDelegate)this.queryCacheRuntimes.get((String)object6.next());
            serverRuntimeMBean.unregister();
        }
        serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        ((RuntimeMBeanDelegate)serverRuntimeMBean).removeChild((RuntimeMBeanDelegate)this);
    }

    public ComponentRuntimeMBean[] lookupComponents() {
        return this.getComponentRuntimes();
    }

    private void addCRM(List list, ComponentRuntimeMBean[] componentRuntimeMBeanArray) {
        if (componentRuntimeMBeanArray == null || componentRuntimeMBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < componentRuntimeMBeanArray.length; ++i) {
            if (componentRuntimeMBeanArray[i] == null) continue;
            list.add(componentRuntimeMBeanArray[i]);
        }
    }

    public ComponentRuntimeMBean[] getComponentRuntimes() {
        Module[] moduleArray = this.getAppCtx().getApplicationModules();
        if (moduleArray == null) {
            return new ComponentRuntimeMBean[0];
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < moduleArray.length; ++i) {
            this.addCRM(arrayList, moduleArray[i].getComponentRuntimeMBeans());
        }
        return arrayList.toArray(new ComponentRuntimeMBean[arrayList.size()]);
    }

    private ApplicationContextInternal getAppCtx() {
        ApplicationAccess applicationAccess = ApplicationAccess.getApplicationAccess();
        return applicationAccess.getApplicationContext(this.appId);
    }

    public boolean isEAR() {
        return this.getAppCtx().getApplicationDD() != null;
    }

    public void setApplicationCaches(ReInitializableCache[] reInitializableCacheArray) {
        this.applicationCaches = reInitializableCacheArray;
    }

    public boolean hasApplicationCache() {
        return this.applicationCaches != null && this.applicationCaches.length > 0;
    }

    public void reInitializeApplicationCachesAndPools() {
        if (this.applicationCaches != null) {
            for (int i = 0; i < this.applicationCaches.length; ++i) {
                this.applicationCaches[i].reInitializeCacheAndPools();
            }
        }
    }

    public HealthState getHealthState() {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        for (String[] stringArray2 : this.workManagerRuntimes) {
            int n2 = stringArray2.getHealthState().getState();
            if (n2 == 0) continue;
            if (n2 > n) {
                n = n2;
            }
            arrayList.addAll(Arrays.asList(stringArray2.getHealthState().getReasonCode()));
        }
        if (arrayList.size() == 0) {
            return new HealthState(n);
        }
        stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return new HealthState(n, stringArray2);
    }

    public KodoPersistenceUnitRuntimeMBean[] getKodoPersistenceUnitRuntimes() {
        KodoPersistenceUnitRuntimeMBean[] kodoPersistenceUnitRuntimeMBeanArray = new KodoPersistenceUnitRuntimeMBean[this.m_runtimePersistenUnit.size()];
        kodoPersistenceUnitRuntimeMBeanArray = this.m_runtimePersistenUnit.values().toArray(kodoPersistenceUnitRuntimeMBeanArray);
        return kodoPersistenceUnitRuntimeMBeanArray;
    }

    public KodoPersistenceUnitRuntimeMBean getKodoPersistenceUnitRuntime(String string) {
        return (KodoPersistenceUnitRuntimeMBean)this.m_runtimePersistenUnit.get(string);
    }

    public void addKodoPersistenceUnit(KodoPersistenceUnitRuntimeMBean kodoPersistenceUnitRuntimeMBean) {
        this.m_runtimePersistenUnit.put(kodoPersistenceUnitRuntimeMBean.getPersistenceUnitName(), kodoPersistenceUnitRuntimeMBean);
    }

    public ClassRedefinitionRuntimeMBean getClassRedefinitionRuntime() {
        return this.classRedefRuntime;
    }

    public void setClassRedefinitionRuntime(ClassRedefinitionRuntimeMBean classRedefinitionRuntimeMBean) {
        this.classRedefRuntime = classRedefinitionRuntimeMBean;
    }

    public CoherenceClusterRuntimeMBean getCoherenceClusterRuntime() {
        return this.coherenceClusterRuntimeMBean;
    }

    public void setCoherenceClusterRuntime(CoherenceClusterRuntimeMBean coherenceClusterRuntimeMBean) {
        this.coherenceClusterRuntimeMBean = coherenceClusterRuntimeMBean;
    }
}

