/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.j2ee.ApplicationCache;
import weblogic.j2ee.RMCFactoryDeployer;
import weblogic.management.DomainDir;
import weblogic.management.deploy.DeployerRuntimeTextTextFormatter;
import weblogic.management.internal.DeploymentHandlerHome;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.jars.VirtualJarFile;

public final class J2EEApplicationService
extends AbstractServerService {
    private static final List haltListeners = new ArrayList(1);
    private static final String TEMP_DIR_NAME = "tmp";
    private static J2EEApplicationService singleton;
    private static final AuthenticatedSubject kernelId;
    private static MultiClassFinder finder;
    private static File tempDir;
    private final RMCFactoryDeployer mailDeployer = new RMCFactoryDeployer();
    private static final String J2EE_TMP_DIR_NAME = "weblogic.j2ee.application.tmpDir";
    private static final String APPS_TMP_DIR;
    private static ApplicationCache applicationCache;
    private static List listeners;

    public J2EEApplicationService() {
        singleton = this;
    }

    public static J2EEApplicationService getJ2EEApplicationService() {
        return singleton;
    }

    public void start() throws ServiceFailureException {
        DeploymentHandlerHome.addDeploymentHandler(this.mailDeployer);
        applicationCache = ApplicationCache.getApplicationCache();
    }

    public void stop() throws ServiceFailureException {
        this.halt();
    }

    public void halt() throws ServiceFailureException {
        Iterator iterator = haltListeners.iterator();
        while (iterator.hasNext()) {
            ((HaltListener)iterator.next()).halt();
        }
        DeploymentHandlerHome.removeDeploymentHandler(this.mailDeployer);
        applicationCache = null;
    }

    public static String getCurrentApplicationName() {
        return ApplicationAccess.getApplicationAccess().getCurrentApplicationName();
    }

    public static ApplicationContext getCurrentApplicationContext() {
        return ApplicationAccess.getApplicationAccess().getCurrentApplicationContext();
    }

    public static File getTempDir() {
        if (tempDir != null) {
            return tempDir;
        }
        String string = APPS_TMP_DIR != null ? APPS_TMP_DIR : DomainDir.getRootDir();
        File file = new File(string + File.separator + "servers" + File.separator + ManagementService.getPropertyService(kernelId).getServerName(), TEMP_DIR_NAME);
        tempDir = new File(file.getAbsolutePath());
        String string2 = null;
        if (!tempDir.exists()) {
            if (!tempDir.mkdirs()) {
                string2 = "Create Failed for " + tempDir.toString();
            }
            J2EEApplicationService.writeReadmeFile();
        } else if (!tempDir.isDirectory()) {
            string2 = "Cannot create " + tempDir.toString() + ". Non directory file already exists with same name. Please remove it";
        }
        Debug.assertion((string2 == null ? 1 : 0) != 0, (String)(string2 + ". Server cannot deploy any webapps"));
        return tempDir;
    }

    private static void writeReadmeFile() {
        try {
            File file = new File(tempDir, "README.TXT");
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(DeployerRuntimeTextTextFormatter.getInstance().readmeContent());
            ((Writer)fileWriter).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void addApplicationLifecycleListener(ApplicationLifecycleListener applicationLifecycleListener) {
        ArrayList<ApplicationLifecycleListener> arrayList = new ArrayList<ApplicationLifecycleListener>(listeners.size() + 1);
        arrayList.addAll(listeners);
        arrayList.add(applicationLifecycleListener);
        listeners = arrayList;
    }

    public static synchronized void removeApplicationLifecycleListener(ApplicationLifecycleListener applicationLifecycleListener) {
        ArrayList arrayList = new ArrayList(listeners.size());
        arrayList.addAll(listeners);
        arrayList.remove(applicationLifecycleListener);
        listeners = arrayList;
    }

    public static List getApplicationLifecycleListeners() {
        return listeners;
    }

    private static void addManifestToClassLoader(GenericClassLoader genericClassLoader, ClassFinder classFinder) {
        if (classFinder == null) {
            return;
        }
        genericClassLoader.addClassFinder(classFinder);
    }

    public static void addClassFinder(GenericClassLoader genericClassLoader, ClassFinder classFinder) {
        genericClassLoader.addClassFinder(classFinder);
        J2EEApplicationService.addManifestToClassLoader(genericClassLoader, classFinder.getManifestFinder());
    }

    public static File getAltDDFile(String string, VirtualJarFile virtualJarFile) {
        File file = null;
        File[] fileArray = virtualJarFile.getRootFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            file = new File(fileArray[i], string);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    public static void registerHaltListener(HaltListener haltListener) {
        haltListeners.add(haltListener);
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        tempDir = null;
        APPS_TMP_DIR = System.getProperty(J2EE_TMP_DIR_NAME);
        listeners = Collections.EMPTY_LIST;
    }

    public static interface HaltListener {
        public void halt();
    }
}

