/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import weblogic.application.ApplicationFileManager;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.logging.Loggable;
import weblogic.management.ApplicationException;
import weblogic.management.WebLogicMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.utils.jars.VirtualJarFile;

public class J2EEUtils {
    private static final boolean debug = false;
    private static final String sep = File.separator;
    public static final String APP_DD_NAME = "application.xml";
    public static final String APP_DD_PATH = sep + "META-INF" + sep + "application.xml";
    public static final String APP_DD_URI = "META-INF/application.xml";
    public static final String WLAPP_DD_NAME = "weblogic-application.xml";
    public static final String WLAPP_DD_URI = "META-INF/weblogic-application.xml";
    public static final String WLAPP_DD_PATH = sep + "META-INF" + sep + "weblogic-application.xml";
    public static final String WEB_DD_NAME = "web.xml";
    public static final String WEB_DD_URI = "WEB-INF/web.xml";
    public static final String WEB_DD_PATH = sep + "WEB-INF" + sep + "web.xml";
    public static final String WLWEB_DD_NAME = "weblogic.xml";
    public static final String WLWEB_DD_URI = "WEB-INF/weblogic.xml";
    public static final String WEBSERVICE_DD_NAME = "web-services.xml";
    public static final String WEBSERVICE_DD_URI = "WEB-INF/web-services.xml";
    public static final String WEBSERVICE_DD_PATH = "WEB-INF" + File.separator + "web-services.xml";
    public static final String EJB_DD_NAME = "ejb-jar.xml";
    public static final String EJB_DD_URI = "META-INF/ejb-jar.xml";
    public static final String EJB_DD_PATH = sep + "META-INF" + sep + "ejb-jar.xml";
    public static final String PER_DD_NAME = "persistence.xml";
    public static final String PER_DD_URI = "META-INF/persistence.xml";
    public static final String PER_DD_PATH = sep + "META-INF" + sep + "persistence.xml";
    public static final String PERCONF_DD_NAME = "persistence-configuration.xml";
    public static final String PERCONF_DD_URI = "META-INF/persistence-configuration.xml";
    public static final String PERCONF_DD_PATH = sep + "META-INF" + sep + "persistence-configuration.xml";
    public static final String WLEJB_DD_NAME = "weblogic-ejb-jar.xml";
    public static final String WLEJB_DD_URI = "META-INF/weblogic-ejb-jar.xml";
    public static final String WLEJBCMP_DD_NAME = "weblogic-rdbms-jar.xml";
    public static final String RAR_DD_NAME = "ra.xml";
    public static final String RAR_DD_URI = "META-INF/ra.xml";
    public static final String RAR_DD_PATH = sep + "META-INF" + sep + "ra.xml";
    public static final String WLRAR_DD_NAME = "weblogic-ra.xml";
    public static final String WLRAR_DD_URI = "META-INF/weblogic-ra.xml";
    public static final String WLRAR_DD_PATH = sep + "META-INF" + sep + "weblogic-ra.xml";
    public static final String CAR_DD_NAME = "application-client.xml";
    public static final String CAR_DD_URI = "META-INF/application-client.xml";
    public static final String CAR_DD_PATH = sep + "META-INF" + sep + "application-client.xml";
    public static final String WLCAR_DD_NAME = "weblogic-application-client.xml";
    public static final String WLCAR_DD_URI = "META-INF/weblogic-application-client.xml";
    public static final String WLCAR_DD_PATH = sep + "META-INF" + sep + "weblogic-application-client.xml";
    public static final String APP_INF = "APP-INF";
    public static final String APP_INF_LIB = "APP-INF" + sep + "lib";
    public static final String APP_INF_CLASS = "APP-INF" + sep + "classes";
    public static final String APPLICATION_POSTFIX = ".ear";
    public static final String EJBJAR_POSTFIX = ".jar";
    public static final String WEBAPP_POSTFIX = ".war";
    public static final String CONNECTOR_POSTFIX = ".rar";
    public static final String CLIENT_POSTFIX = ".jar";
    public static final String JMS_POSTFIX = "-jms.xml";
    public static final String JDBC_POSTFIX = "-jdbc.xml";
    public static final int EAR = 0;
    public static final int COMPONENT = 1;
    public static final int EXPLODED_EAR = 2;
    public static final int EXPLODED_COMPONENT = 3;
    public static final int UNKNOWN = 4;
    public static final int SINGLE_FILE_COMPONENT = 5;
    public static final int NOT_INITIALIZED = 6;
    private static String EJB_MODULE_TYPE = "EJBComponent";
    private static String WEB_MODULE_TYPE = "WebAppComponent";
    private static String CONNECTOR_MODULE_TYPE = "ConnectorComponent";
    private static String WEBSERVICE_MODULE_TYPE = "WebServiceComponent";
    private static String JDBCPOOL_MODULE_TYPE = "JDBCPoolComponent";
    private static String JMS_MODULE_TYPE = "JMSComponent";
    private static String APPCLIENT_MODULE_TYPE = "AppClientComponent";

    public static final String getArchivePostfix(String string) {
        if (J2EEUtils.isValidArchiveName(string)) {
            return string.substring(string.length() - 3, string.length());
        }
        return null;
    }

    public static final String getWLSModulePostfix(String string) {
        if (J2EEUtils.isValidWLSModuleName(string)) {
            return string.substring(string.length() - 3, string.length());
        }
        return null;
    }

    public static final String getArchiveName(String string) {
        if (J2EEUtils.isValidArchiveName(string)) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    public static final String getWLSModuleName(String string) {
        if (J2EEUtils.isValidWLSModuleName(string)) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    public static final boolean isValidArchiveName(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(APPLICATION_POSTFIX) || J2EEUtils.isValidArchiveModuleName(string);
    }

    public static final boolean isValidArchiveModuleName(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(".jar") || string2.endsWith(WEBAPP_POSTFIX) || string2.endsWith(".jar") || string2.endsWith(CONNECTOR_POSTFIX);
    }

    public static final boolean isValidWLSModuleName(String string) {
        String string2 = string.toLowerCase();
        return string2.endsWith(JMS_POSTFIX) || string2.endsWith(JDBC_POSTFIX);
    }

    public static int getDeploymentCategory(ApplicationMBean applicationMBean) throws IOException {
        String string;
        int n = 4;
        if (applicationMBean != null && (string = applicationMBean.getPath()) != null) {
            File file = new File(string);
            if (!file.exists()) {
                throw new FileNotFoundException("No such path: " + file);
            }
            if (file.isDirectory()) {
                ApplicationFileManager applicationFileManager = ApplicationFileManager.newInstance(file.getCanonicalPath());
                VirtualJarFile virtualJarFile = applicationFileManager.getVirtualJarFile();
                if (virtualJarFile.getEntry(APP_DD_PATH) != null) {
                    n = 2;
                } else {
                    ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
                    if (componentMBeanArray != null && componentMBeanArray.length > 0) {
                        File file2;
                        n = J2EEUtils.isValidArchiveName(componentMBeanArray[0].getURI()) ? 1 : ((file2 = new File(applicationMBean.getPath() + File.separatorChar + componentMBeanArray[0].getURI())).isDirectory() ? 3 : 5);
                    }
                }
            } else if (file.toString().endsWith(APPLICATION_POSTFIX)) {
                n = 0;
            }
        }
        return n;
    }

    public static void addAppInfToClasspath(StringBuffer stringBuffer, File file) {
        File[] fileArray;
        File file2;
        File file3 = new File(file, APP_INF_CLASS);
        if (file3.exists() && file3.isDirectory()) {
            stringBuffer.append(file3.getPath());
            stringBuffer.append(File.pathSeparator);
        }
        if ((file2 = new File(file, APP_INF_LIB)).exists() && file2.isDirectory() && (fileArray = file2.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) continue;
                stringBuffer.append(fileArray[i].getPath());
                stringBuffer.append(File.pathSeparator);
            }
        }
    }

    public static String getAppScopedLinkPath(String string, String string2, Context context) throws NamingException {
        if (string.indexOf("#") > 0) {
            if (string.startsWith("../")) {
                string = J2EEUtils.makePathAbsolute(string, string2);
            }
            return string;
        }
        NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            String string3 = binding.getName();
            if (!string3.equals(string2 + "#" + string)) continue;
            return string3;
        }
        return J2EEUtils.findByName(context, string);
    }

    public static String makePathAbsolute(String string, String string2) {
        string2 = J2EEUtils.normalizeJarName(string2);
        int n = 0;
        int n2 = string2.length();
        while (string.regionMatches(n, "../", 0, 3)) {
            n += 3;
            if (n2 < 0) continue;
            n2 = string2.lastIndexOf(47, n2 - 1);
        }
        return string2.substring(0, n2 + 1) + string.substring(n);
    }

    public static String normalizeJarName(String string) {
        return J2EEUtils.escapeChars(string, new char[]{'\'', '\"', '.'});
    }

    public static String normalizeJNDIName(String string) {
        return J2EEUtils.escapeChars(string, new char[]{'/', '.'});
    }

    public static String escapeChars(String string, char[] cArray) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\\' && i < string.length() - 1) {
                stringBuffer.append(c).append(string.charAt(++i));
                continue;
            }
            for (int j = 0; j < cArray.length; ++j) {
                if (c != cArray[j]) continue;
                stringBuffer.append('\\');
                break;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String findByName(Context context, String string) throws NamingException {
        NamingEnumeration<Binding> namingEnumeration = context.listBindings("");
        while (namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            String string2 = binding.getName();
            if (!string2.endsWith("#" + string)) continue;
            return string2;
        }
        return null;
    }

    public static WebLogicMBean createComponentMBean(String string, String string2, String string3, ApplicationMBean applicationMBean) throws ApplicationException {
        String string4 = ApplicationVersionUtils.getApplicationId(string, string2);
        ComponentMBean componentMBean = null;
        if (string3.equals(EJB_MODULE_TYPE)) {
            componentMBean = applicationMBean.createEJBComponent(string4);
        } else if (string3.equals(WEB_MODULE_TYPE)) {
            componentMBean = applicationMBean.createWebAppComponent(string4);
        } else if (string3.equals(CONNECTOR_MODULE_TYPE)) {
            componentMBean = applicationMBean.createConnectorComponent(string4);
        } else if (string3.equals(WEBSERVICE_MODULE_TYPE)) {
            componentMBean = applicationMBean.createWebServiceComponent(string4);
        } else if (string3.equals(JDBCPOOL_MODULE_TYPE)) {
            componentMBean = applicationMBean.createJDBCPoolComponent(string4);
        } else if (string3.equals(JMS_MODULE_TYPE)) {
            componentMBean = applicationMBean.createDummyComponent(string4);
        } else {
            throw new AssertionError((Object)("Invalid Module type specified  :  " + string3));
        }
        if (componentMBean == null) {
            Loggable loggable = J2EELogger.logMBeanCreationFailureLoggable((String)string, (String)string3, (String)"Could not create MBean", null);
            throw new ApplicationException(loggable.getMessage());
        }
        return componentMBean;
    }
}

