/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import java.util.EmptyStackException;
import weblogic.connector.external.TrackableConnection;
import weblogic.ejb.spi.BeanInfo;
import weblogic.ejb.spi.SessionBeanInfo;
import weblogic.kernel.ThreadLocalStack;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class MethodInvocationHelper {
    private static final DebugCategory debug = Debug.getCategory((String)"weblogic.j2ee.MethodInvocation.debug");
    private static final DebugCategory verbose = Debug.getCategory((String)"weblogic.j2ee.MethodInvocation.verbose");
    private static final ThreadLocalStack threadMethodStorage = new ThreadLocalStack(true);

    public static void pushConnectionObject(TrackableConnection trackableConnection) {
        if (threadMethodStorage.peek() == null) {
            return;
        }
        MethodInvocationHelper.pushObject(trackableConnection);
    }

    public static void pushMethodObject(BeanInfo beanInfo) {
        if (beanInfo != null && !beanInfo.getIsResourceRef()) {
            return;
        }
        Object object = new Object();
        MethodInvocationHelper.pushObject(object);
    }

    private static void pushObject(Object object) {
        if (verbose.isEnabled()) {
            Debug.say((String)("pushMethodObject to push: '" + object.toString() + "' " + "', " + " currentMethod is: '" + MethodInvocationHelper.getCurrentObject() + "' " + "' "));
        }
        threadMethodStorage.push(object);
    }

    public static boolean popMethodObject(BeanInfo beanInfo) {
        if (beanInfo != null && !beanInfo.getIsResourceRef()) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = beanInfo instanceof SessionBeanInfo && !((SessionBeanInfo)beanInfo).isStateful();
        Object object = MethodInvocationHelper.popObject();
        while (object instanceof TrackableConnection) {
            TrackableConnection trackableConnection = (TrackableConnection)object;
            if (bl2 && trackableConnection.isLocalTransactionInProgress()) {
                bl = true;
            }
            trackableConnection.connectionClosed();
            object = MethodInvocationHelper.popObject();
        }
        return bl;
    }

    private static Object popObject() {
        if (verbose.isEnabled()) {
            Debug.say((String)("popObject,  before pop is: '" + MethodInvocationHelper.getCurrentObject() + "'"));
        }
        Object object = null;
        try {
            object = threadMethodStorage.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        if (verbose.isEnabled()) {
            Debug.say((String)("popObject,  after  pop is: '" + MethodInvocationHelper.getCurrentObject() + "'"));
        }
        return object;
    }

    public static Object getCurrentObject() {
        return threadMethodStorage.get();
    }
}

