/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.utils.DescriptorUtils;
import weblogic.j2ee.descriptor.wl.ConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ConnectionParamsBean;
import weblogic.j2ee.descriptor.wl.ConnectionPropertiesBean;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.j2ee.descriptor.wl.ParameterBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;

public final class PasswordEncrypt {
    public static boolean debug = false;

    public static void main(String[] stringArray) {
        System.out.println("");
        System.out.println("** This utility is deprecated and has been replaced by weblogic.security.Encrypt **");
        System.out.println("");
        if (stringArray != null && stringArray.length != 2) {
            System.err.println("Correct usage: java weblogic.j2ee.PasswordEncrypt <descriptor file> <domain_config_dir>");
            System.err.println("<descriptor file) --  the application's weblogic-application.xml");
            System.err.println("<domain_config_dir) -- server domain directory");
            System.exit(-1);
        }
        if (debug) {
            System.out.println("Args: " + stringArray[0] + " " + stringArray[1]);
        }
        PasswordEncrypt passwordEncrypt = new PasswordEncrypt();
        File file = null;
        try {
            file = new File(stringArray[0]).getCanonicalFile();
        }
        catch (IOException iOException) {
            System.err.println("Couldn't open " + stringArray[0] + " " + iOException.getMessage());
            System.exit(-1);
        }
        catch (SecurityException securityException) {
            System.err.println("Couldn't open " + stringArray[0] + " " + securityException.getMessage());
            System.exit(-1);
        }
        EncryptionService encryptionService = null;
        ClearOrEncryptedService clearOrEncryptedService = null;
        try {
            encryptionService = SerializedSystemIni.getEncryptionService(stringArray[1]);
            clearOrEncryptedService = new ClearOrEncryptedService(encryptionService);
        }
        catch (Exception exception) {
            System.err.println("Error obtaining EncryptionService using :" + stringArray[1] + " " + exception.getMessage());
            exception.printStackTrace();
            System.exit(-1);
        }
        passwordEncrypt.findAndUpdateWLSpwd(file, clearOrEncryptedService);
        System.out.println("Password Encrypting Complete.  Please use file " + stringArray[0] + " when creating your .ear file");
        System.exit(0);
    }

    private void findAndUpdateWLSpwd(File file, ClearOrEncryptedService clearOrEncryptedService) {
        WeblogicApplicationBean weblogicApplicationBean = null;
        ApplicationDescriptor applicationDescriptor = null;
        try {
            applicationDescriptor = new ApplicationDescriptor(null, new FileInputStream(file));
            weblogicApplicationBean = applicationDescriptor.getWeblogicApplicationDescriptor();
        }
        catch (IOException iOException) {
            System.err.println("IOException parsing descriptor file " + file.getName());
            iOException.printStackTrace();
            System.exit(-1);
        }
        catch (XMLStreamException xMLStreamException) {
            System.err.println("Error parsing descriptor file " + file.getName());
            xMLStreamException.printStackTrace();
            System.exit(-1);
        }
        JDBCConnectionPoolBean[] jDBCConnectionPoolBeanArray = weblogicApplicationBean.getJDBCConnectionPools();
        if (jDBCConnectionPoolBeanArray == null || jDBCConnectionPoolBeanArray.length <= 0) {
            System.out.println("There are no connectionPools to process.");
            return;
        }
        System.out.println("We have " + jDBCConnectionPoolBeanArray.length + " connectionPools defined");
        ConnectionFactoryBean connectionFactoryBean = null;
        ConnectionPropertiesBean connectionPropertiesBean = null;
        ConnectionParamsBean[] connectionParamsBeanArray = null;
        ParameterBean[] parameterBeanArray = null;
        String string = null;
        String string2 = null;
        for (int i = 0; i < jDBCConnectionPoolBeanArray.length; ++i) {
            connectionFactoryBean = jDBCConnectionPoolBeanArray[i].getConnectionFactory();
            connectionPropertiesBean = connectionFactoryBean.getConnectionProperties();
            string = connectionPropertiesBean.getPassword();
            if (string != null) {
                if (debug) {
                    System.out.println("BEFORE(topLevelPwd): " + string);
                }
                string = clearOrEncryptedService.encrypt(string);
                connectionPropertiesBean.setPassword(string);
                if (debug) {
                    System.out.println("AFTER(topLevelPwd): " + string);
                }
            }
            connectionParamsBeanArray = connectionPropertiesBean.getConnectionParams();
            for (int j = 0; j < connectionParamsBeanArray.length; ++j) {
                parameterBeanArray = connectionParamsBeanArray[j].getParameters();
                for (int k = 0; k < parameterBeanArray.length; ++k) {
                    if (!parameterBeanArray[k].getParamName().equals("password")) continue;
                    string2 = parameterBeanArray[k].getParamValue();
                    if (debug) {
                        System.out.println("BEFORE(propsPwd): " + string2);
                    }
                    string2 = clearOrEncryptedService.encrypt(string2);
                    parameterBeanArray[k].setParamValue(string2);
                    if (!debug) continue;
                    System.out.println("AFTER(propsPwd): " + string2);
                }
            }
        }
        if (string == null && string2 == null) {
            System.out.println("No ConnectionPool passwords defined");
            return;
        }
        try {
            DescriptorManager descriptorManager = new DescriptorManager();
            DescriptorBean descriptorBean = (DescriptorBean)applicationDescriptor.getWeblogicApplicationDescriptor();
            if (descriptorBean != null) {
                DescriptorUtils.writeDescriptor(descriptorManager, descriptorBean, file);
            }
        }
        catch (IOException iOException) {
            System.err.println("IOException obtaining writing out new descriptor file: " + iOException.getMessage());
            System.exit(-1);
        }
        catch (XMLStreamException xMLStreamException) {
            System.err.println("XMLStreamException writing out new descriptor file: " + xMLStreamException.getMessage());
            System.exit(-1);
        }
    }
}

