/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.MailSessionRuntimeMBeanImpl;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.MailSessionMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.AssertionError;

public final class RMCFactoryDeployer
implements DeploymentHandler {
    private final Map runtimes = new HashMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Context ctx;

    public RMCFactoryDeployer() {
        try {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("weblogic.jndi.createIntermediateContexts", "true");
            hashtable.put("weblogic.jndi.replicateBindings", "false");
            this.ctx = new InitialContext(hashtable);
        }
        catch (Exception exception) {
            throw new AssertionError("Cannot intialize Resource Manager Connection Factory resources because could not get JNDI context: " + exception.toString());
        }
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof MailSessionMBean) {
            this.deployMailSession((MailSessionMBean)deploymentMBean);
        }
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) {
        if (deploymentMBean instanceof MailSessionMBean) {
            try {
                this.undeployMailSession((MailSessionMBean)deploymentMBean);
            }
            catch (DeploymentException deploymentException) {
                J2EELogger.logFailedToUndeployMailSession((Throwable)((Object)deploymentException));
            }
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
    }

    private void deployMailSession(MailSessionMBean mailSessionMBean) throws DeploymentException {
        Properties properties = mailSessionMBean.getProperties();
        Session session = null;
        try {
            if (properties == null) {
                properties = new Properties();
            }
            session = Session.getInstance((Properties)properties, null);
        }
        catch (Exception exception) {
            throw new DeploymentException("Error received when trying to create a mail session", exception);
        }
        String string = mailSessionMBean.getJNDIName();
        try {
            if (session == null) {
                throw new DeploymentException("Unable to create a mail session to bind to JNDI Name " + string);
            }
            this.ctx.bind(string, (Object)session);
        }
        catch (NamingException namingException) {
            throw new DeploymentException("Could not bind a mail session to JNDI name " + string + " ", namingException);
        }
        J2EELogger.logDeployedMailSession((String)string);
        try {
            MailSessionRuntimeMBeanImpl mailSessionRuntimeMBeanImpl = new MailSessionRuntimeMBeanImpl(string);
            this.runtimes.put(string, mailSessionRuntimeMBeanImpl);
            ManagementService.getRuntimeAccess(kernelId).getServerRuntime().addMailSessionRuntime(mailSessionRuntimeMBeanImpl);
        }
        catch (ManagementException managementException) {
            this.undeployMailSession(mailSessionMBean);
            throw new DeploymentException(managementException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void undeployMailSession(MailSessionMBean mailSessionMBean) throws DeploymentException {
        String string = mailSessionMBean.getJNDIName();
        try {
            try {
                this.ctx.unbind(string);
            }
            catch (NamingException namingException) {
                throw new DeploymentException("Could not unbind a mail session from JNDI name " + string + " ", namingException);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            MailSessionRuntimeMBeanImpl mailSessionRuntimeMBeanImpl = (MailSessionRuntimeMBeanImpl)this.runtimes.get(string);
            if (mailSessionRuntimeMBeanImpl == null) throw throwable;
            try {
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().removeMailSessionRuntime(mailSessionRuntimeMBeanImpl);
                mailSessionRuntimeMBeanImpl.unregister();
                throw throwable;
            }
            catch (ManagementException managementException) {
                throw new DeploymentException(managementException);
            }
        }
        MailSessionRuntimeMBeanImpl mailSessionRuntimeMBeanImpl = (MailSessionRuntimeMBeanImpl)this.runtimes.get(string);
        if (mailSessionRuntimeMBeanImpl != null) {
            try {}
            catch (ManagementException managementException) {
                throw new DeploymentException(managementException);
            }
            ManagementService.getRuntimeAccess(kernelId).getServerRuntime().removeMailSessionRuntime(mailSessionRuntimeMBeanImpl);
            mailSessionRuntimeMBeanImpl.unregister();
        }
        J2EELogger.logUndeployedMailSession((String)string);
    }
}

