/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.customizers;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.shared.ModuleType;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.DescriptorHelper;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.VariableAssignmentBean;
import weblogic.j2ee.descriptor.wl.VariableBean;
import weblogic.j2ee.descriptor.wl.VariableDefinitionBean;

public class DeploymentPlanBeanCustomizer
implements weblogic.j2ee.descriptor.wl.customizers.DeploymentPlanBeanCustomizer {
    private static final boolean debug = false;
    private DescriptorHelper ddhelper = null;
    private DeploymentPlanBean plan;
    private List newBeans = new ArrayList();
    private int varCtr = 0;

    public DeploymentPlanBeanCustomizer(DeploymentPlanBean deploymentPlanBean) {
        this.plan = deploymentPlanBean;
    }

    private DescriptorHelper getDescriptorHelper() {
        if (this.ddhelper == null) {
            this.ddhelper = DescriptorHelper.getInstance();
        }
        return this.ddhelper;
    }

    public ModuleOverrideBean findModuleOverride(String string) {
        if (string == null) {
            return null;
        }
        ModuleOverrideBean[] moduleOverrideBeanArray = this.plan.getModuleOverrides();
        if (moduleOverrideBeanArray != null) {
            for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
                if (!string.equals(moduleOverrideBean.getModuleName())) continue;
                return moduleOverrideBean;
            }
        }
        return null;
    }

    public ModuleDescriptorBean findModuleDescriptor(String string, String string2) {
        ModuleOverrideBean moduleOverrideBean = this.findModuleOverride(string);
        if (moduleOverrideBean != null) {
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
            for (int i = 0; i < moduleDescriptorBeanArray.length; ++i) {
                ModuleDescriptorBean moduleDescriptorBean = moduleDescriptorBeanArray[i];
                if (!moduleDescriptorBean.getUri().endsWith(string2)) continue;
                return moduleDescriptorBean;
            }
        }
        return null;
    }

    public boolean rootModule(String string) {
        return this.rootModule(this.plan.findModuleOverride(string));
    }

    public boolean hasVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string) throws IllegalArgumentException {
        return this.findVariable(moduleDescriptorBean, descriptorBean, string, null, false) != null;
    }

    public void findAndRemoveAllBeanVariables(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean) throws IllegalArgumentException {
        if (moduleDescriptorBean == null) {
            throw new IllegalArgumentException("No module descriptor provided");
        }
        ArrayList<VariableAssignmentBean> arrayList = new ArrayList<VariableAssignmentBean>();
        ArrayList<VariableBean> arrayList2 = new ArrayList<VariableBean>();
        String string = this.getDescriptorHelper().buildKeyXpath(descriptorBean);
        VariableDefinitionBean variableDefinitionBean = this.plan.getVariableDefinition();
        VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBean.getVariableAssignments();
        VariableBean[] variableBeanArray = variableDefinitionBean.getVariables();
        if (variableAssignmentBeanArray == null) {
            throw new IllegalArgumentException("No VariableAssignemnts to remove for bean");
        }
        for (int i = 0; i < variableAssignmentBeanArray.length; ++i) {
            if (!variableAssignmentBeanArray[i].getXpath().startsWith(string)) continue;
            arrayList.add(variableAssignmentBeanArray[i]);
            for (int j = 0; j < variableBeanArray.length; ++j) {
                if (!variableBeanArray[j].getName().equals(variableAssignmentBeanArray[i].getName())) continue;
                arrayList2.add(variableBeanArray[j]);
            }
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("Unable to remove bean since not defined in plan");
        }
        for (VariableAssignmentBean variableAssignmentBean : arrayList) {
            moduleDescriptorBean.destroyVariableAssignment(variableAssignmentBean);
        }
        for (VariableBean variableBean : arrayList2) {
            variableDefinitionBean.destroyVariable(variableBean);
        }
        moduleDescriptorBean.setChanged(true);
    }

    public VariableBean findVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string) throws IllegalArgumentException {
        return this.findVariable(moduleDescriptorBean, descriptorBean, string, null, false);
    }

    private VariableBean findVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string, Object object, boolean bl) throws IllegalArgumentException {
        if (moduleDescriptorBean == null) {
            throw new IllegalArgumentException("No module descriptor provided");
        }
        VariableBean variableBean = null;
        String string2 = null;
        String string3 = this.getDescriptorHelper().buildXpath(descriptorBean, string, object, bl);
        VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBean.getVariableAssignments();
        if (variableAssignmentBeanArray != null) {
            VariableDefinitionBean variableDefinitionBean;
            VariableBean[] variableBeanArray;
            for (int i = 0; i < variableAssignmentBeanArray.length; ++i) {
                variableBeanArray = variableAssignmentBeanArray[i];
                if (!string3.equals(variableBeanArray.getXpath())) continue;
                string2 = variableBeanArray.getName();
                break;
            }
            if (string2 != null && (variableBeanArray = (variableDefinitionBean = this.plan.getVariableDefinition()).getVariables()) != null) {
                for (int i = 0; i < variableBeanArray.length; ++i) {
                    VariableBean variableBean2 = variableBeanArray[i];
                    if (!variableBean2.getName().equals(string2)) continue;
                    variableBean = variableBean2;
                    break;
                }
            }
        }
        return variableBean;
    }

    public VariableBean findOrCreateVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string) throws IllegalArgumentException {
        return this.findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, false, null, false);
    }

    public VariableBean findOrCreateVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string, boolean bl) throws IllegalArgumentException {
        return this.findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, bl, null, false);
    }

    public VariableBean findOrCreateVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string, boolean bl, Object object) throws IllegalArgumentException {
        return this.findOrCreateVariable(moduleDescriptorBean, descriptorBean, string, bl, object, true);
    }

    private VariableBean findOrCreateVariable(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string, boolean bl, Object object, boolean bl2) throws IllegalArgumentException {
        if (this.getDescriptorHelper().isTransient(descriptorBean, string)) {
            throw new IllegalArgumentException("Variables can't be created for transient properties");
        }
        VariableBean variableBean = this.findVariable(moduleDescriptorBean, descriptorBean, string, object, bl2);
        if (variableBean != null) {
            return variableBean;
        }
        VariableAssignmentBean variableAssignmentBean = moduleDescriptorBean.createVariableAssignment();
        variableAssignmentBean.setXpath(this.getDescriptorHelper().buildXpath(descriptorBean, string, object, bl2));
        if (bl2) {
            variableAssignmentBean.setOperation("replace");
        }
        String string2 = this._createVarName(moduleDescriptorBean, descriptorBean, string);
        variableAssignmentBean.setName(string2);
        if (bl) {
            String string3 = this.getDescriptorHelper().buildKeyXpath(descriptorBean);
            if (!this.newBeans.contains(string3)) {
                this.newBeans.add(string3);
            }
            variableAssignmentBean.setOrigin("planbased");
        }
        try {
            variableBean = this.findVariable(moduleDescriptorBean, descriptorBean, string, object, bl2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (variableBean != null) {
            return variableBean;
        }
        variableBean = this.plan.getVariableDefinition().createVariable();
        variableBean.setName(string2);
        return variableBean;
    }

    private String _createVarName(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string) {
        String string2 = new String();
        String string3 = descriptorBean.getClass().getName();
        string3 = string3.substring(string3.lastIndexOf(".") + 1, string3.length() - 8);
        string2 = string2 + string3 + "_";
        String string4 = this.getDescriptorHelper().findKey(descriptorBean);
        if (string4 != null) {
            string2 = string2 + this.getDescriptorHelper().getKeyValue(descriptorBean, string4) + "_";
        } else {
            String[] stringArray = this.getDescriptorHelper().findKeyComponents(descriptorBean);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string5 = stringArray[i];
                    string2 = string2 + this.getDescriptorHelper().getKeyValue(descriptorBean, string5) + "_";
                }
            }
        }
        string2 = string2 + string;
        if (!this.plan.isGlobalVariables()) {
            string2 = string2 + "_" + Long.toString(System.currentTimeMillis()) + Integer.toString(this.varCtr++);
        }
        return string2;
    }

    public VariableAssignmentBean[] findVariableAssignments(VariableBean variableBean) {
        ArrayList<VariableAssignmentBean> arrayList = new ArrayList<VariableAssignmentBean>();
        ModuleOverrideBean[] moduleOverrideBeanArray = this.plan.getModuleOverrides();
        if (moduleOverrideBeanArray != null) {
            for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
                ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
                if (moduleDescriptorBeanArray == null) continue;
                for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                    ModuleDescriptorBean moduleDescriptorBean = moduleDescriptorBeanArray[j];
                    VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBean.getVariableAssignments();
                    if (variableAssignmentBeanArray == null) continue;
                    for (int k = 0; k < variableAssignmentBeanArray.length; ++k) {
                        VariableAssignmentBean variableAssignmentBean = variableAssignmentBeanArray[k];
                        if (variableBean != this._findVar(variableAssignmentBean)) continue;
                        arrayList.add(variableAssignmentBean);
                    }
                }
            }
        }
        return arrayList.toArray(new VariableAssignmentBean[0]);
    }

    public Object valueOf(VariableBean variableBean) {
        return variableBean.getValue();
    }

    public VariableAssignmentBean assignVariable(VariableBean variableBean, ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string) {
        VariableAssignmentBean variableAssignmentBean = this._createAssignment(moduleDescriptorBean, descriptorBean, string);
        variableAssignmentBean.setName(variableBean.getName());
        return variableAssignmentBean;
    }

    private VariableBean _findVar(VariableAssignmentBean variableAssignmentBean) {
        VariableBean[] variableBeanArray = this.plan.getVariableDefinition().getVariables();
        if (variableBeanArray != null) {
            for (int i = 0; i < variableBeanArray.length; ++i) {
                VariableBean variableBean = variableBeanArray[i];
                if (!variableBean.getName().equals(variableAssignmentBean.getName())) continue;
                return variableBean;
            }
        }
        return null;
    }

    private VariableAssignmentBean _createAssignment(ModuleDescriptorBean moduleDescriptorBean, DescriptorBean descriptorBean, String string) {
        String string2 = this.getDescriptorHelper().buildXpath(descriptorBean, string);
        VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBean.getVariableAssignments();
        VariableAssignmentBean variableAssignmentBean = null;
        if (variableAssignmentBeanArray != null) {
            for (int i = 0; i < variableAssignmentBeanArray.length; ++i) {
                if (!string2.equals(variableAssignmentBeanArray[i].getXpath())) continue;
                variableAssignmentBean = variableAssignmentBeanArray[i];
                break;
            }
        }
        if (variableAssignmentBean == null) {
            variableAssignmentBean = moduleDescriptorBean.createVariableAssignment();
            variableAssignmentBean.setXpath(string2);
        }
        return variableAssignmentBean;
    }

    public ModuleOverrideBean findRootModule() {
        ModuleOverrideBean[] moduleOverrideBeanArray = this.plan.getModuleOverrides();
        if (moduleOverrideBeanArray != null) {
            for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                if (!this.rootModule(moduleOverrideBeanArray[i])) continue;
                return moduleOverrideBeanArray[i];
            }
        }
        return null;
    }

    private boolean rootModule(ModuleOverrideBean moduleOverrideBean) {
        if (moduleOverrideBean == null) {
            return false;
        }
        if (moduleOverrideBean.getModuleType().equals(ModuleType.EAR.toString())) {
            return true;
        }
        return this.plan.getModuleOverrides().length == 1;
    }

    public boolean isRemovable(DescriptorBean descriptorBean) throws IllegalArgumentException {
        if (descriptorBean == null) {
            throw new IllegalArgumentException("No descriptor bean provided");
        }
        String string = this.getDescriptorHelper().buildKeyXpath(descriptorBean);
        if (this.newBeans.contains(string)) {
            return true;
        }
        ModuleOverrideBean[] moduleOverrideBeanArray = this.plan.getModuleOverrides();
        if (moduleOverrideBeanArray != null) {
            for (int i = 0; i < moduleOverrideBeanArray.length; ++i) {
                ModuleOverrideBean moduleOverrideBean = moduleOverrideBeanArray[i];
                ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
                if (moduleDescriptorBeanArray == null) continue;
                for (int j = 0; j < moduleDescriptorBeanArray.length; ++j) {
                    ModuleDescriptorBean moduleDescriptorBean = moduleDescriptorBeanArray[j];
                    VariableAssignmentBean[] variableAssignmentBeanArray = moduleDescriptorBean.getVariableAssignments();
                    if (variableAssignmentBeanArray == null) continue;
                    for (int k = 0; k < variableAssignmentBeanArray.length; ++k) {
                        String string2 = variableAssignmentBeanArray[k].getXpath();
                        if (!string2.startsWith(string) || !variableAssignmentBeanArray[k].getOrigin().equals("planbased") || string2.lastIndexOf(47) > string.length()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

