/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import weblogic.j2ee.dd.EJBModuleDescriptor;
import weblogic.j2ee.dd.ModuleDescriptor;
import weblogic.j2ee.dd.RoleDescriptor;
import weblogic.j2ee.dd.WebModuleDescriptor;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.TopLevelDescriptorMBean;
import weblogic.management.descriptors.XMLElementMBean;
import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.application.ConnectorModuleMBean;
import weblogic.management.descriptors.application.EJBModuleMBean;
import weblogic.management.descriptors.application.J2EEApplicationDescriptorMBean;
import weblogic.management.descriptors.application.JavaModuleMBean;
import weblogic.management.descriptors.application.ModuleMBean;
import weblogic.management.descriptors.application.SecurityRoleMBean;
import weblogic.management.descriptors.application.WebModuleMBean;
import weblogic.management.descriptors.webapp.UIMBean;
import weblogic.utils.Debug;
import weblogic.utils.application.WarDetector;
import weblogic.utils.io.XMLWriter;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class J2EEDeploymentDescriptor
extends XMLElementMBeanDelegate
implements J2EEApplicationDescriptorMBean,
TopLevelDescriptorMBean,
UIMBean {
    private static final long serialVersionUID = 5882884876092791011L;
    private static boolean debug = false;
    private String version;
    private String description;
    private String displayName;
    private String largeIconFileName;
    private String smallIconFileName;
    private ArrayList orderedModules = new ArrayList();
    private HashMap roleDescriptors = new HashMap();
    private String j2eeAppDescrEncoding = null;
    private String descriptorVersion = null;

    public void setEncoding(String string) {
        String string2 = this.j2eeAppDescrEncoding;
        this.j2eeAppDescrEncoding = string;
        this.checkChange("encoding", string2, this.j2eeAppDescrEncoding);
    }

    public String getEncoding() {
        return this.j2eeAppDescrEncoding;
    }

    public String getVersion() {
        return this.descriptorVersion;
    }

    public void setVersion(String string) {
        this.descriptorVersion = string;
    }

    public J2EEDeploymentDescriptor() {
    }

    public J2EEDeploymentDescriptor(JarFile jarFile) throws IOException {
        this(VirtualJarFactory.createVirtualJar((JarFile)jarFile));
    }

    public J2EEDeploymentDescriptor(VirtualJarFile virtualJarFile) {
        Iterator iterator = virtualJarFile.entries();
        while (iterator.hasNext()) {
            JarEntry jarEntry = (JarEntry)iterator.next();
            String string = jarEntry.getName();
            if (string.indexOf(47) != string.lastIndexOf(47)) continue;
            if (string.startsWith("/")) {
                string = string.substring(1, string.length());
            }
            ModuleDescriptor moduleDescriptor = null;
            if (WarDetector.instance.suffixed(string)) {
                if (debug) {
                    Debug.say((String)"found web app...");
                }
                moduleDescriptor = new WebModuleDescriptor(string, null);
            } else if (string.endsWith(".jar")) {
                moduleDescriptor = new EJBModuleDescriptor(string);
            } else {
                String string2 = string;
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                String string3 = string2 + "META-INF/ejb-jar.xml";
                String string4 = string2 + "WEB-INF/web.xml";
                if (virtualJarFile.getEntry(string4) != null) {
                    moduleDescriptor = new WebModuleDescriptor(string, string);
                } else if (virtualJarFile.getEntry(string3) != null) {
                    moduleDescriptor = new EJBModuleDescriptor(string);
                }
            }
            if (moduleDescriptor == null) continue;
            this.addModuleDescriptor(moduleDescriptor);
        }
        this.displayName = virtualJarFile.getName();
        this.description = "Exploded J2EE Application, " + this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        if (debug) {
            Debug.say((String)("setDescription(" + string + ")"));
        }
        String string2 = this.description;
        this.description = string;
        this.checkChange("description", string2, string);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        if (debug) {
            Debug.say((String)("setDisplayName(" + string + ")"));
        }
        String string2 = this.displayName;
        this.displayName = string;
        this.checkChange("displayName", string2, string);
    }

    public String getLargeIconFileName() {
        return this.largeIconFileName;
    }

    public void setLargeIconFileName(String string) {
        if (debug) {
            Debug.say((String)("setLargeIconFileName(" + string + ")"));
        }
        String string2 = this.largeIconFileName;
        this.largeIconFileName = string;
        this.checkChange("largeIconFileName", string2, this.largeIconFileName);
    }

    public String getSmallIconFileName() {
        return this.smallIconFileName;
    }

    public void setSmallIconFileName(String string) {
        if (debug) {
            Debug.say((String)("setSmallIconFileName(" + string + ")"));
        }
        String string2 = this.smallIconFileName;
        this.smallIconFileName = string;
        this.checkChange("smallIconFileName", string2, this.smallIconFileName);
    }

    public void setJ2EEVersion(String string) {
        String string2 = this.version;
        this.version = string;
        this.checkChange("j2eeVersion", string2, string);
    }

    public void addModuleDescriptor(ModuleDescriptor moduleDescriptor) {
        Debug.assertion((moduleDescriptor.getName() != null && moduleDescriptor.getName().length() > 0 ? 1 : 0) != 0, (String)(moduleDescriptor != null ? moduleDescriptor.getName() : "<null>"));
        this.addModuleDescriptor(moduleDescriptor, moduleDescriptor.getName());
    }

    private void addModuleDescriptor(ModuleDescriptor moduleDescriptor, String string) {
        this.orderedModules.add(moduleDescriptor);
    }

    public void addModule(ModuleMBean moduleMBean) {
        Debug.assertion((moduleMBean.getName() != null && moduleMBean.getName().length() > 0 ? 1 : 0) != 0);
        this.addModuleDescriptor((ModuleDescriptor)moduleMBean, moduleMBean.getModuleKey());
        Debug.assertion((boolean)Arrays.asList((Object[])this.getModules()).contains(moduleMBean));
    }

    public void addEJBModule(EJBModuleMBean eJBModuleMBean) {
        Debug.assertion((eJBModuleMBean.getName() != null && eJBModuleMBean.getName().length() > 0 ? 1 : 0) != 0);
        this.addModule(eJBModuleMBean);
        Debug.assertion((boolean)Arrays.asList((Object[])this.getEJBModules()).contains(eJBModuleMBean));
    }

    public void addJavaModule(JavaModuleMBean javaModuleMBean) {
        Debug.assertion((javaModuleMBean.getName() != null && javaModuleMBean.getName().length() > 0 ? 1 : 0) != 0);
        this.addModule(javaModuleMBean);
        Debug.assertion((boolean)Arrays.asList((Object[])this.getJavaModules()).contains(javaModuleMBean));
    }

    public void addWebModule(WebModuleMBean webModuleMBean) {
        Debug.assertion((webModuleMBean.getName() != null && webModuleMBean.getName().length() > 0 ? 1 : 0) != 0);
        this.addModule(webModuleMBean);
        Debug.assertion((boolean)Arrays.asList((Object[])this.getWebModules()).contains(webModuleMBean));
    }

    public void addConnectorModule(ConnectorModuleMBean connectorModuleMBean) {
        Debug.assertion((connectorModuleMBean.getName() != null && connectorModuleMBean.getName().length() > 0 ? 1 : 0) != 0);
        this.addModule(connectorModuleMBean);
        Debug.assertion((boolean)Arrays.asList((Object[])this.getConnectorModules()).contains(connectorModuleMBean));
    }

    private void removeModule(ModuleMBean moduleMBean) {
        int n = this.orderedModules.indexOf(moduleMBean);
        if (n > -1) {
            this.orderedModules.remove(n);
        }
    }

    public ModuleDescriptor removeBean(String string) {
        ModuleDescriptor moduleDescriptor = this.getModule(string);
        int n = this.orderedModules.indexOf(moduleDescriptor);
        Object e = this.orderedModules.remove(n);
        if (debug) {
            if (e != null) {
                Debug.say((String)"FOUND!");
            } else {
                Debug.say((String)"NOT FOUND!");
            }
        }
        return (ModuleDescriptor)e;
    }

    public void removeEJBModule(EJBModuleMBean eJBModuleMBean) {
        this.removeModule(eJBModuleMBean);
        Debug.assertion((!Arrays.asList((Object[])this.getEJBModules()).contains(eJBModuleMBean) ? 1 : 0) != 0);
    }

    public void removeJavaModule(JavaModuleMBean javaModuleMBean) {
        this.removeModule(javaModuleMBean);
        Debug.assertion((!Arrays.asList((Object[])this.getJavaModules()).contains(javaModuleMBean) ? 1 : 0) != 0);
    }

    public void removeWebModule(WebModuleMBean webModuleMBean) {
        this.removeModule(webModuleMBean);
        Debug.assertion((!Arrays.asList((Object[])this.getWebModules()).contains(webModuleMBean) ? 1 : 0) != 0);
    }

    public void removeConnectorModule(ConnectorModuleMBean connectorModuleMBean) {
        this.removeModule(connectorModuleMBean);
        Debug.assertion((!Arrays.asList((Object[])this.getConnectorModules()).contains(connectorModuleMBean) ? 1 : 0) != 0);
    }

    public ModuleDescriptor getModule(String string) {
        ModuleDescriptor moduleDescriptor = null;
        for (ModuleDescriptor moduleDescriptor2 : this.orderedModules) {
            if (!moduleDescriptor2.getURI().equals(string)) continue;
            moduleDescriptor = moduleDescriptor2;
            break;
        }
        return moduleDescriptor;
    }

    public void setModules(ModuleMBean[] moduleMBeanArray) {
        ModuleMBean[] moduleMBeanArray2 = this.getModules();
        this.orderedModules.clear();
        for (int i = 0; i < moduleMBeanArray.length; ++i) {
            this.addModuleDescriptor((ModuleDescriptor)moduleMBeanArray[i]);
        }
        this.checkChange("modules", moduleMBeanArray2, moduleMBeanArray);
    }

    public ModuleMBean[] getWebModules() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getAllModules()) {
            if (!(e instanceof WebModuleMBean)) continue;
            arrayList.add(e);
            Debug.assertion((((ModuleMBean)e).getName() != null && ((ModuleMBean)e).getName().length() > 0 ? 1 : 0) != 0);
        }
        ModuleMBean[] moduleMBeanArray = new ModuleMBean[]{};
        return arrayList.toArray(moduleMBeanArray);
    }

    public ModuleMBean[] getEJBModules() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getAllModules()) {
            if (!(e instanceof EJBModuleMBean)) continue;
            arrayList.add(e);
            Debug.assertion((((ModuleMBean)e).getName() != null && ((ModuleMBean)e).getName().length() > 0 ? 1 : 0) != 0);
        }
        ModuleMBean[] moduleMBeanArray = new ModuleMBean[]{};
        return arrayList.toArray(moduleMBeanArray);
    }

    public ModuleMBean[] getJavaModules() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getAllModules()) {
            if (!(e instanceof JavaModuleMBean)) continue;
            arrayList.add(e);
            Debug.assertion((((ModuleMBean)e).getName() != null && ((ModuleMBean)e).getName().length() > 0 ? 1 : 0) != 0);
        }
        ModuleMBean[] moduleMBeanArray = new ModuleMBean[]{};
        return arrayList.toArray(moduleMBeanArray);
    }

    public ModuleMBean[] getConnectorModules() {
        ArrayList arrayList = new ArrayList();
        for (Object e : this.getAllModules()) {
            if (!(e instanceof ConnectorModuleMBean)) continue;
            arrayList.add(e);
            Debug.assertion((((ModuleMBean)e).getName() != null && ((ModuleMBean)e).getName().length() > 0 ? 1 : 0) != 0);
        }
        ModuleMBean[] moduleMBeanArray = new ModuleMBean[]{};
        return arrayList.toArray(moduleMBeanArray);
    }

    public ModuleMBean[] getModules() {
        ModuleMBean[] moduleMBeanArray = new ModuleMBean[]{};
        return this.orderedModules.toArray(moduleMBeanArray);
    }

    public Collection getAllModules() {
        return this.orderedModules;
    }

    private ModuleMBean[] getModules(Class clazz) {
        ModuleMBean[] moduleMBeanArray = new ModuleMBean[]{};
        ArrayList<ModuleMBean> arrayList = new ArrayList<ModuleMBean>();
        for (ModuleMBean moduleMBean : this.orderedModules) {
            if (debug) {
                Debug.say((String)("module mbean is " + moduleMBean + ", with getClass=" + moduleMBean.getClass()));
            }
            Debug.assertion((moduleMBean.getName() != null ? 1 : 0) != 0);
            if (moduleMBean.getClass() != clazz) continue;
            arrayList.add(moduleMBean);
        }
        return arrayList.toArray(moduleMBeanArray);
    }

    public SecurityRoleMBean[] getSecurityRoles() {
        SecurityRoleMBean[] securityRoleMBeanArray = new SecurityRoleMBean[]{};
        return this.roleDescriptors.values().toArray(securityRoleMBeanArray);
    }

    public void setSecurityRoles(SecurityRoleMBean[] securityRoleMBeanArray) {
        SecurityRoleMBean[] securityRoleMBeanArray2 = this.getSecurityRoles();
        this.roleDescriptors = new HashMap();
        for (int i = 0; i < securityRoleMBeanArray.length; ++i) {
            this.roleDescriptors.put(securityRoleMBeanArray[i].getName(), securityRoleMBeanArray[i]);
        }
        this.checkChange("securityRoles", securityRoleMBeanArray2, securityRoleMBeanArray);
    }

    public RoleDescriptor getRoleDescriptor(String string) {
        return (RoleDescriptor)this.roleDescriptors.get(string);
    }

    public Collection getAllRoleDescriptors() {
        return this.roleDescriptors.values();
    }

    public void addRoleDescriptor(RoleDescriptor roleDescriptor) {
        this.addRoleDescriptor(roleDescriptor, roleDescriptor.getName());
    }

    private void addRoleDescriptor(RoleDescriptor roleDescriptor, String string) {
        this.roleDescriptors.put(string, roleDescriptor);
    }

    public void addSecurityRole(SecurityRoleMBean securityRoleMBean) {
        this.addRoleDescriptor((RoleDescriptor)securityRoleMBean, securityRoleMBean.getRoleName());
        if (debug) {
            Debug.say((String)("add security role ... roles descriptors ...\n" + this.roleDescriptors.values()));
        }
    }

    public void removeSecurityRole(SecurityRoleMBean securityRoleMBean) {
        if (this.removeRoleDescriptor(((RoleDescriptor)securityRoleMBean).getRoleName()) == null && debug) {
            Debug.say((String)"REALLY NOT FOUND!");
        }
    }

    public RoleDescriptor removeRoleDescriptor(String string) {
        RoleDescriptor roleDescriptor = (RoleDescriptor)this.roleDescriptors.remove(string);
        return roleDescriptor;
    }

    public String toXML(int n) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xMLWriter = new XMLWriter((Writer)stringWriter);
        xMLWriter.setIndent(n);
        this.toXML(xMLWriter);
        return stringWriter.toString();
    }

    public void toXML(XMLWriter xMLWriter) {
        String string;
        String string2 = this.getEncoding();
        if (string2 != null) {
            xMLWriter.println("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
        }
        int n = 3;
        xMLWriter.println("<!DOCTYPE application PUBLIC '-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN' 'http://java.sun.com/dtd/application_1_3.dtd'>");
        xMLWriter.println("<application>");
        xMLWriter.incrIndent();
        String string3 = this.getSmallIconFileName();
        String string4 = this.getLargeIconFileName();
        if (string3 != null || string4 != null) {
            xMLWriter.println("<icon>");
            xMLWriter.incrIndent();
            if (string3 != null) {
                xMLWriter.println("<small-icon>" + string3 + "</small-icon>");
            }
            if (string4 != null) {
                xMLWriter.println("<large-icon>" + string4 + "</large-icon>");
            }
            xMLWriter.println("</icon>");
            xMLWriter.decrIndent();
        }
        if ((string = this.getDisplayName()) == null) {
            string = "";
        }
        xMLWriter.println("<display-name>" + string + "</display-name>");
        if (this.getDescription() != null) {
            xMLWriter.println("<description>" + this.getDescription() + "</description>");
        }
        if (debug) {
            Debug.say((String)("toXML ... modules ...\n" + this.getAllModules()));
        }
        ModuleMBean[] moduleMBeanArray = this.getModules();
        for (int i = 0; i < moduleMBeanArray.length; ++i) {
            ((ModuleDescriptor)moduleMBeanArray[i]).toXML(xMLWriter);
        }
        if (this.roleDescriptors != null) {
            if (debug) {
                Debug.say((String)("toXML ... roles descriptors ...\n" + this.roleDescriptors));
            }
            for (SecurityRoleMBean securityRoleMBean : this.roleDescriptors.values()) {
                int n2 = xMLWriter.getIndent();
                xMLWriter.printNoIndent(securityRoleMBean.toXML(n2));
            }
        }
        xMLWriter.decrIndent();
        xMLWriter.println("</application>");
    }

    public String toString() {
        String string = "J2EE Deployment Descriptor for " + this.getDisplayName();
        string = string + "\n Description: " + this.getDescription();
        string = string + "\n Modules: " + this.orderedModules.size();
        string = string + "\n Security Roles: " + this.roleDescriptors.size();
        return string;
    }

    public void validate() throws DescriptorValidationException {
        throw new RuntimeException("NYI");
    }

    public void usePersistenceDestination(String string) {
        throw new RuntimeException("NYI");
    }

    public void persist() throws IOException {
        throw new RuntimeException("NYI");
    }

    public void persist(Properties properties) throws IOException {
    }

    public void unregister() throws ManagementException {
        super.unregister();
        for (XMLElementMBean xMLElementMBean : this.getAllRoleDescriptors()) {
            xMLElementMBean.unregister();
        }
        for (XMLElementMBean xMLElementMBean : this.getAllModules()) {
            xMLElementMBean.unregister();
        }
    }

    public String toXML() {
        StringWriter stringWriter = new StringWriter();
        this.toXML(new XMLWriter((Writer)stringWriter));
        return stringWriter.toString();
    }

    public void addDescriptorError(String string) {
    }

    public void removeDescriptorError(String string) {
    }

    public boolean isValid() {
        return true;
    }

    public String[] getDescriptorErrors() {
        return null;
    }

    public void setDescriptorErrors(String[] stringArray) {
    }
}

