/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml;

import com.sun.java.xml.ns.javaee.HandlerChainType;
import com.sun.java.xml.ns.javaee.PortComponentHandlerType;
import commonj.timers.TimerManager;
import commonj.work.WorkManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBs;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jws.HandlerChain;
import javax.mail.Session;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContexts;
import javax.persistence.PersistenceUnit;
import javax.persistence.PersistenceUnits;
import javax.sql.DataSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceRef;
import javax.xml.ws.WebServiceRefs;
import org.omg.CORBA_2_3.ORB;
import org.w3c.dom.Node;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.Visitor;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.j2ee.dd.xml.AnnotationProcessException;
import weblogic.j2ee.dd.xml.AnnotationProcessor;
import weblogic.j2ee.dd.xml.HandlerChainLoader;
import weblogic.j2ee.dd.xml.J2eeAnnotationProcessor;
import weblogic.j2ee.dd.xml.JCAConnectionFactoryProvider;
import weblogic.j2ee.dd.xml.validator.AnnotationValidatorVisitor;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerChainBean;
import weblogic.j2ee.descriptor.ServiceRefHandlerChainsBean;
import weblogic.j2ee.extensions.ExtensionManager;
import weblogic.j2ee.extensions.InjectionExtension;
import weblogic.javaee.EJBReference;
import weblogic.kernel.KernelStatus;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.ErrorCollectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseJ2eeAnnotationProcessor
implements AnnotationProcessor {
    private static boolean productionMode = false;
    private Map<Class<?>, List<Method>> methodsCache = new HashMap();
    private ErrorCollectionException errors;

    @Override
    public void processJ2eeAnnotations(Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) throws ErrorCollectionException {
        this.processJ2eeAnnotations(clazz, j2eeClientEnvironmentBean);
        if (bl) {
            this.throwProcessingErrors();
        }
    }

    protected void processJ2eeAnnotations(Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        Object object;
        this.addDescriptorDefaults(clazz, j2eeClientEnvironmentBean);
        List<Field> list = this.getFields(clazz);
        List<Method> list2 = this.getMethods(clazz);
        for (Field collection2 : list) {
            this.processField(collection2, j2eeClientEnvironmentBean);
        }
        this.processMethods(list2, j2eeClientEnvironmentBean);
        Collection<Resource> collection3 = this.getClassResources(clazz).values();
        Iterator iterator = collection3.iterator();
        while (iterator.hasNext()) {
            object = (Resource)iterator.next();
            this.addEnvironmentEntry((Resource)object, j2eeClientEnvironmentBean);
        }
        Collection<EJB> collection = this.getClassEJBRefs(clazz).values();
        for (EJB eJB : collection) {
            this.addEjbRef(eJB, j2eeClientEnvironmentBean);
        }
        object = this.getClassPersistenceUnitRefs(clazz).values();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            PersistenceUnit persistenceUnit = (PersistenceUnit)iterator2.next();
            this.addPersistenceUnitRef(persistenceUnit, j2eeClientEnvironmentBean);
        }
        Collection<WebServiceRef> collection2 = this.getClassWebServiceRefs(clazz).values();
        for (WebServiceRef webServiceRef : collection2) {
            this.addWebServiceRef(webServiceRef, clazz, j2eeClientEnvironmentBean);
        }
    }

    @Override
    public void validate(ClassLoader classLoader, DescriptorBean descriptorBean, boolean bl) throws ErrorCollectionException {
        this.validate(classLoader, descriptorBean);
        if (bl) {
            this.throwProcessingErrors();
        }
    }

    private void validate(ClassLoader classLoader, DescriptorBean descriptorBean) {
        if (productionMode) {
            return;
        }
        AnnotationValidatorVisitor annotationValidatorVisitor = new AnnotationValidatorVisitor(classLoader);
        ((AbstractDescriptorBean)descriptorBean).accept((Visitor)annotationValidatorVisitor);
        ErrorCollectionException errorCollectionException = annotationValidatorVisitor.getErrors();
        if (errorCollectionException != null && errorCollectionException.size() != 0) {
            if (this.errors == null) {
                this.errors = new ErrorCollectionException();
            }
            this.errors.add((Throwable)errorCollectionException);
        }
    }

    protected void processField(Field field, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        if (field.isAnnotationPresent(Resource.class)) {
            this.addEnvironmentEntry(field, j2eeClientEnvironmentBean);
        } else if (field.isAnnotationPresent(EJB.class)) {
            this.addEjbRef(field, j2eeClientEnvironmentBean);
        } else if (field.isAnnotationPresent(EJBReference.class)) {
            this.addEjbRef(field, j2eeClientEnvironmentBean);
        } else if (field.isAnnotationPresent(PersistenceUnit.class)) {
            this.addPersistenceUnitRef(field, j2eeClientEnvironmentBean);
        } else if (field.isAnnotationPresent(WebServiceRef.class)) {
            this.addWebServiceRef(field, j2eeClientEnvironmentBean);
        }
    }

    private void processMethods(List<Method> list, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.processLifcycleMethods(list, j2eeClientEnvironmentBean);
        for (Method method : list) {
            this.processMethod(method, j2eeClientEnvironmentBean);
        }
    }

    protected void processMethod(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        if (method.isAnnotationPresent(Resource.class)) {
            this.addEnvironmentEntry(method, j2eeClientEnvironmentBean);
        } else if (method.isAnnotationPresent(EJB.class)) {
            this.addEjbRef(method, j2eeClientEnvironmentBean);
        } else if (method.isAnnotationPresent(PersistenceUnit.class)) {
            this.addPersistenceUnitRef(method, j2eeClientEnvironmentBean);
        } else if (method.isAnnotationPresent(WebServiceRef.class)) {
            this.addWebServiceRef(method, j2eeClientEnvironmentBean);
        } else if (method.isAnnotationPresent(EJBReference.class)) {
            this.addEjbRef(method, j2eeClientEnvironmentBean);
        }
    }

    private void processLifcycleMethods(List<Method> list, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeClientEnvironmentBean.getPostConstructs()) {
            arrayList.add(lifecycleCallbackBean.getLifecycleCallbackClass());
        }
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeClientEnvironmentBean.getPreDestroys()) {
            arrayList2.add(lifecycleCallbackBean.getLifecycleCallbackClass());
        }
        for (Method method : list) {
            String string = method.getDeclaringClass().getName();
            if (method.isAnnotationPresent(PostConstruct.class) && !arrayList.contains(string)) {
                this.addPostConstructCallback(method, j2eeClientEnvironmentBean);
            }
            if (!method.isAnnotationPresent(PreDestroy.class) || arrayList2.contains(string)) continue;
            this.addPreDestroyCallback(method, j2eeClientEnvironmentBean);
        }
    }

    protected void addPostConstructCallback(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        LifecycleCallbackBean lifecycleCallbackBean = j2eeClientEnvironmentBean.createPostConstruct();
        lifecycleCallbackBean.setBeanSource(1);
        lifecycleCallbackBean.setLifecycleCallbackClass(method.getDeclaringClass().getName());
        lifecycleCallbackBean.setLifecycleCallbackMethod(method.getName());
    }

    protected void addPreDestroyCallback(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        LifecycleCallbackBean lifecycleCallbackBean = j2eeClientEnvironmentBean.createPreDestroy();
        lifecycleCallbackBean.setBeanSource(1);
        lifecycleCallbackBean.setLifecycleCallbackClass(method.getDeclaringClass().getName());
        lifecycleCallbackBean.setLifecycleCallbackMethod(method.getName());
    }

    protected void addPersistenceUnitRef(PersistenceUnit persistenceUnit, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.addPersistenceUnitRef(persistenceUnit.name(), persistenceUnit, j2eeClientEnvironmentBean, false);
    }

    protected void addPersistenceUnitRef(Field field, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        PersistenceUnit persistenceUnit = field.getAnnotation(PersistenceUnit.class);
        String string = this.getCompEnvJndiName(persistenceUnit.name(), field);
        if (this.findInjectionTargetFromPersistenceUnitRef(field, string, j2eeClientEnvironmentBean) == null) {
            this.addInjectionTarget(field, this.addPersistenceUnitRef(string, persistenceUnit, j2eeClientEnvironmentBean, true));
        }
    }

    protected void addPersistenceUnitRef(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        PersistenceUnit persistenceUnit = method.getAnnotation(PersistenceUnit.class);
        String string = this.getCompEnvJndiName(persistenceUnit.name(), method);
        if (this.findInjectionTargetFromPersistenceUnitRef(method, string, j2eeClientEnvironmentBean) == null) {
            this.addInjectionTarget(method, this.addPersistenceUnitRef(string, persistenceUnit, j2eeClientEnvironmentBean, true));
        }
    }

    protected InjectionTargetBean addPersistenceUnitRef(String string, PersistenceUnit persistenceUnit, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        PersistenceUnitRefBean persistenceUnitRefBean = null;
        for (PersistenceUnitRefBean persistenceUnitRefBean2 : j2eeClientEnvironmentBean.getPersistenceUnitRefs()) {
            if (!persistenceUnitRefBean2.getPersistenceUnitRefName().equals(string)) continue;
            persistenceUnitRefBean = persistenceUnitRefBean2;
            break;
        }
        if (persistenceUnitRefBean == null) {
            persistenceUnitRefBean = j2eeClientEnvironmentBean.createPersistenceUnitRef();
            persistenceUnitRefBean.setPersistenceUnitRefName(string);
        }
        if (!this.isSet("PersistenceUnitName", persistenceUnitRefBean) && persistenceUnit.unitName().length() > 0) {
            persistenceUnitRefBean.setPersistenceUnitName(persistenceUnit.unitName());
        }
        if (bl) {
            return persistenceUnitRefBean.createInjectionTarget();
        }
        return null;
    }

    protected InjectionTargetBean findInjectionTargetFromPersistenceUnitRef(Method method, String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromPersistenceUnitRef(method.getDeclaringClass().getName(), this.getPropertyName(method), string, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromPersistenceUnitRef(Field field, String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromPersistenceUnitRef(field.getDeclaringClass().getName(), field.getName(), string, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromPersistenceUnitRef(String string, String string2, String string3, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        PersistenceUnitRefBean persistenceUnitRefBean = null;
        for (PersistenceUnitRefBean persistenceUnitRefBean2 : j2eeClientEnvironmentBean.getPersistenceUnitRefs()) {
            if (!persistenceUnitRefBean2.getPersistenceUnitRefName().equals(string3)) continue;
            persistenceUnitRefBean = persistenceUnitRefBean2;
            break;
        }
        if (persistenceUnitRefBean != null) {
            return this.findInjectionTargetInArray(string, string2, persistenceUnitRefBean.getInjectionTargets());
        }
        return null;
    }

    private void addWebServiceRef(WebServiceRef webServiceRef, Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        HandlerChain handlerChain = clazz.getAnnotation(HandlerChain.class);
        this.addWebServiceRef(webServiceRef.name(), webServiceRef.type(), webServiceRef, handlerChain, clazz, j2eeClientEnvironmentBean, false);
    }

    private void addWebServiceRef(Field field, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        WebServiceRef webServiceRef = field.getAnnotation(WebServiceRef.class);
        HandlerChain handlerChain = field.getAnnotation(HandlerChain.class);
        String string = this.getCompEnvJndiName(webServiceRef.name(), field);
        Class clazz = this.getEnvironmentType(webServiceRef.type(), field);
        if (this.findInjectionTargetFromServiceRef(field, string, j2eeClientEnvironmentBean) == null) {
            this.addInjectionTarget(field, this.addWebServiceRef(string, clazz, webServiceRef, handlerChain, field.getDeclaringClass(), j2eeClientEnvironmentBean, true));
        }
    }

    private void addWebServiceRef(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        WebServiceRef webServiceRef = method.getAnnotation(WebServiceRef.class);
        HandlerChain handlerChain = method.getAnnotation(HandlerChain.class);
        String string = this.getCompEnvJndiName(webServiceRef.name(), method);
        Class clazz = this.getEnvironmentType(webServiceRef.type(), method);
        if (this.findInjectionTargetFromServiceRef(method, string, j2eeClientEnvironmentBean) == null) {
            this.addInjectionTarget(method, this.addWebServiceRef(string, clazz, webServiceRef, handlerChain, method.getDeclaringClass(), j2eeClientEnvironmentBean, true));
        }
    }

    private InjectionTargetBean addWebServiceRef(String string, Class clazz, WebServiceRef webServiceRef, HandlerChain handlerChain, Class clazz2, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        ServiceRefBean serviceRefBean = this.findOrCreateServiceRef(string, j2eeClientEnvironmentBean);
        if (!this.isSet("ServiceRefType", serviceRefBean)) {
            serviceRefBean.setServiceRefType(clazz.getName());
        }
        if (!this.isSet("ServiceInterface", serviceRefBean)) {
            Class clazz3 = webServiceRef.value();
            if ((clazz3 == Object.class || clazz3 == Service.class) && Service.class.isAssignableFrom(clazz)) {
                clazz3 = clazz;
            }
            if (clazz3 != Object.class) {
                serviceRefBean.setServiceInterface(clazz3.getName());
            }
        }
        if (!this.isSet("WsdlFile", serviceRefBean)) {
            serviceRefBean.setWsdlFile(webServiceRef.wsdlLocation());
        }
        if (serviceRefBean.getHandlerChains() == null && handlerChain != null) {
            this.addHandlerChain(serviceRefBean, clazz2, handlerChain);
        }
        if (bl) {
            return serviceRefBean.createInjectionTarget();
        }
        return null;
    }

    private void addHandlerChain(ServiceRefBean serviceRefBean, Class clazz, HandlerChain handlerChain) {
        try {
            HandlerChainLoader handlerChainLoader = new HandlerChainLoader(handlerChain, clazz);
            if (handlerChainLoader.getHandlerChains() == null) {
                return;
            }
            ServiceRefHandlerChainsBean serviceRefHandlerChainsBean = serviceRefBean.createHandlerChains();
            for (HandlerChainType handlerChainType : handlerChainLoader.getHandlerChains()) {
                PortComponentHandlerType[] portComponentHandlerTypeArray;
                ServiceRefHandlerChainBean serviceRefHandlerChainBean = serviceRefHandlerChainsBean.createHandlerChain();
                if (handlerChainType.xgetPortNamePattern() == null) {
                    serviceRefHandlerChainBean.setPortNamePattern(handlerChainType.getPortNamePattern());
                } else {
                    portComponentHandlerTypeArray = handlerChainType.xgetPortNamePattern().getDomNode();
                    serviceRefHandlerChainBean.setPortNamePattern(this.getQualifiedNamePattern((Node)portComponentHandlerTypeArray));
                }
                if (handlerChainType.getProtocolBindings() != null) {
                    serviceRefHandlerChainBean.setProtocolBindings(handlerChainType.getProtocolBindings().toString());
                }
                if (handlerChainType.xgetServiceNamePattern() == null) {
                    serviceRefHandlerChainBean.setServiceNamePattern(handlerChainType.getServiceNamePattern());
                } else {
                    portComponentHandlerTypeArray = handlerChainType.xgetServiceNamePattern().getDomNode();
                    serviceRefHandlerChainBean.setServiceNamePattern(this.getQualifiedNamePattern((Node)portComponentHandlerTypeArray));
                }
                for (PortComponentHandlerType portComponentHandlerType : handlerChainType.getHandlerArray()) {
                    ServiceRefHandlerBean serviceRefHandlerBean = serviceRefHandlerChainBean.createHandler();
                    if (portComponentHandlerType.getHandlerName() != null) {
                        serviceRefHandlerBean.setHandlerName(portComponentHandlerType.getHandlerName().getStringValue());
                    }
                    serviceRefHandlerBean.setHandlerClass(portComponentHandlerType.getHandlerClass().getStringValue());
                    for (int i = 0; i < portComponentHandlerType.sizeOfSoapRoleArray(); ++i) {
                        serviceRefHandlerBean.addSoapRole(portComponentHandlerType.getSoapRoleArray(i).getStringValue());
                    }
                    Class<?> clazz2 = Class.forName(portComponentHandlerType.getHandlerClass().getStringValue(), true, Thread.currentThread().getContextClassLoader());
                    J2eeAnnotationProcessor j2eeAnnotationProcessor = new J2eeAnnotationProcessor();
                    j2eeAnnotationProcessor.processJ2eeAnnotations(clazz2, (J2eeClientEnvironmentBean)serviceRefHandlerBean);
                }
            }
        }
        catch (Exception exception) {
            this.addProcessingError("Error adding handler chain: " + exception.getMessage());
        }
    }

    private String getQualifiedNamePattern(Node node) {
        int n;
        String string;
        if (node == null || node.getFirstChild() == null) {
            return null;
        }
        String string2 = string = node.getFirstChild().getNodeValue();
        if (string != null && (n = string.indexOf(":")) > 0) {
            String string3 = "xmlns:" + string.substring(0, n);
            String string4 = null;
            for (Node node2 = node; node2 != null && (node2.getAttributes() == null || node2.getAttributes().getNamedItem(string3) == null || (string4 = node2.getAttributes().getNamedItem(string3).getNodeValue()) == null); node2 = node2.getParentNode()) {
            }
            if (string4 != null) {
                string2 = "{" + string4 + "}" + string.substring(n + 1);
            }
        }
        return string2;
    }

    protected InjectionTargetBean findInjectionTargetFromServiceRef(Method method, String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromServiceRef(method.getDeclaringClass().getName(), this.getPropertyName(method), string, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromServiceRef(Field field, String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromServiceRef(field.getDeclaringClass().getName(), field.getName(), string, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromServiceRef(String string, String string2, String string3, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        ServiceRefBean serviceRefBean = this.findOrCreateServiceRef(string3, j2eeClientEnvironmentBean);
        if (serviceRefBean != null) {
            return this.findInjectionTargetInArray(string, string2, serviceRefBean.getInjectionTargets());
        }
        return null;
    }

    protected void addEjbRef(EJB eJB, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.addEjbRef(eJB.name(), eJB.beanInterface(), eJB, j2eeClientEnvironmentBean, false);
    }

    protected void addEjbRef(Field field, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        EJB eJB = field.getAnnotation(EJB.class);
        if (eJB == null) {
            Class<?> clazz;
            EJBReference eJBReference = field.getAnnotation(EJBReference.class);
            String string = this.getCompEnvJndiName(eJBReference.name(), field);
            if (this.findInjectionTargetFromEjbRef(field, string, clazz = field.getType(), j2eeClientEnvironmentBean) == null) {
                this.addInjectionTarget(field, this.addEjbRef(string, clazz, eJBReference, j2eeClientEnvironmentBean, true));
            }
        } else {
            Class clazz;
            String string = this.getCompEnvJndiName(eJB.name(), field);
            if (this.findInjectionTargetFromEjbRef(field, string, clazz = this.getEnvironmentType(eJB.beanInterface(), field), j2eeClientEnvironmentBean) == null) {
                this.addInjectionTarget(field, this.addEjbRef(string, clazz, eJB, j2eeClientEnvironmentBean, true));
            }
        }
    }

    protected void addEjbRef(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        EJB eJB = method.getAnnotation(EJB.class);
        if (eJB == null) {
            Class<?> clazz;
            EJBReference eJBReference = method.getAnnotation(EJBReference.class);
            String string = this.getCompEnvJndiName(eJBReference.name(), method);
            if (this.findInjectionTargetFromEjbRef(method, string, clazz = method.getParameterTypes()[0], j2eeClientEnvironmentBean) == null) {
                this.addInjectionTarget(method, this.addEjbRef(string, clazz, eJBReference, j2eeClientEnvironmentBean, true));
            }
        } else {
            Class clazz;
            String string = this.getCompEnvJndiName(eJB.name(), method);
            if (this.findInjectionTargetFromEjbRef(method, string, clazz = this.getEnvironmentType(eJB.beanInterface(), method), j2eeClientEnvironmentBean) == null) {
                this.addInjectionTarget(method, this.addEjbRef(string, clazz, eJB, j2eeClientEnvironmentBean, true));
            }
        }
    }

    protected InjectionTargetBean addEjbref(String string, Class clazz, EJBReference eJBReference, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        EjbRefBean ejbRefBean = this.findEjbRef(string, j2eeClientEnvironmentBean);
        if (ejbRefBean != null) {
            return this.addEJBRemoteRef(string, clazz, eJBReference, j2eeClientEnvironmentBean, ejbRefBean, bl);
        }
        if (clazz == Object.class) {
            this.addBeanInterfaceNotSetError(j2eeClientEnvironmentBean);
            return null;
        }
        return this.addEJBRemoteRef(string, clazz, eJBReference, j2eeClientEnvironmentBean, null, bl);
    }

    protected InjectionTargetBean addEJBRemoteRef(String string, Class clazz, EJBReference eJBReference, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, EjbRefBean ejbRefBean, boolean bl) {
        if (ejbRefBean == null) {
            ejbRefBean = j2eeClientEnvironmentBean.createEjbRef();
            ejbRefBean.setEjbRefName(string);
        }
        if (clazz != Object.class) {
            if (EJBHome.class.isAssignableFrom(clazz)) {
                if (!this.isSet("Home", ejbRefBean)) {
                    ejbRefBean.setHome(clazz.getName());
                }
            } else if (!this.isSet("Remote", ejbRefBean)) {
                ejbRefBean.setRemote(clazz.getName());
            }
        }
        if (!this.isSet("MappedName", ejbRefBean) && eJBReference.jndiName().length() > 0) {
            ejbRefBean.setMappedName("weblogic-jndi:" + eJBReference.jndiName());
        }
        if (bl) {
            return ejbRefBean.createInjectionTarget();
        }
        return null;
    }

    protected InjectionTargetBean addEjbRef(String string, Class clazz, EJBReference eJBReference, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        EjbRefBean ejbRefBean = this.findEjbRef(string, j2eeClientEnvironmentBean);
        if (ejbRefBean != null) {
            return this.addEJBRemoteRef(string, clazz, eJBReference, j2eeClientEnvironmentBean, ejbRefBean, bl);
        }
        if (clazz == Object.class) {
            this.addBeanInterfaceNotSetError(j2eeClientEnvironmentBean);
            return null;
        }
        return this.addEJBRemoteRef(string, clazz, eJBReference, j2eeClientEnvironmentBean, null, bl);
    }

    protected InjectionTargetBean addEjbRef(String string, Class clazz, EJB eJB, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        EjbRefBean ejbRefBean = this.findEjbRef(string, j2eeClientEnvironmentBean);
        if (ejbRefBean != null) {
            return this.addEJBRemoteRef(string, clazz, eJB, j2eeClientEnvironmentBean, ejbRefBean, bl);
        }
        if (EJBHome.class.isAssignableFrom(clazz)) {
            return this.addEJBRemoteRef(string, clazz, eJB, j2eeClientEnvironmentBean, null, bl);
        }
        return this.addEJBRemoteRef(string, clazz, eJB, j2eeClientEnvironmentBean, null, bl);
    }

    protected InjectionTargetBean findInjectionTargetFromEjbRef(Method method, String string, Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromEjbRef(method.getDeclaringClass().getName(), this.getPropertyName(method), string, clazz, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromEjbRef(Field field, String string, Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromEjbRef(field.getDeclaringClass().getName(), field.getName(), string, clazz, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromEjbRef(String string, String string2, String string3, Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        EjbRefBean ejbRefBean = this.findEjbRef(string3, j2eeClientEnvironmentBean);
        if (ejbRefBean != null) {
            return this.findInjectionTargetInArray(string, string2, ejbRefBean.getInjectionTargets());
        }
        return null;
    }

    protected InjectionTargetBean addEJBRemoteRef(String string, Class clazz, EJB eJB, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, EjbRefBean ejbRefBean, boolean bl) {
        if (ejbRefBean == null) {
            ejbRefBean = j2eeClientEnvironmentBean.createEjbRef();
            ejbRefBean.setEjbRefName(string);
        }
        if (clazz != Object.class) {
            if (EJBHome.class.isAssignableFrom(clazz)) {
                if (!this.isSet("Home", ejbRefBean)) {
                    ejbRefBean.setHome(clazz.getName());
                }
            } else if (!this.isSet("Remote", ejbRefBean)) {
                ejbRefBean.setRemote(clazz.getName());
            }
        }
        if (!this.isSet("EjbLink", ejbRefBean) && eJB.beanName().length() > 0) {
            ejbRefBean.setEjbLink(eJB.beanName());
        }
        if (!this.isSet("MappedName", ejbRefBean) && eJB.mappedName().length() > 0) {
            ejbRefBean.setMappedName(eJB.mappedName());
        }
        if (bl) {
            return ejbRefBean.createInjectionTarget();
        }
        return null;
    }

    protected EjbRefBean findEjbRef(String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (EjbRefBean ejbRefBean : j2eeClientEnvironmentBean.getEjbRefs()) {
            if (!string.equals(ejbRefBean.getEjbRefName())) continue;
            return ejbRefBean;
        }
        return null;
    }

    protected void addEnvironmentEntry(Resource resource, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.addEnvironmentEntry(resource.name(), resource.type(), resource, j2eeClientEnvironmentBean, false);
    }

    protected void addEnvironmentEntry(Field field, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        Class clazz;
        Resource resource = field.getAnnotation(Resource.class);
        String string = this.getCompEnvJndiName(resource.name(), field);
        if (this.findInjectionTargetFromEnvironmentEntry(field, string, clazz = this.getEnvironmentType(resource.type(), field), resource, j2eeClientEnvironmentBean) == null) {
            this.addInjectionTarget(field, this.addEnvironmentEntry(string, clazz, resource, j2eeClientEnvironmentBean, true));
        }
    }

    protected void addEnvironmentEntry(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        Class clazz;
        Resource resource = method.getAnnotation(Resource.class);
        String string = this.getCompEnvJndiName(resource.name(), method);
        if (this.findInjectionTargetFromEnvironmentEntry(method, string, clazz = this.getEnvironmentType(resource.type(), method), resource, j2eeClientEnvironmentBean) == null) {
            this.addInjectionTarget(method, this.addEnvironmentEntry(string, clazz, resource, j2eeClientEnvironmentBean, true));
        }
    }

    protected String getPropertyName(Method method) {
        String string = method.getName();
        char c = string.charAt(3);
        return ("" + c).toLowerCase() + string.substring(4);
    }

    protected EnvEntryBean findOrCreateEnvEntry(String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (EnvEntryBean envEntryBean : j2eeClientEnvironmentBean.getEnvEntries()) {
            if (!string.equals(envEntryBean.getEnvEntryName())) continue;
            return envEntryBean;
        }
        EnvEntryBean envEntryBean = j2eeClientEnvironmentBean.createEnvEntry();
        envEntryBean.setEnvEntryName(string);
        return envEntryBean;
    }

    protected ServiceRefBean findOrCreateServiceRef(String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (ServiceRefBean serviceRefBean : j2eeClientEnvironmentBean.getServiceRefs()) {
            if (!string.equals(serviceRefBean.getServiceRefName())) continue;
            return serviceRefBean;
        }
        ServiceRefBean serviceRefBean = j2eeClientEnvironmentBean.createServiceRef();
        serviceRefBean.setServiceRefName(string);
        return serviceRefBean;
    }

    protected ResourceRefBean findOrCreateResourceRef(String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (ResourceRefBean resourceRefBean : j2eeClientEnvironmentBean.getResourceRefs()) {
            if (!string.equals(resourceRefBean.getResRefName())) continue;
            return resourceRefBean;
        }
        ResourceRefBean resourceRefBean = j2eeClientEnvironmentBean.createResourceRef();
        resourceRefBean.setResRefName(string);
        return resourceRefBean;
    }

    protected MessageDestinationRefBean findOrCreateMessageDestinationRef(String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (MessageDestinationRefBean messageDestinationRefBean : j2eeClientEnvironmentBean.getMessageDestinationRefs()) {
            if (!string.equals(messageDestinationRefBean.getMessageDestinationRefName())) continue;
            return messageDestinationRefBean;
        }
        MessageDestinationRefBean messageDestinationRefBean = j2eeClientEnvironmentBean.createMessageDestinationRef();
        messageDestinationRefBean.setMessageDestinationRefName(string);
        return messageDestinationRefBean;
    }

    protected ResourceEnvRefBean findOrCreateResourceEnvRef(String string, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getResourceEnvRefs()) {
            if (!string.equals(resourceEnvRefBean.getResourceEnvRefName())) continue;
            return resourceEnvRefBean;
        }
        ResourceEnvRefBean resourceEnvRefBean = j2eeClientEnvironmentBean.createResourceEnvRef();
        resourceEnvRefBean.setResourceEnvRefName(string);
        return resourceEnvRefBean;
    }

    private String transformPrimitiveType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.class.getName();
        }
        if (clazz == Integer.TYPE) {
            return Integer.class.getName();
        }
        if (clazz == Float.TYPE) {
            return Float.class.getName();
        }
        if (clazz == Short.TYPE) {
            return Short.class.getName();
        }
        if (clazz == Character.TYPE) {
            return Character.class.getName();
        }
        if (clazz == Byte.TYPE) {
            return Byte.class.getName();
        }
        if (clazz == Long.TYPE) {
            return Long.class.getName();
        }
        return clazz.getName();
    }

    protected InjectionTargetBean addEnvironmentEntry(String string, Class clazz, Resource resource, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        if (clazz.isPrimitive() || clazz == String.class || clazz == Character.class || clazz == Integer.class || clazz == Boolean.class || clazz == Double.class || clazz == Byte.class || clazz == Short.class || clazz == Long.class || clazz == Float.class) {
            EnvEntryBean envEntryBean = this.findOrCreateEnvEntry(string, j2eeClientEnvironmentBean);
            if (!this.isSet("EnvEntryType", envEntryBean)) {
                if (clazz.isPrimitive()) {
                    envEntryBean.setEnvEntryType(this.transformPrimitiveType(clazz));
                } else {
                    envEntryBean.setEnvEntryType(clazz.getName());
                }
            }
            if (resource.mappedName().length() > 0 && !this.isSet("MappedName", envEntryBean)) {
                envEntryBean.setMappedName(resource.mappedName());
            }
            if (bl) {
                return envEntryBean.createInjectionTarget();
            }
            return null;
        }
        if (clazz == javax.xml.rpc.Service.class) {
            ServiceRefBean serviceRefBean = this.findOrCreateServiceRef(string, j2eeClientEnvironmentBean);
            if (!this.isSet("ServiceRefType", serviceRefBean)) {
                serviceRefBean.setServiceRefType(clazz.getName());
            }
            if (resource.mappedName().length() > 0 && !this.isSet("MappedName", serviceRefBean)) {
                serviceRefBean.setMappedName(resource.mappedName());
            }
            if (bl) {
                return serviceRefBean.createInjectionTarget();
            }
            return null;
        }
        if (clazz == DataSource.class || clazz == ConnectionFactory.class || clazz == QueueConnectionFactory.class || clazz == TopicConnectionFactory.class || clazz == Session.class || clazz == URL.class || clazz == javax.resource.cci.ConnectionFactory.class || clazz == ORB.class || clazz == org.omg.CORBA.ORB.class || clazz == WorkManager.class || clazz == TimerManager.class || clazz.getName().equals("com.tangosol.net.NamedCache") || clazz.getName().equals("com.tangosol.net.Service") || JCAConnectionFactoryProvider.isAdapterConnectionFactoryClass(clazz.getName())) {
            ResourceRefBean resourceRefBean = this.findOrCreateResourceRef(string, j2eeClientEnvironmentBean);
            if (!this.isSet("ResType", resourceRefBean)) {
                resourceRefBean.setResType(clazz.getName());
            }
            if (!this.isSet("ResAuth", resourceRefBean)) {
                if (resource.authenticationType() != Resource.AuthenticationType.CONTAINER) {
                    resourceRefBean.setResAuth("Application");
                } else {
                    resourceRefBean.setResAuth("Container");
                }
            }
            if (!this.isSet("ResSharingScope", resourceRefBean) && !resource.shareable()) {
                resourceRefBean.setResSharingScope("Unshareable");
            }
            if (resource.mappedName().length() > 0 && !this.isSet("MappedName", resourceRefBean)) {
                resourceRefBean.setMappedName(resource.mappedName());
            }
            if (bl) {
                return resourceRefBean.createInjectionTarget();
            }
            return null;
        }
        if (clazz == Queue.class || clazz == Topic.class) {
            MessageDestinationRefBean messageDestinationRefBean = this.findOrCreateMessageDestinationRef(string, j2eeClientEnvironmentBean);
            if (!this.isSet("MessageDestinationType", messageDestinationRefBean)) {
                messageDestinationRefBean.setMessageDestinationType(clazz.getName());
            }
            if (resource.mappedName().length() > 0 && !this.isSet("MappedName", messageDestinationRefBean)) {
                messageDestinationRefBean.setMappedName(resource.mappedName());
            }
            if (bl) {
                return messageDestinationRefBean.createInjectionTarget();
            }
            return null;
        }
        InjectionExtension injectionExtension = ExtensionManager.instance.getFirstMatchingExtension(clazz.getName(), resource.name());
        if (injectionExtension != null) {
            string = resource.name().length() == 0 ? injectionExtension.getName(clazz.getName()) : injectionExtension.getName(clazz.getName(), string);
            ResourceEnvRefBean resourceEnvRefBean = this.findOrCreateResourceEnvRef(string, j2eeClientEnvironmentBean);
            if (!this.isSet("ResourceEnvRefType", resourceEnvRefBean)) {
                resourceEnvRefBean.setResourceEnvRefType(clazz.getName());
            }
            if (!this.isSet("MappedName", resourceEnvRefBean)) {
                resourceEnvRefBean.setMappedName(string);
            }
            if (bl) {
                return resourceEnvRefBean.createInjectionTarget();
            }
            return null;
        }
        ResourceEnvRefBean resourceEnvRefBean = this.findOrCreateResourceEnvRef(string, j2eeClientEnvironmentBean);
        if (!this.isSet("ResourceEnvRefType", resourceEnvRefBean)) {
            resourceEnvRefBean.setResourceEnvRefType(clazz.getName());
        }
        if (resource.mappedName().length() > 0 && !this.isSet("MappedName", resourceEnvRefBean)) {
            resourceEnvRefBean.setMappedName(resource.mappedName());
        }
        if (bl) {
            return resourceEnvRefBean.createInjectionTarget();
        }
        return null;
    }

    protected InjectionTargetBean findInjectionTargetFromEnvironmentEntry(Method method, String string, Class clazz, Resource resource, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromEnvironmentEntry(method.getDeclaringClass().getName(), this.getPropertyName(method), string, clazz, resource, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromEnvironmentEntry(Field field, String string, Class clazz, Resource resource, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        return this.findInjectionTargetFromEnvironmentEntry(field.getDeclaringClass().getName(), field.getName(), string, clazz, resource, j2eeClientEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromEnvironmentEntry(String string, String string2, String string3, Class clazz, Resource resource, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        Object object;
        if (clazz.isPrimitive() || clazz == String.class || clazz == Character.class || clazz == Integer.class || clazz == Boolean.class || clazz == Double.class || clazz == Byte.class || clazz == Short.class || clazz == Long.class || clazz == Float.class) {
            EnvEntryBean envEntryBean = this.findOrCreateEnvEntry(string3, j2eeClientEnvironmentBean);
            if (envEntryBean != null) {
                return this.findInjectionTargetInArray(string, string2, envEntryBean.getInjectionTargets());
            }
            return null;
        }
        if (clazz == javax.xml.rpc.Service.class) {
            object = this.findOrCreateServiceRef(string3, j2eeClientEnvironmentBean);
        }
        if (clazz == DataSource.class || clazz == ConnectionFactory.class || clazz == QueueConnectionFactory.class || clazz == TopicConnectionFactory.class || clazz == Session.class || clazz == URL.class || clazz == javax.resource.cci.ConnectionFactory.class || clazz == ORB.class || clazz == org.omg.CORBA.ORB.class || clazz == WorkManager.class || clazz == TimerManager.class || clazz.getName().equals("com.tangosol.net.NamedCache") || clazz.getName().equals("com.tangosol.net.Service") || JCAConnectionFactoryProvider.isAdapterConnectionFactoryClass(clazz.getName())) {
            object = this.findOrCreateResourceRef(string3, j2eeClientEnvironmentBean);
            if (object != null) {
                return this.findInjectionTargetInArray(string, string2, object.getInjectionTargets());
            }
            return null;
        }
        if (clazz == Queue.class || clazz == Topic.class) {
            object = this.findOrCreateMessageDestinationRef(string3, j2eeClientEnvironmentBean);
            if (object != null) {
                return this.findInjectionTargetInArray(string, string2, object.getInjectionTargets());
            }
            return null;
        }
        object = ExtensionManager.instance.getFirstMatchingExtension(clazz.getName(), resource.name());
        if (object != null) {
            string3 = resource.name().length() == 0 ? object.getName(clazz.getName()) : object.getName(clazz.getName(), string3);
            ResourceEnvRefBean resourceEnvRefBean = this.findOrCreateResourceEnvRef(string3, j2eeClientEnvironmentBean);
            if (resourceEnvRefBean != null) {
                return this.findInjectionTargetInArray(string, string2, resourceEnvRefBean.getInjectionTargets());
            }
            return null;
        }
        ResourceEnvRefBean resourceEnvRefBean = this.findOrCreateResourceEnvRef(string3, j2eeClientEnvironmentBean);
        if (resourceEnvRefBean != null) {
            return this.findInjectionTargetInArray(string, string2, resourceEnvRefBean.getInjectionTargets());
        }
        return null;
    }

    protected List<Field> getFields(Class clazz) {
        return this.getFields(clazz, new ArrayList<String>());
    }

    protected List<Field> getFields(Class clazz, Collection<String> collection) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        for (Field field : fieldArray) {
            arrayList.add(field);
        }
        Class clazz2 = clazz.getSuperclass();
        if (!clazz2.equals(Object.class)) {
            arrayList.addAll(this.getFields(clazz2, collection));
        }
        return arrayList;
    }

    protected List<Method> getMethods(Class clazz) {
        List<Method> list = this.methodsCache.get(clazz);
        if (list == null) {
            list = this.getMethods(clazz, new HashSet<String>());
            Collections.reverse(list);
            this.methodsCache.put(clazz, list);
        }
        return list;
    }

    protected List<Method> getMethods(Class clazz, Set<String> set) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            int n = method.getModifiers();
            if (Modifier.isPrivate(n)) {
                arrayList.add(method);
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer(method.getName()).append("(");
            for (Class<?> clazz2 : method.getParameterTypes()) {
                stringBuffer.append(clazz2.getName()).append(", ");
            }
            if (set.contains(stringBuffer.toString())) continue;
            arrayList.add(method);
            set.add(stringBuffer.toString());
        }
        Class clazz3 = clazz.getSuperclass();
        if (!clazz3.equals(Object.class)) {
            arrayList.addAll(this.getMethods(clazz3, set));
        }
        return arrayList;
    }

    protected Map<String, Resource> getClassResources(Class clazz) {
        Resources resources;
        Map<Object, Object> map = null;
        Class clazz2 = clazz.getSuperclass();
        map = clazz2.equals(Object.class) ? new HashMap() : this.getClassResources(clazz2);
        if (clazz.isAnnotationPresent(Resources.class)) {
            resources = clazz.getAnnotation(Resources.class);
            for (Resource resource : resources.value()) {
                this.validateClassResource(resource, clazz);
                map.put(resource.name(), resource);
            }
        }
        if (clazz.isAnnotationPresent(Resource.class)) {
            resources = clazz.getAnnotation(Resource.class);
            this.validateClassResource((Resource)resources, clazz);
            map.put(resources.name(), (Resource)resources);
        }
        return map;
    }

    protected Map<String, EJB> getClassEJBRefs(Class clazz) {
        EJBs eJBs;
        Map<Object, Object> map = null;
        Class clazz2 = clazz.getSuperclass();
        map = clazz2.equals(Object.class) ? new HashMap() : this.getClassEJBRefs(clazz2);
        if (clazz.isAnnotationPresent(EJBs.class)) {
            eJBs = clazz.getAnnotation(EJBs.class);
            for (EJB eJB : eJBs.value()) {
                this.validateClassResource(eJB, clazz);
                map.put(eJB.name(), eJB);
            }
        }
        if (clazz.isAnnotationPresent(EJB.class)) {
            eJBs = clazz.getAnnotation(EJB.class);
            this.validateClassResource((EJB)eJBs, clazz);
            map.put(eJBs.name(), (EJB)eJBs);
        }
        return map;
    }

    protected Map<String, PersistenceUnit> getClassPersistenceUnitRefs(Class clazz) {
        PersistenceUnits persistenceUnits;
        Map<Object, Object> map = null;
        Class clazz2 = clazz.getSuperclass();
        map = clazz2.equals(Object.class) ? new HashMap() : this.getClassPersistenceUnitRefs(clazz2);
        if (clazz.isAnnotationPresent(PersistenceUnits.class)) {
            persistenceUnits = clazz.getAnnotation(PersistenceUnits.class);
            for (PersistenceUnit persistenceUnit : persistenceUnits.value()) {
                this.validateClassResource(persistenceUnit, clazz);
                map.put(persistenceUnit.name(), persistenceUnit);
            }
        }
        if (clazz.isAnnotationPresent(PersistenceUnit.class)) {
            persistenceUnits = clazz.getAnnotation(PersistenceUnit.class);
            this.validateClassResource((PersistenceUnit)persistenceUnits, clazz);
            map.put(persistenceUnits.name(), (PersistenceUnit)persistenceUnits);
        }
        return map;
    }

    private Map<String, WebServiceRef> getClassWebServiceRefs(Class clazz) {
        WebServiceRefs webServiceRefs;
        Map<Object, Object> map = null;
        Class clazz2 = clazz.getSuperclass();
        map = clazz2.equals(Object.class) ? new HashMap() : this.getClassWebServiceRefs(clazz2);
        if (clazz.isAnnotationPresent(WebServiceRefs.class)) {
            webServiceRefs = clazz.getAnnotation(WebServiceRefs.class);
            for (WebServiceRef webServiceRef : webServiceRefs.value()) {
                this.validateClassResource(webServiceRef, clazz);
                map.put(webServiceRef.name(), webServiceRef);
            }
        }
        if (clazz.isAnnotationPresent(WebServiceRef.class)) {
            webServiceRefs = clazz.getAnnotation(WebServiceRef.class);
            this.validateClassResource((WebServiceRef)webServiceRefs, clazz);
            map.put(webServiceRefs.name(), (WebServiceRef)webServiceRefs);
        }
        return map;
    }

    protected Set<PersistenceContext> getClassPersistenceContextRefs(Class clazz) {
        PersistenceContexts persistenceContexts;
        Set<Object> set = null;
        Class clazz2 = clazz.getSuperclass();
        set = clazz2.equals(Object.class) ? new HashSet() : this.getClassPersistenceContextRefs(clazz2);
        if (clazz.isAnnotationPresent(PersistenceContexts.class)) {
            persistenceContexts = clazz.getAnnotation(PersistenceContexts.class);
            for (PersistenceContext persistenceContext : persistenceContexts.value()) {
                this.validateClassResource(persistenceContext, clazz);
                set.add(persistenceContext);
            }
        }
        if (clazz.isAnnotationPresent(PersistenceContext.class)) {
            persistenceContexts = clazz.getAnnotation(PersistenceContext.class);
            this.validateClassResource((PersistenceContext)persistenceContexts, clazz);
            set.add((PersistenceContext)persistenceContexts);
        }
        return set;
    }

    private void validateClassResource(WebServiceRef webServiceRef, Class clazz) {
        if (webServiceRef.name().length() == 0) {
            this.addProcessingError("A class level WebServiceRef annotation on class " + clazz.getName() + " does not have the name attribute set.");
        }
    }

    protected void validateClassResource(PersistenceContext persistenceContext, Class clazz) {
        if (persistenceContext.name().length() == 0) {
            this.addProcessingError("A class level PersistenceContext annotation on class " + clazz.getName() + " does not have the name attribute set.");
        }
    }

    protected void validateClassResource(PersistenceUnit persistenceUnit, Class clazz) {
        if (persistenceUnit.name().length() == 0) {
            this.addProcessingError("A class level PersistenceUnit annotation on class " + clazz.getName() + " does not have the name attribute set.");
        }
    }

    protected void validateClassResource(Resource resource, Class clazz) {
        if (resource.name().length() == 0) {
            this.addProcessingError("A class level Resource annotation on class " + clazz.getName() + " does not have the name attribute set.");
        }
        if (resource.type() == Object.class) {
            this.addProcessingError("A class level Resource annotation on class " + clazz.getName() + " does not have the type attribute set");
        }
    }

    protected void validateClassResource(EJB eJB, Class clazz) {
        if (eJB.name().length() == 0) {
            this.addProcessingError("A class level EJB annotation on class " + clazz.getName() + " does not have the name attribute set.");
        }
    }

    protected String getCompEnvJndiName(String string, Field field) {
        if (string.length() == 0) {
            string = field.getDeclaringClass().getName() + "/" + field.getName();
        }
        return string;
    }

    protected String getCompEnvJndiName(String string, Method method) {
        if (string.length() == 0) {
            string = method.getDeclaringClass().getName() + "/" + this.getPropertyName(method);
        }
        return string;
    }

    protected Class getEnvironmentType(Class clazz, Field field) {
        if (clazz != Object.class) {
            return clazz;
        }
        return field.getType();
    }

    protected Class getEnvironmentType(Class clazz, Method method) {
        if (clazz != Object.class) {
            return clazz;
        }
        return method.getParameterTypes()[0];
    }

    protected void addInjectionTarget(Field field, InjectionTargetBean injectionTargetBean) {
        assert (field != null);
        assert (injectionTargetBean != null);
        injectionTargetBean.setInjectionTargetClass(field.getDeclaringClass().getName());
        injectionTargetBean.setInjectionTargetName(field.getName());
    }

    protected void addInjectionTarget(Method method, InjectionTargetBean injectionTargetBean) {
        assert (method != null);
        assert (injectionTargetBean != null);
        injectionTargetBean.setInjectionTargetClass(method.getDeclaringClass().getName());
        injectionTargetBean.setInjectionTargetName(this.getPropertyName(method));
    }

    protected InjectionTargetBean findInjectionTargetInArray(String string, String string2, InjectionTargetBean[] injectionTargetBeanArray) {
        if (injectionTargetBeanArray == null) {
            return null;
        }
        for (InjectionTargetBean injectionTargetBean : injectionTargetBeanArray) {
            if (!string.equals(injectionTargetBean.getInjectionTargetClass()) || !string2.equals(injectionTargetBean.getInjectionTargetName())) continue;
            return injectionTargetBean;
        }
        return null;
    }

    protected void log(String string) {
        System.out.println(string);
    }

    protected boolean isSet(String string, Object object) {
        return ((DescriptorBean)object).isSet(string);
    }

    protected void addProcessingError(String string) {
        if (this.errors == null) {
            this.errors = new ErrorCollectionException();
        }
        AnnotationProcessException annotationProcessException = new AnnotationProcessException(string);
        this.errors.add((Throwable)annotationProcessException);
    }

    protected void addFatalProcessingError(String string) throws ErrorCollectionException {
        this.addProcessingError(string);
        this.throwProcessingErrors();
    }

    protected void throwProcessingErrors() throws ErrorCollectionException {
        if (this.errors != null && !this.errors.isEmpty()) {
            throw this.errors;
        }
    }

    protected void addBeanInterfaceNotSetError(J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.addProcessingError("@EJB annotation doesn't have beanInterface set");
    }

    protected void addDescriptorDefaults(Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.addLifecycleCallbackDefaults(j2eeClientEnvironmentBean.getPostConstructs(), clazz.getName());
        this.addLifecycleCallbackDefaults(j2eeClientEnvironmentBean.getPreDestroys(), clazz.getName());
    }

    private void addLifecycleCallbackDefaults(LifecycleCallbackBean[] lifecycleCallbackBeanArray, String string) {
        for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray) {
            if (lifecycleCallbackBean.getLifecycleCallbackClass() != null) continue;
            lifecycleCallbackBean.setLifecycleCallbackClass(string);
        }
    }

    static {
        if (KernelStatus.isServer()) {
            AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
            productionMode = ManagementService.getRuntimeAccess(authenticatedSubject).getDomain().isProductionModeEnabled();
        }
    }
}

