/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.zip.ZipEntry;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.dd.J2EEDeploymentDescriptor;
import weblogic.j2ee.dd.xml.J2EEDeploymentDescriptorLoader;
import weblogic.j2ee.dd.xml.WADDLoader;
import weblogic.j2ee.descriptors.ApplicationDescriptorMBeanImpl;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.descriptors.ApplicationDescriptorMBean;
import weblogic.management.descriptors.Encoding;
import weblogic.management.descriptors.application.J2EEApplicationDescriptorMBean;
import weblogic.management.descriptors.application.weblogic.WeblogicApplicationMBean;
import weblogic.utils.Debug;
import weblogic.utils.io.XMLDeclaration;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.xml.process.ProcessorFactory;
import weblogic.xml.process.ProcessorFactoryException;
import weblogic.xml.process.SAXProcessorException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;
import weblogic.xml.process.XMLProcessor;

public final class DDUtils {
    private static final boolean debug = Debug.getCategory((String)"weblogic.j2ee.dd").isEnabled();
    public static final String J2EE12_EAR_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN";
    public static final String J2EE12_EAR_SYSTEM_ID = "http://java.sun.com/j2ee/dtds/application_1_2.dtd";
    public static final String J2EE13_EAR_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    public static final String J2EE13_EAR_SYSTEM_ID = "http://java.sun.com/dtd/application_1_3.dtd";
    public static final String J2EE12_EAR_LOADER_CLASS = "weblogic.j2ee.dd.xml.J2EEDeploymentDescriptorLoader_J2EE12";
    public static final String J2EE13_EAR_LOADER_CLASS = "weblogic.j2ee.dd.xml.J2EEDeploymentDescriptorLoader_J2EE13";
    public static final String WLSAPP_EAR_LOADER_CLASS_700 = "weblogic.j2ee.dd.xml.WebLogicApplication_1_0";
    public static final String WLSAPP_EAR_LOADER_CLASS_810 = "weblogic.j2ee.dd.xml.WebLogicApplication_2_0";
    public static final String WLSAPP_EAR_LOADER_CLASS_900 = "weblogic.j2ee.dd.xml.WebLogicApplication_3_0";
    public static final String J2EE12_EAR_LOCAL_DTD_NAME = "application_1_2.dtd";
    public static final String WLSAPP_EAR_PUBLIC_ID_700 = "-//BEA Systems, Inc.//DTD WebLogic Application 7.0.0//EN";
    public static final String WLSAPP_EAR_PUBLIC_ID_810 = "-//BEA Systems, Inc.//DTD WebLogic Application 8.1.0//EN";
    public static final String WLSAPP_EAR_PUBLIC_ID_900 = "-//BEA Systems, Inc.//DTD WebLogic Application 9.0.0//EN";
    public static final String WLSAPP_EAR_SYSTEM_ID_700 = "http://www.bea.com/servers/wls700/dtd/weblogic-application_1_0.dtd";
    public static final String WLSAPP_EAR_SYSTEM_ID_810 = "http://www.bea.com/servers/wls810/dtd/weblogic-application_2_0.dtd";
    public static final String WLSAPP_EAR_SYSTEM_ID_900 = "http://www.bea.com/servers/wls900/dtd/weblogic-application_3_0.dtd";
    public static final String WLSAPP_EAR_LOCAL_DTD_NAME = "weblogic-application_3_0.dtd";
    public static final String WLSAPP_EAR_PUBLIC_DTD_NAME = "-//BEA Systems, Inc.//DTD WebLogic Application 9.0.0//EN";
    public static final String J2EE_EAR_STD_DESCR = "META-INF/application.xml";
    public static final String J2EE_EAR_WL_DESCR = "META-INF/weblogic-application.xml";
    public static final String WEBLOGIC_APPLICATION_PUBLIC_ID = "-//BEA Systems, Inc.//DTD WebLogic Application 9.0.0//EN";
    public static final String WEBLOGIC_APPLICATION_SYSTEM_ID = "http://www.bea.com/servers/wls900/dtd/weblogic-application_3_0.dtd";
    public static final String WEBLOGIC_APPLICATION_LOADER_CLASS_700 = "weblogic.j2ee.dd.xml.WebLogicApplication_1_0";
    public static final String WEBLOGIC_APPLICATION_LOADER_CLASS_810 = "weblogic.j2ee.dd.xml.WebLogicApplication_2_0";
    public static final String WEBLOGIC_APPLICATION_LOADER_CLASS_900 = "weblogic.j2ee.dd.xml.WebLogicApplication_3_0";
    public static final String WEBLOGIC_APPLICATION_LOCAL_DTD_NAME = "weblogic-application_3_0.dtd";
    public static final String WEBLOGIC_APPLICATION_STD_DESCR = "META-INF/weblogic-application.xml";
    public static final String WL_DOCTYPE = "<!DOCTYPE weblogic-application PUBLIC '-//BEA Systems, Inc.//DTD WebLogic Application 9.0.0//EN' 'http://www.bea.com/servers/wls900/dtd/weblogic-application_3_0.dtd'>\n";
    public static final String[] validPublicIds = new String[]{"-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "-//BEA Systems, Inc.//DTD WebLogic Application 7.0.0//EN", "-//BEA Systems, Inc.//DTD WebLogic Application 8.1.0//EN", "-//BEA Systems, Inc.//DTD WebLogic Application 9.0.0//EN"};
    private static final String[] STD_DESCRIPTOR_PATHS = new String[]{"META-INF/application.xml", "META-INF/application.xml".toLowerCase(Locale.US)};
    private static final String[] WLS_DESCRIPTOR_PATHS = new String[]{"META-INF/weblogic-application.xml", "META-INF/weblogic-application.xml".toLowerCase(Locale.US)};
    public static final int MARK_SIZE = 0x100000;

    public static ApplicationDescriptorMBean loadDeploymentDescriptor(VirtualJarFile virtualJarFile, File file, File file2) throws DeploymentException {
        if (debug) {
            Debug.say((String)("loadDeploymentDescriptor \nVirtualJarFile : " + virtualJarFile.getName() + "\nstdAppDD : " + (file != null ? file.getPath() : "null") + "\nwlsAppDD : " + (file2 != null ? file2.getPath() : "null")));
        }
        ApplicationDescriptorMBeanImpl applicationDescriptorMBeanImpl = new ApplicationDescriptorMBeanImpl();
        return DDUtils.loadDeploymentDescriptor(applicationDescriptorMBeanImpl, virtualJarFile, file, file2);
    }

    public static ApplicationDescriptorMBean loadDeploymentDescriptor(ApplicationDescriptorMBean applicationDescriptorMBean, VirtualJarFile virtualJarFile, File file, File file2) throws DeploymentException {
        if (applicationDescriptorMBean == null) {
            applicationDescriptorMBean = new ApplicationDescriptorMBeanImpl();
        }
        DDUtils.loadStdDescriptor(applicationDescriptorMBean, virtualJarFile, file);
        DDUtils.loadWlsDescriptor(applicationDescriptorMBean, virtualJarFile, file2);
        return applicationDescriptorMBean;
    }

    public static J2EEApplicationDescriptorMBean loadStdDescriptor(ApplicationDescriptorMBean applicationDescriptorMBean, VirtualJarFile virtualJarFile, File file) throws DeploymentException {
        if (debug) {
            Debug.say((String)("loadStdDescriptor \nVirtualJarFile : " + virtualJarFile.getName() + "\nstdAppDD : " + (file != null ? file.getPath() : "null")));
        }
        String string = DDUtils.findFirstEntry(virtualJarFile, STD_DESCRIPTOR_PATHS);
        if (debug) {
            Debug.say((String)("loadStdDescriptor \nddURI : " + string));
        }
        if (string == null && file == null) {
            return null;
        }
        if (applicationDescriptorMBean == null) {
            applicationDescriptorMBean = new ApplicationDescriptorMBeanImpl();
        }
        try {
            DDUtils.processXML(applicationDescriptorMBean, virtualJarFile, string, file);
        }
        catch (IOException iOException) {
            String string2 = "Error while loading descriptors: " + iOException;
            throw new DeploymentException(string2, iOException);
        }
        catch (XMLProcessingException xMLProcessingException) {
            Throwable throwable = xMLProcessingException.getNestedException();
            if (throwable instanceof SAXProcessorException) {
                throwable = ((SAXProcessorException)throwable).getException();
            }
            if (throwable instanceof DeploymentException) {
                throw (DeploymentException)((Object)throwable);
            }
            String string3 = "Error while loading descriptors: " + (Object)((Object)xMLProcessingException);
            throw new DeploymentException(string3, (Throwable)((Object)xMLProcessingException));
        }
        catch (XMLParsingException xMLParsingException) {
            String string4 = "Error while loading descriptors: " + (Object)((Object)xMLParsingException);
            throw new DeploymentException(string4, (Throwable)((Object)xMLParsingException));
        }
        return applicationDescriptorMBean.getJ2EEApplicationDescriptor();
    }

    public static WeblogicApplicationMBean loadWlsDescriptor(ApplicationDescriptorMBean applicationDescriptorMBean, VirtualJarFile virtualJarFile, File file) throws DeploymentException {
        if (debug) {
            Debug.say((String)("loadWlsDescriptor \nVirtualJarFile : " + virtualJarFile.getName() + "\nstdAppDD : " + (file != null ? file.getPath() : "null")));
        }
        String string = DDUtils.findFirstEntry(virtualJarFile, WLS_DESCRIPTOR_PATHS);
        if (debug) {
            Debug.say((String)("loadWlsdDescriptor \nddURI : " + string));
        }
        if (string == null && file == null) {
            return null;
        }
        if (applicationDescriptorMBean == null) {
            applicationDescriptorMBean = new ApplicationDescriptorMBeanImpl();
        }
        try {
            DDUtils.processXML(applicationDescriptorMBean, virtualJarFile, string, file);
        }
        catch (IOException iOException) {
            String string2 = "Error while loading descriptors: " + iOException;
            throw new DeploymentException(string2, iOException);
        }
        catch (XMLProcessingException xMLProcessingException) {
            Throwable throwable = xMLProcessingException.getNestedException();
            if (throwable instanceof SAXProcessorException) {
                throwable = ((SAXProcessorException)throwable).getException();
            }
            if (throwable instanceof DeploymentException) {
                throw (DeploymentException)((Object)throwable);
            }
            String string3 = "Error while loading descriptors: " + (Object)((Object)xMLProcessingException);
            throw new DeploymentException(string3, (Throwable)((Object)xMLProcessingException));
        }
        catch (XMLParsingException xMLParsingException) {
            String string4 = "Error while loading descriptors: " + (Object)((Object)xMLParsingException);
            throw new DeploymentException(string4, (Throwable)((Object)xMLParsingException));
        }
        return applicationDescriptorMBean.getWeblogicApplicationDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void processXML(ApplicationDescriptorMBean applicationDescriptorMBean, VirtualJarFile virtualJarFile, String string, File file) throws IOException, XMLProcessingException, XMLParsingException {
        InputStream inputStream = null;
        try {
            if (file != null) {
                inputStream = new FileInputStream(file);
                DDUtils.processXML(inputStream, applicationDescriptorMBean, file.getPath());
            } else {
                ZipEntry zipEntry = virtualJarFile.getEntry(string);
                if (zipEntry == null) {
                    throw new FileNotFoundException("Could not find " + string);
                }
                inputStream = virtualJarFile.getInputStream(zipEntry);
                DDUtils.processXML(inputStream, applicationDescriptorMBean, string);
            }
            Object var7_6 = null;
            if (inputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
    }

    private static void processXML(InputStream inputStream, ApplicationDescriptorMBean applicationDescriptorMBean, String string) throws XMLProcessingException, XMLParsingException, IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        String string2 = DDUtils.getXMLEncoding(inputStream, string);
        inputStream.mark(0x100000);
        XMLProcessor xMLProcessor = null;
        try {
            xMLProcessor = new ProcessorFactory().getProcessor(inputStream, validPublicIds);
        }
        catch (ProcessorFactoryException processorFactoryException) {
            throw new XMLProcessingException((Throwable)((Object)processorFactoryException), string);
        }
        inputStream.reset();
        if (xMLProcessor instanceof J2EEDeploymentDescriptorLoader) {
            J2EEDeploymentDescriptorLoader j2EEDeploymentDescriptorLoader = (J2EEDeploymentDescriptorLoader)((Object)xMLProcessor);
            J2EEDeploymentDescriptor j2EEDeploymentDescriptor = new J2EEDeploymentDescriptor();
            applicationDescriptorMBean.setJ2EEApplicationDescriptor(j2EEDeploymentDescriptor);
            j2EEDeploymentDescriptor.setEncoding(string2);
            j2EEDeploymentDescriptorLoader.setDD(j2EEDeploymentDescriptor);
            try {
                j2EEDeploymentDescriptorLoader.process(inputStream);
            }
            catch (XMLParsingException xMLParsingException) {
                xMLParsingException.setFileName(string);
                throw xMLParsingException;
            }
            catch (XMLProcessingException xMLProcessingException) {
                xMLProcessingException.setFileName(string);
                throw xMLProcessingException;
            }
        }
        if (xMLProcessor instanceof WADDLoader) {
            WADDLoader wADDLoader = (WADDLoader)((Object)xMLProcessor);
            wADDLoader.setApplicationDescriptor(applicationDescriptorMBean);
            try {
                wADDLoader.process(inputStream);
            }
            catch (XMLParsingException xMLParsingException) {
                xMLParsingException.setFileName(string);
                throw xMLParsingException;
            }
            catch (XMLProcessingException xMLProcessingException) {
                xMLProcessingException.setFileName(string);
                throw xMLProcessingException;
            }
            WeblogicApplicationMBean weblogicApplicationMBean = applicationDescriptorMBean.getWeblogicApplicationDescriptor();
            weblogicApplicationMBean.setEncoding(string2);
        } else {
            throw new XMLProcessingException("Invalid descriptor file: " + string);
        }
    }

    private static String findFirstEntry(VirtualJarFile virtualJarFile, String[] stringArray) {
        if (stringArray == null || virtualJarFile == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            ZipEntry zipEntry = virtualJarFile.getEntry(stringArray[i]);
            if (zipEntry == null) continue;
            return stringArray[i];
        }
        return null;
    }

    private static InputStream getEntry(VirtualJarFile virtualJarFile, String string) throws IOException {
        ZipEntry zipEntry = virtualJarFile.getEntry(string);
        if (zipEntry == null) {
            throw new FileNotFoundException(string + " not found in jar file");
        }
        return virtualJarFile.getInputStream(zipEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getXMLEncoding(InputStream inputStream, String string) throws IOException {
        String string2 = null;
        inputStream.mark(0x100000);
        try {
            XMLDeclaration xMLDeclaration = new XMLDeclaration();
            xMLDeclaration.parse(inputStream);
            string2 = xMLDeclaration.getEncoding();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            inputStream.reset();
            throw throwable;
        }
        inputStream.reset();
        DDUtils.validateEncoding(string2, string);
        return string2;
    }

    private static void validateEncoding(String string, String string2) throws IOException {
        if (string != null && Encoding.getIANA2JavaMapping(string) == null && Encoding.getJava2IANAMapping(string) == null && !Charset.isSupported(string)) {
            Loggable loggable = J2EELogger.logDescriptorUsesInvalidEncodingLoggable((String)string2, (String)string);
            throw new UnsupportedEncodingException(loggable.getMessage());
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length <= 0) {
                Debug.say((String)"Usage : java weblogic.j2ee.dd.xml.DDUtils $jarfilename");
                return;
            }
            File file = new File(stringArray[0]);
            ApplicationDescriptorMBeanImpl applicationDescriptorMBeanImpl = new ApplicationDescriptorMBeanImpl();
            System.out.println("OPEN " + file);
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            ApplicationDescriptorMBean applicationDescriptorMBean = DDUtils.loadDeploymentDescriptor(applicationDescriptorMBeanImpl, virtualJarFile, null, null);
            J2EEApplicationDescriptorMBean j2EEApplicationDescriptorMBean = applicationDescriptorMBean.getJ2EEApplicationDescriptor();
            WeblogicApplicationMBean weblogicApplicationMBean = applicationDescriptorMBean.getWeblogicApplicationDescriptor();
            Debug.say((String)"Printing xml file ......");
            Debug.say((String)j2EEApplicationDescriptorMBean.toXML(2));
            Debug.say((String)"=============");
            Debug.say((String)(weblogicApplicationMBean != null ? weblogicApplicationMBean.toXML(2) : "WLS descriptor null"));
            Debug.say((String)"Printed xml file ......");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

