/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.RunAs;
import javax.ejb.EJB;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.BaseJ2eeAnnotationProcessor;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.J2eeEnvironmentBean;
import weblogic.j2ee.descriptor.JavaEEPropertyBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.javaee.EJBReference;

public class J2eeAnnotationProcessor
extends BaseJ2eeAnnotationProcessor {
    public void processJ2eeAnnotations(Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        for (PersistenceContext persistenceContext : this.getClassPersistenceContextRefs(clazz)) {
            this.addPersistenceContextRef(persistenceContext.name(), persistenceContext, (J2eeEnvironmentBean)j2eeClientEnvironmentBean, false);
        }
        super.processJ2eeAnnotations(clazz, j2eeClientEnvironmentBean);
    }

    protected void processField(Field field, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        if (field.isAnnotationPresent(PersistenceContext.class)) {
            this.addPersistenceContextRef(field, (J2eeEnvironmentBean)j2eeClientEnvironmentBean);
        } else {
            super.processField(field, j2eeClientEnvironmentBean);
        }
    }

    protected void processMethod(Method method, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        if (method.isAnnotationPresent(PersistenceContext.class)) {
            this.addPersistenceContextRef(method, (J2eeEnvironmentBean)j2eeClientEnvironmentBean);
        } else {
            super.processMethod(method, j2eeClientEnvironmentBean);
        }
    }

    private void addPersistenceContextRef(Field field, J2eeEnvironmentBean j2eeEnvironmentBean) {
        PersistenceContext persistenceContext = field.getAnnotation(PersistenceContext.class);
        String string = this.getCompEnvJndiName(persistenceContext.name(), field);
        if (this.findInjectionTargetFromPersistenceContextRef(field, string, j2eeEnvironmentBean) == null) {
            this.addInjectionTarget(field, this.addPersistenceContextRef(string, persistenceContext, j2eeEnvironmentBean, true));
        }
    }

    private void addPersistenceContextRef(Method method, J2eeEnvironmentBean j2eeEnvironmentBean) {
        PersistenceContext persistenceContext = method.getAnnotation(PersistenceContext.class);
        String string = this.getCompEnvJndiName(persistenceContext.name(), method);
        if (this.findInjectionTargetFromPersistenceContextRef(method, string, j2eeEnvironmentBean) == null) {
            this.addInjectionTarget(method, this.addPersistenceContextRef(string, persistenceContext, j2eeEnvironmentBean, true));
        }
    }

    private InjectionTargetBean addPersistenceContextRef(String string, PersistenceContext persistenceContext, J2eeEnvironmentBean j2eeEnvironmentBean, boolean bl) {
        PersistenceContextRefBean persistenceContextRefBean = null;
        for (PersistenceContextRefBean persistenceContextRefBean2 : j2eeEnvironmentBean.getPersistenceContextRefs()) {
            if (!persistenceContextRefBean2.getPersistenceContextRefName().equals(string)) continue;
            persistenceContextRefBean = persistenceContextRefBean2;
            break;
        }
        if (persistenceContextRefBean == null) {
            persistenceContextRefBean = j2eeEnvironmentBean.createPersistenceContextRef();
            persistenceContextRefBean.setPersistenceContextRefName(string);
        }
        if (!this.isSet("PersistenceUnitName", persistenceContextRefBean) && persistenceContext.unitName().length() > 0) {
            persistenceContextRefBean.setPersistenceUnitName(persistenceContext.unitName());
        }
        if (!this.isSet("PersistenceContextType", persistenceContextRefBean)) {
            if (persistenceContext.type() == PersistenceContextType.TRANSACTION) {
                persistenceContextRefBean.setPersistenceContextType("Transaction");
            } else {
                persistenceContextRefBean.setPersistenceContextType("Extended");
            }
        }
        if (!this.isSet("PersistenceProperties", persistenceContextRefBean)) {
            for (PersistenceContextRefBean persistenceContextRefBean2 : persistenceContext.properties()) {
                JavaEEPropertyBean javaEEPropertyBean = persistenceContextRefBean.createPersistenceProperty();
                javaEEPropertyBean.setName(persistenceContextRefBean2.name());
                javaEEPropertyBean.setValue(javaEEPropertyBean.getValue());
            }
        }
        if (bl) {
            return persistenceContextRefBean.createInjectionTarget();
        }
        return null;
    }

    protected InjectionTargetBean findInjectionTargetFromEjbRef(String string, String string2, String string3, Class clazz, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        InjectionTargetBean injectionTargetBean;
        EjbLocalRefBean ejbLocalRefBean;
        EjbRefBean ejbRefBean = this.findEjbRef(string3, j2eeClientEnvironmentBean);
        if (ejbRefBean != null && (ejbLocalRefBean = this.findInjectionTargetInArray(string, string2, ejbRefBean.getInjectionTargets())) != null) {
            return ejbLocalRefBean;
        }
        ejbLocalRefBean = this.findEjbLocalRef(string3, (J2eeEnvironmentBean)j2eeClientEnvironmentBean);
        if (ejbLocalRefBean != null && (injectionTargetBean = this.findInjectionTargetInArray(string, string2, ejbLocalRefBean.getInjectionTargets())) != null) {
            return injectionTargetBean;
        }
        return null;
    }

    protected InjectionTargetBean findInjectionTargetFromPersistenceContextRef(Method method, String string, J2eeEnvironmentBean j2eeEnvironmentBean) {
        return this.findInjectionTargetFromPersistenceContextRef(method.getDeclaringClass().getName(), this.getPropertyName(method), string, j2eeEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromPersistenceContextRef(Field field, String string, J2eeEnvironmentBean j2eeEnvironmentBean) {
        return this.findInjectionTargetFromPersistenceContextRef(field.getDeclaringClass().getName(), field.getName(), string, j2eeEnvironmentBean);
    }

    protected InjectionTargetBean findInjectionTargetFromPersistenceContextRef(String string, String string2, String string3, J2eeEnvironmentBean j2eeEnvironmentBean) {
        PersistenceContextRefBean persistenceContextRefBean = null;
        for (PersistenceContextRefBean persistenceContextRefBean2 : j2eeEnvironmentBean.getPersistenceContextRefs()) {
            if (!persistenceContextRefBean2.getPersistenceContextRefName().equals(string3)) continue;
            persistenceContextRefBean = persistenceContextRefBean2;
            break;
        }
        if (persistenceContextRefBean != null) {
            return this.findInjectionTargetInArray(string, string2, persistenceContextRefBean.getInjectionTargets());
        }
        return null;
    }

    protected InjectionTargetBean addEjbRef(String string, Class clazz, EJBReference eJBReference, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        J2eeEnvironmentBean j2eeEnvironmentBean = (J2eeEnvironmentBean)j2eeClientEnvironmentBean;
        EjbRefBean ejbRefBean = this.findEjbRef(string, (J2eeClientEnvironmentBean)j2eeEnvironmentBean);
        if (ejbRefBean != null) {
            return this.addEJBRemoteRef(string, clazz, eJBReference, (J2eeClientEnvironmentBean)j2eeEnvironmentBean, ejbRefBean, bl);
        }
        EjbLocalRefBean ejbLocalRefBean = this.findEjbLocalRef(string, j2eeEnvironmentBean);
        if (ejbLocalRefBean != null) {
            return this.addEJBLocalRef(string, clazz, eJBReference, j2eeEnvironmentBean, ejbLocalRefBean, bl);
        }
        if (clazz == Object.class) {
            this.addBeanInterfaceNotSetError(j2eeClientEnvironmentBean);
            return null;
        }
        return this.addEJBLocalRef(string, clazz, eJBReference, j2eeEnvironmentBean, null, bl);
    }

    protected InjectionTargetBean addEjbRef(String string, Class clazz, EJB eJB, J2eeClientEnvironmentBean j2eeClientEnvironmentBean, boolean bl) {
        J2eeEnvironmentBean j2eeEnvironmentBean = (J2eeEnvironmentBean)j2eeClientEnvironmentBean;
        EjbRefBean ejbRefBean = this.findEjbRef(string, (J2eeClientEnvironmentBean)j2eeEnvironmentBean);
        if (ejbRefBean != null) {
            return this.addEJBRemoteRef(string, clazz, eJB, (J2eeClientEnvironmentBean)j2eeEnvironmentBean, ejbRefBean, bl);
        }
        EjbLocalRefBean ejbLocalRefBean = this.findEjbLocalRef(string, j2eeEnvironmentBean);
        if (ejbLocalRefBean != null) {
            return this.addEJBLocalRef(string, clazz, eJB, j2eeEnvironmentBean, ejbLocalRefBean, bl);
        }
        if (EJBHome.class.isAssignableFrom(clazz)) {
            return this.addEJBRemoteRef(string, clazz, eJB, (J2eeClientEnvironmentBean)j2eeEnvironmentBean, null, bl);
        }
        if (EJBLocalHome.class.isAssignableFrom(clazz)) {
            return this.addEJBLocalRef(string, clazz, eJB, j2eeEnvironmentBean, null, bl);
        }
        return this.addEJBLocalRef(string, clazz, eJB, j2eeEnvironmentBean, null, bl);
    }

    private InjectionTargetBean addEJBLocalRef(String string, Class clazz, EJBReference eJBReference, J2eeEnvironmentBean j2eeEnvironmentBean, EjbLocalRefBean ejbLocalRefBean, boolean bl) {
        if (ejbLocalRefBean == null) {
            ejbLocalRefBean = j2eeEnvironmentBean.createEjbLocalRef();
            ejbLocalRefBean.setEjbRefName(string);
        }
        if (clazz != Object.class) {
            if (EJBLocalHome.class.isAssignableFrom(clazz)) {
                if (!this.isSet("LocalHome", ejbLocalRefBean)) {
                    ejbLocalRefBean.setLocalHome(clazz.getName());
                }
            } else if (!this.isSet("Local", ejbLocalRefBean)) {
                ejbLocalRefBean.setLocal(clazz.getName());
            }
        }
        if (!this.isSet("MappedName", ejbLocalRefBean) && eJBReference.jndiName().length() > 0) {
            ejbLocalRefBean.setMappedName("weblogic-jndi:" + eJBReference.jndiName());
        }
        if (bl) {
            return ejbLocalRefBean.createInjectionTarget();
        }
        return null;
    }

    private InjectionTargetBean addEJBLocalRef(String string, Class clazz, EJB eJB, J2eeEnvironmentBean j2eeEnvironmentBean, EjbLocalRefBean ejbLocalRefBean, boolean bl) {
        if (ejbLocalRefBean == null) {
            ejbLocalRefBean = j2eeEnvironmentBean.createEjbLocalRef();
            ejbLocalRefBean.setEjbRefName(string);
        }
        if (clazz != Object.class) {
            if (EJBLocalHome.class.isAssignableFrom(clazz)) {
                if (!this.isSet("LocalHome", ejbLocalRefBean)) {
                    ejbLocalRefBean.setLocalHome(clazz.getName());
                }
            } else if (!this.isSet("Local", ejbLocalRefBean)) {
                ejbLocalRefBean.setLocal(clazz.getName());
            }
        }
        if (!this.isSet("EjbLink", ejbLocalRefBean) && eJB.beanName().length() > 0) {
            ejbLocalRefBean.setEjbLink(eJB.beanName());
        }
        if (!this.isSet("MappedName", ejbLocalRefBean) && eJB.mappedName().length() > 0) {
            ejbLocalRefBean.setMappedName(eJB.mappedName());
        }
        if (bl) {
            return ejbLocalRefBean.createInjectionTarget();
        }
        return null;
    }

    private EjbLocalRefBean findEjbLocalRef(String string, J2eeEnvironmentBean j2eeEnvironmentBean) {
        for (EjbLocalRefBean ejbLocalRefBean : j2eeEnvironmentBean.getEjbLocalRefs()) {
            if (!string.equals(ejbLocalRefBean.getEjbRefName())) continue;
            return ejbLocalRefBean;
        }
        return null;
    }

    protected void processRunAs(Class clazz, DescriptorBean descriptorBean) {
        if (clazz.isAnnotationPresent(RunAs.class)) {
            RunAs runAs = clazz.getAnnotation(RunAs.class);
            this.perhapsDeclareRunAs(descriptorBean, runAs.value());
        }
    }

    protected void perhapsDeclareRunAs(DescriptorBean descriptorBean, String string) {
    }

    protected void processDeclareRoles(Class clazz, DescriptorBean descriptorBean) {
        if (clazz.isAnnotationPresent(DeclareRoles.class)) {
            DeclareRoles declareRoles = clazz.getAnnotation(DeclareRoles.class);
            this.perhapsDeclareRoles(descriptorBean, declareRoles.value());
        }
    }

    protected void perhapsDeclareRoles(DescriptorBean descriptorBean, String[] stringArray) {
    }
}

