/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import weblogic.j2ee.dd.ModuleDescriptor;
import weblogic.management.descriptors.ApplicationDescriptorMBean;
import weblogic.management.descriptors.application.weblogic.EntityCacheMBean;
import weblogic.xml.process.SAXValidationException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.process.XMLProcessingException;

public abstract class WADDLoader {
    private static final boolean debug = System.getProperty("weblogic.j2ee.dd.xml") != null;
    private static boolean verbose = System.getProperty("weblogic.j2ee.dd.xml") != null;
    protected ApplicationDescriptorMBean applicationDescriptor = null;
    private ModuleDescriptor currentModuleContext;
    protected boolean validate = true;

    public void setApplicationDescriptor(ApplicationDescriptorMBean applicationDescriptorMBean) {
        this.applicationDescriptor = applicationDescriptorMBean;
    }

    public ApplicationDescriptorMBean getApplicationDescriptor() {
        return this.applicationDescriptor;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public abstract void process(String var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(File var1) throws IOException, XMLParsingException, XMLProcessingException;

    public abstract void process(InputStream var1) throws IOException, XMLParsingException, XMLProcessingException;

    protected void validatePositiveInteger(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Parameter must be an integer");
        }
        if (n < 0) {
            throw new Exception("Parameter must be a positive integer");
        }
    }

    protected void validateIntegerGreaterThanNegativeOne(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Parameter must be an integer");
        }
        if (n < -1) {
            throw new Exception("Parameter must be an integer greater than -1");
        }
    }

    protected void validateIntegerGreaterThanZero(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Parameter must be an integer");
        }
        if (n <= 0) {
            throw new Exception("Parameter must be an integer greater 0");
        }
    }

    protected void validateStmtCacheSize(String string) throws Exception {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new Exception("Parameter must be an integer");
        }
        if (n < 0 || n > 1024) {
            throw new Exception("Parameter must be an integer greater than (0) and lesser than (1024)");
        }
    }

    protected void validateStmtCacheType(String string) throws Exception {
        if (!string.equals("LRU") && !string.equals("FIXED")) {
            throw new Exception("Statement cache type must either be (LRU) or (FIXED)");
        }
    }

    protected void validateCachingStrategy(EntityCacheMBean entityCacheMBean, String string) throws SAXValidationException {
        SAXValidationException sAXValidationException = null;
        if (!"Exclusive".equalsIgnoreCase(string) && !"MultiVersion".equalsIgnoreCase(string)) {
            sAXValidationException = new SAXValidationException("Invalid caching-strategy of '" + string + "' specified for entity-cache '" + entityCacheMBean.getEntityCacheName() + "'.  Value must be 'Exclusive' or 'MultiVersion'.");
            throw sAXValidationException;
        }
    }

    protected void setCurrentModuleContext(ModuleDescriptor moduleDescriptor) {
        this.currentModuleContext = moduleDescriptor;
    }

    protected ModuleDescriptor getCurrentModuleContext() {
        return this.currentModuleContext;
    }
}

