/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator;

import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.Visitor;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.j2ee.dd.xml.validator.AnnotationValidator;
import weblogic.j2ee.dd.xml.validator.injectiontarget.InjectionTargetValidatorFactory;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.LifecycleCallbackValidatorFactory;
import weblogic.j2ee.dd.xml.validator.listener.ListenerBeanValidator;
import weblogic.utils.ErrorCollectionException;

public class AnnotationValidatorVisitor
implements Visitor {
    private ClassLoader classLoader = null;
    private ErrorCollectionException errors = null;

    public AnnotationValidatorVisitor(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.errors = new ErrorCollectionException();
    }

    public void visit(AbstractDescriptorBean abstractDescriptorBean) {
        this.visitLifeCycleCallbackBean(abstractDescriptorBean);
        this.visitInjectionTargetBean(abstractDescriptorBean);
        this.visitListenerBean(abstractDescriptorBean);
    }

    public ErrorCollectionException getErrors() {
        return this.errors;
    }

    private void visitLifeCycleCallbackBean(AbstractDescriptorBean abstractDescriptorBean) {
        AnnotationValidator annotationValidator = LifecycleCallbackValidatorFactory.getValidator((DescriptorBean)abstractDescriptorBean);
        if (annotationValidator != null) {
            try {
                annotationValidator.validate((DescriptorBean)abstractDescriptorBean, this.classLoader);
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.errors.add((Throwable)errorCollectionException);
            }
        }
    }

    private void visitInjectionTargetBean(AbstractDescriptorBean abstractDescriptorBean) {
        AnnotationValidator annotationValidator = InjectionTargetValidatorFactory.getValidator((DescriptorBean)abstractDescriptorBean);
        if (annotationValidator != null) {
            try {
                annotationValidator.validate((DescriptorBean)abstractDescriptorBean, this.classLoader);
            }
            catch (ErrorCollectionException errorCollectionException) {
                this.errors.add((Throwable)errorCollectionException);
            }
        }
    }

    private void visitListenerBean(AbstractDescriptorBean abstractDescriptorBean) {
        try {
            ListenerBeanValidator listenerBeanValidator = new ListenerBeanValidator();
            listenerBeanValidator.validate((DescriptorBean)abstractDescriptorBean, this.classLoader);
        }
        catch (ErrorCollectionException errorCollectionException) {
            this.errors.add((Throwable)errorCollectionException);
        }
    }
}

