/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator.injectiontarget;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.validator.AbstractAnnotationValidator;
import weblogic.j2ee.dd.xml.validator.AnnotationValidatorHelper;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.utils.ErrorCollectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseValidator
extends AbstractAnnotationValidator {
    private static Class[] ANNOTATION_CLASSES = new Class[]{Resource.class, EJB.class, PersistenceContext.class, PersistenceUnit.class, WebServiceRef.class};

    BaseValidator() {
    }

    @Override
    protected Class getClass(DescriptorBean descriptorBean, ClassLoader classLoader) throws ClassNotFoundException {
        String string = ((InjectionTargetBean)descriptorBean).getInjectionTargetClass();
        return AnnotationValidatorHelper.getClass(string, classLoader);
    }

    @Override
    protected final Method getMethod(DescriptorBean descriptorBean, Class clazz) {
        String string = ((InjectionTargetBean)descriptorBean).getInjectionTargetName();
        String string2 = AnnotationValidatorHelper.getSetterName(string);
        List<Method> list = AnnotationValidatorHelper.getMethods(clazz, string2);
        Field field = AnnotationValidatorHelper.getField(clazz, string);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (field != null) {
            for (Method method : list) {
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1 || !classArray[0].equals(field.getType())) continue;
                return method;
            }
        }
        return list.get(0);
    }

    @Override
    protected final Field getField(DescriptorBean descriptorBean, Class clazz) {
        String string = ((InjectionTargetBean)descriptorBean).getInjectionTargetName();
        return AnnotationValidatorHelper.getField(clazz, string);
    }

    @Override
    protected final void checkUndefinedMethodField(DescriptorBean descriptorBean, Field field, Method method, ErrorCollectionException errorCollectionException) {
        if (field == null && method == null) {
            String string = ((InjectionTargetBean)descriptorBean).getInjectionTargetClass();
            String string2 = ((InjectionTargetBean)descriptorBean).getInjectionTargetName();
            String string3 = AnnotationValidatorHelper.getSetterName(string2);
            errorCollectionException.add((Throwable)this.error("\"" + string2 + "\" is defined as injection target" + " in descriptor file for class \"" + string + "\", but either field \"" + string2 + "\" or method \"" + string3 + "\" cannot be found within the class."));
        }
    }

    @Override
    protected final void checkAnnotation(Method method, Field field, ErrorCollectionException errorCollectionException) {
        for (Class clazz : ANNOTATION_CLASSES) {
            this.checkNameMethodOnAnnotation(method, field, clazz, errorCollectionException);
        }
    }

    private void checkNameMethodOnAnnotation(Method method, Field field, Class<? extends Annotation> clazz, ErrorCollectionException errorCollectionException) {
        if (!method.isAnnotationPresent(clazz)) {
            return;
        }
        if (!field.isAnnotationPresent(clazz)) {
            return;
        }
        String string = "name";
        Annotation annotation = method.getAnnotation(clazz);
        Annotation annotation2 = field.getAnnotation(clazz);
        try {
            Method method2 = annotation.getClass().getDeclaredMethod(string, new Class[0]);
            Method method3 = annotation2.getClass().getDeclaredMethod(string, new Class[0]);
            Object object = method2.invoke((Object)annotation, new Object[0]);
            Object object2 = method3.invoke((Object)annotation2, new Object[0]);
            if (object != null && object2 != null && !object.equals(object2)) {
                errorCollectionException.add((Throwable)this.error("Annotation @" + clazz.getSimpleName() + " is defined on both method \"" + method.getName() + "\" and field \"" + field.getName() + "\", but they are inconsistent."));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    protected final Exception error(String string) {
        return new IllegalArgumentException(string);
    }

    protected final Exception error(Field field, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (field == null) {
            return this.error(string);
        }
        Class<?> clazz = field.getDeclaringClass();
        String string2 = field.getName();
        stringBuffer.append("Field \"").append(string2).append(this.getMessageBody(clazz, string2, string));
        return this.error(stringBuffer.toString());
    }

    protected final Exception error(Method method, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (method == null) {
            return this.error(string);
        }
        Class<?> clazz = method.getDeclaringClass();
        String string2 = method.getName();
        String string3 = AnnotationValidatorHelper.getFieldName(string2);
        stringBuffer.append("Method \"").append(string2).append(this.getMessageBody(clazz, string3, string));
        return this.error(stringBuffer.toString());
    }

    private String getMessageBody(Class clazz, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\" in class \"").append(clazz.getName()).append("\" is defined as injection target ");
        String string3 = this.getInjectionTargetAnnotation(clazz, string);
        if (string3 == null || string3.length() == 0) {
            stringBuffer.append("in deployment descriptor file, ");
        } else {
            stringBuffer.append("with annotation ").append(string3);
        }
        stringBuffer.append("but ").append(string2).append(".");
        return stringBuffer.toString();
    }

    private String getInjectionTargetAnnotation(Class clazz, String string) {
        HashSet<Class> hashSet = new HashSet<Class>();
        Field field = AnnotationValidatorHelper.getField(clazz, string);
        if (field != null) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                hashSet.add(annotation.annotationType());
            }
        }
        String string2 = AnnotationValidatorHelper.getSetterName(string);
        List<Method> list = AnnotationValidatorHelper.getMethods(clazz, string2);
        for (Method method : list) {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                hashSet.add(annotation.annotationType());
            }
        }
        return this.getInjectionTargetAnnotation(hashSet);
    }

    private String getInjectionTargetAnnotation(Set<Class> set) {
        String string = "";
        for (Class clazz : set) {
            if (!set.contains(clazz)) continue;
            string = string + "@" + clazz.getSimpleName() + ", ";
        }
        return string;
    }
}

