/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator.lifecyclecallback;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.validator.AbstractAnnotationValidator;
import weblogic.j2ee.dd.xml.validator.AnnotationValidatorHelper;
import weblogic.j2ee.descriptor.EjbCallbackBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.utils.ErrorCollectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseValidator
extends AbstractAnnotationValidator {
    BaseValidator() {
    }

    @Override
    protected Class getClass(DescriptorBean descriptorBean, ClassLoader classLoader) throws ClassNotFoundException {
        String string = ((LifecycleCallbackBean)descriptorBean).getLifecycleCallbackClass();
        return AnnotationValidatorHelper.getClass(string, classLoader);
    }

    @Override
    protected final Field getField(DescriptorBean descriptorBean, Class clazz) {
        return null;
    }

    @Override
    protected final void checkField(Field field, ErrorCollectionException errorCollectionException) {
    }

    @Override
    protected final void checkAnnotation(Method method, Field field, ErrorCollectionException errorCollectionException) {
    }

    @Override
    protected final Method getMethod(DescriptorBean descriptorBean, Class clazz) {
        String string = ((LifecycleCallbackBean)descriptorBean).getLifecycleCallbackMethod();
        List<Method> list = AnnotationValidatorHelper.getMethods(clazz, string);
        if (list.size() == 0) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.guessMethod(list);
    }

    private Method guessMethod(List<Method> list) {
        Method method = this.guessMethodFromAnnotation(list);
        if (method != null) {
            return method;
        }
        method = this.guessMethodFromSignature(list);
        if (method != null) {
            return method;
        }
        return list.get(0);
    }

    protected Method guessMethodFromAnnotation(List<Method> list) {
        for (Method method : list) {
            if (!method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(PostConstruct.class)) continue;
            return method;
        }
        return null;
    }

    protected Method guessMethodFromSignature(List<Method> list) {
        for (Method method : list) {
            if (!method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(PostConstruct.class)) continue;
            return method;
        }
        return null;
    }

    @Override
    protected final void checkBean(DescriptorBean descriptorBean, ErrorCollectionException errorCollectionException) {
        String string;
        LifecycleCallbackBean[] lifecycleCallbackBeanArray;
        J2eeClientEnvironmentBean j2eeClientEnvironmentBean;
        DescriptorBean descriptorBean2 = descriptorBean.getParentBean();
        HashSet<String> hashSet = new HashSet<String>();
        if (descriptorBean2 instanceof J2eeClientEnvironmentBean) {
            j2eeClientEnvironmentBean = (J2eeClientEnvironmentBean)descriptorBean2;
            for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray = j2eeClientEnvironmentBean.getPostConstructs()) {
                string = lifecycleCallbackBean.getLifecycleCallbackClass();
                if (lifecycleCallbackBean.getBeanSource() != 1 || hashSet.add(string)) continue;
                errorCollectionException.add((Throwable)this.error("Cannot define multiple post-construct lifecycle callback methods on class \"" + string + "\""));
                break;
            }
            hashSet.clear();
            for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray = j2eeClientEnvironmentBean.getPreDestroys()) {
                string = lifecycleCallbackBean.getLifecycleCallbackClass();
                if (lifecycleCallbackBean.getBeanSource() != 1 || hashSet.add(string)) continue;
                errorCollectionException.add((Throwable)this.error("Cannot define multiple pre-destroy lifecycle callback methods on class \"" + string + "\""));
                break;
            }
        }
        hashSet.clear();
        if (descriptorBean2 instanceof EjbCallbackBean) {
            j2eeClientEnvironmentBean = (EjbCallbackBean)descriptorBean2;
            for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray = j2eeClientEnvironmentBean.getPrePassivates()) {
                string = lifecycleCallbackBean.getLifecycleCallbackClass();
                if (lifecycleCallbackBean.getBeanSource() != 1 || hashSet.add(string)) continue;
                errorCollectionException.add((Throwable)this.error("Cannot define multiple pre-passivate lifecycle callback methods on class \"" + string + "\""));
                break;
            }
            hashSet.clear();
            for (LifecycleCallbackBean lifecycleCallbackBean : lifecycleCallbackBeanArray = j2eeClientEnvironmentBean.getPostActivates()) {
                string = lifecycleCallbackBean.getLifecycleCallbackClass();
                if (lifecycleCallbackBean.getBeanSource() != 1 || hashSet.add(string)) continue;
                errorCollectionException.add((Throwable)this.error("Cannot define multiple post-activate lifecycle callback methods on class \"" + string + "\""));
                break;
            }
        }
    }

    @Override
    protected void checkReturnType(Method method, ErrorCollectionException errorCollectionException) {
        if (method.getReturnType() != Void.TYPE) {
            errorCollectionException.add((Throwable)this.error(method, "its return type must be void"));
        }
    }

    @Override
    protected void checkException(Method method, ErrorCollectionException errorCollectionException) {
        for (Class<Exception> clazz : method.getExceptionTypes()) {
            if (clazz.isAssignableFrom(Exception.class)) {
                return;
            }
            if (RuntimeException.class.isAssignableFrom(clazz) || Error.class.isAssignableFrom(clazz)) continue;
            errorCollectionException.add((Throwable)this.error(method, "it cannot be declared to throw checked exception"));
        }
    }

    @Override
    protected void checkUndefinedMethodField(DescriptorBean descriptorBean, Field field, Method method, ErrorCollectionException errorCollectionException) {
        LifecycleCallbackBean lifecycleCallbackBean = (LifecycleCallbackBean)descriptorBean;
        String string = lifecycleCallbackBean.getLifecycleCallbackClass();
        String string2 = lifecycleCallbackBean.getLifecycleCallbackMethod();
        if (method == null) {
            errorCollectionException.add((Throwable)this.error("Method \"" + string2 + "\" is defined in deployment descriptor as lifecycle callback method, " + "but it is not defined in class \"" + string + "\"."));
        }
    }

    @Override
    protected void checkParameters(Method method, ErrorCollectionException errorCollectionException) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length > 0) {
            errorCollectionException.add((Throwable)this.error(method, "it must not have any parameter"));
        }
    }

    protected final Exception error(String string) {
        return new IllegalArgumentException(string);
    }

    protected final Exception error(Method method, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (method == null) {
            return this.error(string);
        }
        stringBuffer.append("Method \"").append(method.getName()).append("\" in class \"").append(method.getDeclaringClass().getName()).append("\" is defined as lifecycle callback method ");
        String string2 = this.getLifecycleAnnotations(method);
        if (string2 == null || string2.length() == 0) {
            stringBuffer.append("in deployment descriptor file, ");
        } else {
            stringBuffer.append("with annotation ").append(string2);
        }
        stringBuffer.append("but ").append(string).append(".");
        return this.error(stringBuffer.toString());
    }

    protected String getLifecycleAnnotations(Method method) {
        String string = "";
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation.annotationType() == PostConstruct.class) {
                string = string + "@PostConstruct, ";
            }
            if (annotation.annotationType() != PreDestroy.class) continue;
            string = string + "@PreDestroy, ";
        }
        return string;
    }
}

