/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator.lifecyclecallback;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.validator.AnnotationValidatorHelper;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.J2EEValidator;
import weblogic.j2ee.descriptor.EnterpriseBeanBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.utils.ErrorCollectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJBValidator
extends J2EEValidator {
    EJBValidator() {
    }

    @Override
    protected Class getClass(DescriptorBean descriptorBean, ClassLoader classLoader) throws ClassNotFoundException {
        String string = ((LifecycleCallbackBean)descriptorBean).getLifecycleCallbackClass();
        if (string == null) {
            EnterpriseBeanBean enterpriseBeanBean = (EnterpriseBeanBean)descriptorBean.getParentBean();
            string = enterpriseBeanBean.getEjbClass();
        }
        return AnnotationValidatorHelper.getClass(string, classLoader);
    }

    @Override
    protected Method guessMethodFromAnnotation(List<Method> list) {
        for (Method method : list) {
            if (!method.isAnnotationPresent(PreDestroy.class) && !method.isAnnotationPresent(PostConstruct.class) && !method.isAnnotationPresent(PrePassivate.class) && !method.isAnnotationPresent(PostActivate.class)) continue;
            return method;
        }
        return null;
    }

    @Override
    protected void checkModifier(Method method, ErrorCollectionException errorCollectionException) {
        StringBuffer stringBuffer = null;
        if (Modifier.isStatic(method.getModifiers())) {
            stringBuffer = new StringBuffer().append("it cannot be declared as static");
        }
        if (Modifier.isFinal(method.getModifiers())) {
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer().append("it cannot be declared as final");
            } else {
                stringBuffer.append("and final");
            }
        }
        if (stringBuffer != null) {
            errorCollectionException.add((Throwable)this.error(method, stringBuffer.toString()));
        }
    }

    @Override
    protected String getLifecycleAnnotations(Method method) {
        String string = super.getLifecycleAnnotations(method);
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation.annotationType() == PrePassivate.class) {
                string = string + "@PrePassivate, ";
            }
            if (annotation.annotationType() != PostActivate.class) continue;
            string = string + "@PostActivate, ";
        }
        return string;
    }
}

