/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator.lifecyclecallback;

import java.lang.reflect.Method;
import java.util.List;
import javax.interceptor.InvocationContext;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.validator.AnnotationValidatorHelper;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.EJBValidator;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.utils.ErrorCollectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InterceptorValidator
extends EJBValidator {
    InterceptorValidator() {
    }

    @Override
    protected Class getClass(DescriptorBean descriptorBean, ClassLoader classLoader) throws ClassNotFoundException {
        String string = ((LifecycleCallbackBean)descriptorBean).getLifecycleCallbackClass();
        if (string == null) {
            InterceptorBean interceptorBean = (InterceptorBean)descriptorBean.getParentBean();
            string = interceptorBean.getInterceptorClass();
        }
        return AnnotationValidatorHelper.getClass(string, classLoader);
    }

    @Override
    protected Method guessMethodFromSignature(List<Method> list) {
        for (Method method : list) {
            Class<?>[] classArray = method.getParameterTypes();
            if (method.getReturnType() != Void.TYPE || classArray.length != 1 || !InvocationContext.class.isAssignableFrom(classArray[0])) continue;
            return method;
        }
        return null;
    }

    @Override
    protected void checkParameters(Method method, ErrorCollectionException errorCollectionException) {
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray.length == 1 && InvocationContext.class.isAssignableFrom(classArray[0])) {
            return;
        }
        errorCollectionException.add((Throwable)this.error(method, "it should take an InvocationContext object as parameter in the case of EJB interceptor"));
    }
}

