/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator.lifecyclecallback;

import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.validator.AnnotationValidator;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.ClientValidator;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.EJBValidator;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.InterceptorValidator;
import weblogic.j2ee.dd.xml.validator.lifecyclecallback.J2EEValidator;
import weblogic.j2ee.descriptor.ApplicationClientBean;
import weblogic.j2ee.descriptor.EntityBeanBean;
import weblogic.j2ee.descriptor.InterceptorBean;
import weblogic.j2ee.descriptor.J2eeEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDrivenBeanBean;
import weblogic.j2ee.descriptor.SessionBeanBean;

public class LifecycleCallbackValidatorFactory {
    public static AnnotationValidator getValidator(DescriptorBean descriptorBean) {
        if (!(descriptorBean instanceof LifecycleCallbackBean)) {
            return null;
        }
        DescriptorBean descriptorBean2 = descriptorBean.getParentBean();
        if (descriptorBean2 instanceof ApplicationClientBean) {
            return Holder.CLIENT_VALIDATOR;
        }
        if (descriptorBean2 instanceof InterceptorBean) {
            return Holder.INTERCEPTOR_VALIDATOR;
        }
        if (descriptorBean2 instanceof SessionBeanBean || descriptorBean2 instanceof MessageDrivenBeanBean || descriptorBean2 instanceof EntityBeanBean) {
            return Holder.EJB_VALIDATOR;
        }
        if (descriptorBean2 instanceof J2eeEnvironmentBean) {
            return Holder.J2EE_VALIDATOR;
        }
        return null;
    }

    static class Holder {
        private static AnnotationValidator CLIENT_VALIDATOR = new ClientValidator();
        private static AnnotationValidator J2EE_VALIDATOR = new J2EEValidator();
        private static AnnotationValidator EJB_VALIDATOR = new EJBValidator();
        private static AnnotationValidator INTERCEPTOR_VALIDATOR = new InterceptorValidator();

        Holder() {
        }
    }
}

