/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.dd.xml.validator.listener;

import java.util.EventListener;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionListener;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.validator.AnnotationValidator;
import weblogic.j2ee.descriptor.ListenerBean;
import weblogic.j2ee.descriptor.WebAppBean;
import weblogic.management.DeploymentException;
import weblogic.servlet.WebLogicServletContextListener;
import weblogic.utils.ErrorCollectionException;

public class ListenerBeanValidator
implements AnnotationValidator {
    private static final Class[] LISTENER_CLASSES = new Class[]{ServletContextListener.class, ServletContextAttributeListener.class, ServletRequestListener.class, ServletRequestAttributeListener.class, HttpSessionListener.class, HttpSessionBindingListener.class, HttpSessionAttributeListener.class, HttpSessionActivationListener.class, WebLogicServletContextListener.class};

    public void validate(DescriptorBean descriptorBean, ClassLoader classLoader) throws ErrorCollectionException {
        if (!(descriptorBean instanceof WebAppBean)) {
            return;
        }
        ListenerBean[] listenerBeanArray = ((WebAppBean)descriptorBean).getListeners();
        if (listenerBeanArray == null || listenerBeanArray.length < 1) {
            return;
        }
        ErrorCollectionException errorCollectionException = new ErrorCollectionException();
        for (ListenerBean listenerBean : listenerBeanArray) {
            try {
                Class<?> clazz = classLoader.loadClass(listenerBean.getListenerClass());
                if (ListenerBeanValidator.isListener(clazz)) continue;
                errorCollectionException.add((Throwable)((Object)new DeploymentException("User defined class " + listenerBean.getListenerClass() + " is not a Listener, as it" + " does not implement the correct interface(s).")));
            }
            catch (ClassNotFoundException classNotFoundException) {
                errorCollectionException.add((Throwable)classNotFoundException);
            }
        }
        if (errorCollectionException.size() != 0) {
            throw errorCollectionException;
        }
    }

    private static boolean isListener(Class clazz) {
        if (!EventListener.class.isAssignableFrom(clazz)) {
            return false;
        }
        for (Class clazz2 : LISTENER_CLASSES) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }
}

