/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.descriptor.wl;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.config.BasicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.AnnotatedFieldBean;
import weblogic.j2ee.descriptor.wl.AnnotationInstanceBean;
import weblogic.j2ee.descriptor.wl.AnnotationInstanceBeanDConfig;

public class AnnotatedFieldBeanDConfig
extends BasicDConfigBean {
    private static final boolean debug = Debug.isDebug("config");
    private AnnotatedFieldBean beanTreeNode;
    private List annotationsDConfig = new ArrayList();

    public AnnotatedFieldBeanDConfig(DDBean dDBean, DescriptorBean descriptorBean, DConfigBean dConfigBean) throws ConfigurationException {
        super(dDBean);
        this.beanTreeNode = (AnnotatedFieldBean)descriptorBean;
        this.beanTree = descriptorBean;
        this.parent = (BasicDConfigBean)dConfigBean;
        this.initXpaths();
        this.customInit();
    }

    private void initXpaths() throws ConfigurationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getParentXpath(this.applyNamespace("annotation/annotation-class-name")));
        this.xpaths = arrayList.toArray(new String[0]);
    }

    private void customInit() throws ConfigurationException {
        DDBean[] dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("instance-type"));
        if (dDBeanArray != null && dDBeanArray.length > 0) {
            this.beanTreeNode.setInstanceType(dDBeanArray[0].getText());
            if (debug) {
                Debug.say("inited with InstanceType with " + dDBeanArray[0].getText());
            }
        }
    }

    public boolean hasCustomInit() {
        return true;
    }

    public DConfigBean createDConfigBean(DDBean dDBean, DConfigBean dConfigBean) throws ConfigurationException {
        if (debug) {
            Debug.say("Creating child DCB for <" + dDBean.getXpath() + ">");
        }
        boolean bl = false;
        BasicDConfigBean basicDConfigBean = null;
        String string = dDBean.getXpath();
        int n = 0;
        if (this.lastElementOf(this.xpaths[n++]).equals(this.lastElementOf(string))) {
            AnnotationInstanceBean annotationInstanceBean = null;
            AnnotationInstanceBean[] annotationInstanceBeanArray = this.beanTreeNode.getAnnotations();
            if (annotationInstanceBeanArray == null) {
                this.beanTreeNode.createAnnotation();
                annotationInstanceBeanArray = this.beanTreeNode.getAnnotations();
            }
            String string2 = this.lastElementOf(this.applyNamespace("annotation/annotation-class-name"));
            this.setKeyName(string2);
            String string3 = this.getDDKey(dDBean, string2);
            if (debug) {
                Debug.say("Using keyName: " + string2 + ", key: " + string3);
            }
            for (int i = 0; i < annotationInstanceBeanArray.length && !this.isMatch((DescriptorBean)(annotationInstanceBean = annotationInstanceBeanArray[i]), dDBean, string3); ++i) {
                annotationInstanceBean = null;
            }
            if (annotationInstanceBean == null) {
                if (debug) {
                    Debug.say("creating new dcb element");
                }
                annotationInstanceBean = this.beanTreeNode.createAnnotation();
                bl = true;
            }
            basicDConfigBean = new AnnotationInstanceBeanDConfig(dDBean, (DescriptorBean)annotationInstanceBean, dConfigBean);
            ((AnnotationInstanceBeanDConfig)basicDConfigBean).initKeyPropertyValue(string3);
            if (!basicDConfigBean.hasCustomInit()) {
                basicDConfigBean.setParentPropertyName("Annotations");
            }
            if (debug) {
                Debug.say("dcb dump: " + basicDConfigBean.toString());
            }
            this.annotationsDConfig.add(basicDConfigBean);
        } else if (debug) {
            Debug.say("Ignoring " + dDBean.getXpath());
            for (int i = 0; i < this.xpaths.length; ++i) {
                Debug.say("xpaths[" + i + "]=" + this.xpaths[i]);
            }
        }
        if (basicDConfigBean != null) {
            this.addDConfigBean(basicDConfigBean);
            if (bl) {
                basicDConfigBean.setModified(true);
                BasicDConfigBean basicDConfigBean2 = basicDConfigBean;
                while (basicDConfigBean2.getParent() != null) {
                    basicDConfigBean2 = basicDConfigBean2.getParent();
                }
                ((BasicDConfigBeanRoot)basicDConfigBean2).registerAsListener(basicDConfigBean.getDescriptorBean());
            }
            this.processDCB(basicDConfigBean, bl);
        }
        return basicDConfigBean;
    }

    public String keyPropertyValue() {
        return this.getFieldName();
    }

    public void initKeyPropertyValue(String string) {
        this.setFieldName(string);
    }

    public String getDCBProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FieldName: ");
        stringBuffer.append(this.beanTreeNode.getFieldName());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void validate() throws ConfigurationException {
    }

    public String getFieldName() {
        return this.beanTreeNode.getFieldName();
    }

    public void setFieldName(String string) {
        this.beanTreeNode.setFieldName(string);
        this.firePropertyChange(new PropertyChangeEvent(this, "FieldName", null, null));
        this.setModified(true);
    }

    public String getInstanceType() {
        return this.beanTreeNode.getInstanceType();
    }

    public void setInstanceType(String string) {
        this.beanTreeNode.setInstanceType(string);
        this.firePropertyChange(new PropertyChangeEvent(this, "InstanceType", null, null));
        this.setModified(true);
    }

    public AnnotationInstanceBeanDConfig[] getAnnotations() {
        return this.annotationsDConfig.toArray(new AnnotationInstanceBeanDConfig[0]);
    }

    void addAnnotationInstanceBean(AnnotationInstanceBeanDConfig annotationInstanceBeanDConfig) {
        this.addToList(this.annotationsDConfig, "AnnotationInstanceBean", annotationInstanceBeanDConfig);
    }

    void removeAnnotationInstanceBean(AnnotationInstanceBeanDConfig annotationInstanceBeanDConfig) {
        this.removeFromList(this.annotationsDConfig, "AnnotationInstanceBean", annotationInstanceBeanDConfig);
    }
}

