/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.descriptor.wl;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.config.BasicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.EnumRefBean;
import weblogic.j2ee.descriptor.wl.EnumRefBeanDConfig;
import weblogic.j2ee.descriptor.wl.MemberDefinitionBean;
import weblogic.j2ee.descriptor.wl.SimpleTypeDefinitionBean;
import weblogic.j2ee.descriptor.wl.SimpleTypeDefinitionBeanDConfig;

public class MemberDefinitionBeanDConfig
extends BasicDConfigBean {
    private static final boolean debug = Debug.isDebug("config");
    private MemberDefinitionBean beanTreeNode;
    private EnumRefBeanDConfig enumRefDConfig;
    private SimpleTypeDefinitionBeanDConfig simpleTypeDefinitionDConfig;

    public MemberDefinitionBeanDConfig(DDBean dDBean, DescriptorBean descriptorBean, DConfigBean dConfigBean) throws ConfigurationException {
        super(dDBean);
        this.beanTreeNode = (MemberDefinitionBean)descriptorBean;
        this.beanTree = descriptorBean;
        this.parent = (BasicDConfigBean)dConfigBean;
        this.initXpaths();
        this.customInit();
    }

    private void initXpaths() throws ConfigurationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.applyNamespace("enum-ref"));
        arrayList.add(this.applyNamespace("simple-type-definition"));
        this.xpaths = arrayList.toArray(new String[0]);
    }

    private void customInit() throws ConfigurationException {
        DDBean[] dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("is-array"));
        if (dDBeanArray != null && dDBeanArray.length > 0) {
            this.beanTreeNode.setIsArray(Boolean.valueOf(dDBeanArray[0].getText()).booleanValue());
            if (debug) {
                Debug.say("inited with IsArray with " + dDBeanArray[0].getText());
            }
        }
        if ((dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("is-required"))) != null && dDBeanArray.length > 0) {
            this.beanTreeNode.setIsRequired(Boolean.valueOf(dDBeanArray[0].getText()).booleanValue());
            if (debug) {
                Debug.say("inited with IsRequired with " + dDBeanArray[0].getText());
            }
        }
        if ((dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("annotation-ref"))) != null && dDBeanArray.length > 0) {
            this.beanTreeNode.setAnnotationRef(dDBeanArray[0].getText());
            if (debug) {
                Debug.say("inited with AnnotationRef with " + dDBeanArray[0].getText());
            }
        }
    }

    public boolean hasCustomInit() {
        return true;
    }

    public DConfigBean createDConfigBean(DDBean dDBean, DConfigBean dConfigBean) throws ConfigurationException {
        if (debug) {
            Debug.say("Creating child DCB for <" + dDBean.getXpath() + ">");
        }
        boolean bl = false;
        BasicDConfigBean basicDConfigBean = null;
        String string = dDBean.getXpath();
        int n = 0;
        if (this.lastElementOf(this.xpaths[n++]).equals(this.lastElementOf(string))) {
            EnumRefBean enumRefBean = this.beanTreeNode.getEnumRef();
            if (enumRefBean == null) {
                if (debug) {
                    Debug.say("creating new dcb element");
                }
                enumRefBean = this.beanTreeNode.createEnumRef();
                bl = true;
            }
            this.enumRefDConfig = new EnumRefBeanDConfig(dDBean, (DescriptorBean)enumRefBean, dConfigBean);
            basicDConfigBean = this.enumRefDConfig;
            if (!basicDConfigBean.hasCustomInit()) {
                basicDConfigBean.setParentPropertyName("EnumRef");
            }
        } else if (this.lastElementOf(this.xpaths[n++]).equals(this.lastElementOf(string))) {
            SimpleTypeDefinitionBean simpleTypeDefinitionBean = this.beanTreeNode.getSimpleTypeDefinition();
            if (simpleTypeDefinitionBean == null) {
                if (debug) {
                    Debug.say("creating new dcb element");
                }
                simpleTypeDefinitionBean = this.beanTreeNode.createSimpleTypeDefinition();
                bl = true;
            }
            this.simpleTypeDefinitionDConfig = new SimpleTypeDefinitionBeanDConfig(dDBean, (DescriptorBean)simpleTypeDefinitionBean, dConfigBean);
            basicDConfigBean = this.simpleTypeDefinitionDConfig;
            if (!basicDConfigBean.hasCustomInit()) {
                basicDConfigBean.setParentPropertyName("SimpleTypeDefinition");
            }
        } else if (debug) {
            Debug.say("Ignoring " + dDBean.getXpath());
            for (int i = 0; i < this.xpaths.length; ++i) {
                Debug.say("xpaths[" + i + "]=" + this.xpaths[i]);
            }
        }
        if (basicDConfigBean != null) {
            this.addDConfigBean(basicDConfigBean);
            if (bl) {
                basicDConfigBean.setModified(true);
                BasicDConfigBean basicDConfigBean2 = basicDConfigBean;
                while (basicDConfigBean2.getParent() != null) {
                    basicDConfigBean2 = basicDConfigBean2.getParent();
                }
                ((BasicDConfigBeanRoot)basicDConfigBean2).registerAsListener(basicDConfigBean.getDescriptorBean());
            }
            this.processDCB(basicDConfigBean, bl);
        }
        return basicDConfigBean;
    }

    public String keyPropertyValue() {
        return this.getMemberName();
    }

    public void initKeyPropertyValue(String string) {
        this.setMemberName(string);
    }

    public String getDCBProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("MemberName: ");
        stringBuffer.append(this.beanTreeNode.getMemberName());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public void validate() throws ConfigurationException {
    }

    public String getMemberName() {
        return this.beanTreeNode.getMemberName();
    }

    public void setMemberName(String string) {
        this.beanTreeNode.setMemberName(string);
        this.firePropertyChange(new PropertyChangeEvent(this, "MemberName", null, null));
        this.setModified(true);
    }

    public boolean getIsArray() {
        return this.beanTreeNode.getIsArray();
    }

    public void setIsArray(boolean bl) {
        this.beanTreeNode.setIsArray(bl);
        this.firePropertyChange(new PropertyChangeEvent(this, "IsArray", null, null));
        this.setModified(true);
    }

    public boolean getIsRequired() {
        return this.beanTreeNode.getIsRequired();
    }

    public void setIsRequired(boolean bl) {
        this.beanTreeNode.setIsRequired(bl);
        this.firePropertyChange(new PropertyChangeEvent(this, "IsRequired", null, null));
        this.setModified(true);
    }

    public String getAnnotationRef() {
        return this.beanTreeNode.getAnnotationRef();
    }

    public void setAnnotationRef(String string) {
        this.beanTreeNode.setAnnotationRef(string);
        this.firePropertyChange(new PropertyChangeEvent(this, "AnnotationRef", null, null));
        this.setModified(true);
    }

    public EnumRefBeanDConfig getEnumRef() {
        return this.enumRefDConfig;
    }

    public void setEnumRef(EnumRefBeanDConfig enumRefBeanDConfig) {
        this.enumRefDConfig = enumRefBeanDConfig;
        this.firePropertyChange(new PropertyChangeEvent(this, "EnumRef", null, null));
        this.setModified(true);
    }

    public SimpleTypeDefinitionBeanDConfig getSimpleTypeDefinition() {
        return this.simpleTypeDefinitionDConfig;
    }

    public void setSimpleTypeDefinition(SimpleTypeDefinitionBeanDConfig simpleTypeDefinitionBeanDConfig) {
        this.simpleTypeDefinitionDConfig = simpleTypeDefinitionBeanDConfig;
        this.firePropertyChange(new PropertyChangeEvent(this, "SimpleTypeDefinition", null, null));
        this.setModified(true);
    }
}

