/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.descriptor.wl;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import weblogic.deploy.api.internal.utils.Debug;
import weblogic.deploy.api.spi.config.BasicDConfigBean;
import weblogic.deploy.api.spi.config.BasicDConfigBeanRoot;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.MemberConstraintBean;
import weblogic.j2ee.descriptor.wl.MemberConstraintBeanDConfig;
import weblogic.j2ee.descriptor.wl.SimpleTypeDefinitionBean;

public class SimpleTypeDefinitionBeanDConfig
extends BasicDConfigBean {
    private static final boolean debug = Debug.isDebug("config");
    private SimpleTypeDefinitionBean beanTreeNode;
    private MemberConstraintBeanDConfig constraintDConfig;

    public SimpleTypeDefinitionBeanDConfig(DDBean dDBean, DescriptorBean descriptorBean, DConfigBean dConfigBean) throws ConfigurationException {
        super(dDBean);
        this.beanTreeNode = (SimpleTypeDefinitionBean)descriptorBean;
        this.beanTree = descriptorBean;
        this.parent = (BasicDConfigBean)dConfigBean;
        this.initXpaths();
        this.customInit();
    }

    private void initXpaths() throws ConfigurationException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.applyNamespace("constraint"));
        this.xpaths = arrayList.toArray(new String[0]);
    }

    private void customInit() throws ConfigurationException {
        DDBean[] dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("base-type"));
        if (dDBeanArray != null && dDBeanArray.length > 0) {
            this.beanTreeNode.setBaseType(dDBeanArray[0].getText());
            if (debug) {
                Debug.say("inited with BaseType with " + dDBeanArray[0].getText());
            }
        }
        if ((dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("requires-encryption"))) != null && dDBeanArray.length > 0) {
            this.beanTreeNode.setRequiresEncryption(Boolean.valueOf(dDBeanArray[0].getText()).booleanValue());
            if (debug) {
                Debug.say("inited with RequiresEncryption with " + dDBeanArray[0].getText());
            }
        }
        if ((dDBeanArray = this.getDDBean().getChildBean(this.applyNamespace("default-value"))) != null && dDBeanArray.length > 0) {
            String[] stringArray = new String[dDBeanArray.length];
            for (int i = 0; i < dDBeanArray.length; ++i) {
                stringArray[i] = dDBeanArray[i].getText();
            }
            this.beanTreeNode.setDefaultValue(stringArray);
        }
    }

    public boolean hasCustomInit() {
        return true;
    }

    public DConfigBean createDConfigBean(DDBean dDBean, DConfigBean dConfigBean) throws ConfigurationException {
        if (debug) {
            Debug.say("Creating child DCB for <" + dDBean.getXpath() + ">");
        }
        boolean bl = false;
        BasicDConfigBean basicDConfigBean = null;
        String string = dDBean.getXpath();
        int n = 0;
        if (this.lastElementOf(this.xpaths[n++]).equals(this.lastElementOf(string))) {
            MemberConstraintBean memberConstraintBean = this.beanTreeNode.getConstraint();
            if (memberConstraintBean == null) {
                if (debug) {
                    Debug.say("creating new dcb element");
                }
                memberConstraintBean = this.beanTreeNode.createConstraint();
                bl = true;
            }
            this.constraintDConfig = new MemberConstraintBeanDConfig(dDBean, (DescriptorBean)memberConstraintBean, dConfigBean);
            basicDConfigBean = this.constraintDConfig;
            if (!basicDConfigBean.hasCustomInit()) {
                basicDConfigBean.setParentPropertyName("Constraint");
            }
        } else if (debug) {
            Debug.say("Ignoring " + dDBean.getXpath());
            for (int i = 0; i < this.xpaths.length; ++i) {
                Debug.say("xpaths[" + i + "]=" + this.xpaths[i]);
            }
        }
        if (basicDConfigBean != null) {
            this.addDConfigBean(basicDConfigBean);
            if (bl) {
                basicDConfigBean.setModified(true);
                BasicDConfigBean basicDConfigBean2 = basicDConfigBean;
                while (basicDConfigBean2.getParent() != null) {
                    basicDConfigBean2 = basicDConfigBean2.getParent();
                }
                ((BasicDConfigBeanRoot)basicDConfigBean2).registerAsListener(basicDConfigBean.getDescriptorBean());
            }
            this.processDCB(basicDConfigBean, bl);
        }
        return basicDConfigBean;
    }

    public String keyPropertyValue() {
        return null;
    }

    public void initKeyPropertyValue(String string) {
    }

    public String getDCBProperties() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public void validate() throws ConfigurationException {
    }

    public String getBaseType() {
        return this.beanTreeNode.getBaseType();
    }

    public void setBaseType(String string) {
        this.beanTreeNode.setBaseType(string);
        this.firePropertyChange(new PropertyChangeEvent(this, "BaseType", null, null));
        this.setModified(true);
    }

    public MemberConstraintBeanDConfig getConstraint() {
        return this.constraintDConfig;
    }

    public void setConstraint(MemberConstraintBeanDConfig memberConstraintBeanDConfig) {
        this.constraintDConfig = memberConstraintBeanDConfig;
        this.firePropertyChange(new PropertyChangeEvent(this, "Constraint", null, null));
        this.setModified(true);
    }

    public boolean getRequiresEncryption() {
        return this.beanTreeNode.getRequiresEncryption();
    }

    public void setRequiresEncryption(boolean bl) {
        this.beanTreeNode.setRequiresEncryption(bl);
        this.firePropertyChange(new PropertyChangeEvent(this, "RequiresEncryption", null, null));
        this.setModified(true);
    }

    public String[] getDefaultValue() {
        return this.beanTreeNode.getDefaultValue();
    }

    public void setDefaultValue(String[] stringArray) {
        this.beanTreeNode.setDefaultValue(stringArray);
        this.firePropertyChange(new PropertyChangeEvent(this, "DefaultValue", null, null));
        this.setModified(true);
    }
}

