/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.descriptors;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import weblogic.management.ManagementException;
import weblogic.management.descriptors.ApplicationDescriptorMBean;
import weblogic.management.descriptors.DescriptorValidationException;
import weblogic.management.descriptors.Encoding;
import weblogic.management.descriptors.TopLevelDescriptorMBean;
import weblogic.management.descriptors.XMLDeclarationMBean;
import weblogic.management.descriptors.XMLElementMBeanDelegate;
import weblogic.management.descriptors.application.J2EEApplicationDescriptorMBean;
import weblogic.management.descriptors.application.weblogic.WeblogicApplicationMBean;
import weblogic.utils.Debug;
import weblogic.utils.io.XMLWriter;
import weblogic.utils.jars.RandomAccessJarFile;

public final class ApplicationDescriptorMBeanImpl
extends XMLElementMBeanDelegate
implements ApplicationDescriptorMBean,
TopLevelDescriptorMBean {
    private static final long serialVersionUID = 473061217792399747L;
    private String persistentDestination = null;
    private J2EEApplicationDescriptorMBean j2eeAppDescr;
    private WeblogicApplicationMBean weblogicAppDescr;

    public ApplicationDescriptorMBeanImpl(String string) {
        super(string);
    }

    public ApplicationDescriptorMBeanImpl() {
    }

    public void setJ2EEApplicationDescriptor(J2EEApplicationDescriptorMBean j2EEApplicationDescriptorMBean) {
        this.j2eeAppDescr = j2EEApplicationDescriptorMBean;
    }

    public J2EEApplicationDescriptorMBean getJ2EEApplicationDescriptor() {
        return this.j2eeAppDescr;
    }

    public void unregister() throws ManagementException {
        super.unregister();
        if (this.j2eeAppDescr != null) {
            this.j2eeAppDescr.unregister();
        }
        if (this.weblogicAppDescr != null) {
            this.weblogicAppDescr.unregister();
        }
    }

    public void toXML(XMLWriter xMLWriter) {
        if (this.j2eeAppDescr != null) {
            this.j2eeAppDescr.toXML(xMLWriter);
        }
    }

    public String toXML(int n) {
        return this.toXML();
    }

    public String toXML() {
        StringWriter stringWriter = new StringWriter();
        this.toXML(new XMLWriter((Writer)stringWriter));
        return stringWriter.toString();
    }

    public void validate() throws DescriptorValidationException {
    }

    public void usePersistenceDestination(String string) {
        this.persistentDestination = string;
    }

    public void persist() throws IOException {
        this.persist(null);
    }

    public void persist(Properties properties) throws IOException {
        Object object;
        Debug.assertion((this.persistentDestination != null ? 1 : 0) != 0, (String)("must call usePersistenceDestination on " + this + " before calling persist"));
        File file = new File(this.persistentDestination);
        OutputStream outputStream = null;
        RandomAccessJarFile randomAccessJarFile = null;
        if (this.j2eeAppDescr != null) {
            if (file.isDirectory()) {
                object = new File(file, "META-INF/application.xml");
                outputStream = new FileOutputStream((File)object);
            } else {
                object = ".";
                randomAccessJarFile = new RandomAccessJarFile(new File((String)object), file);
                outputStream = randomAccessJarFile.writeEntry("META-INF/application.xml", true);
            }
            object = this.getXMLWriter(this.j2eeAppDescr, outputStream);
            this.toXML((XMLWriter)object);
            object.close();
        }
        if (this.weblogicAppDescr != null) {
            if (file.isDirectory()) {
                object = new File(file, "META-INF/weblogic-application.xml");
                outputStream = new FileOutputStream((File)object);
            } else {
                object = ".";
                randomAccessJarFile = new RandomAccessJarFile(new File((String)object), file);
                outputStream = randomAccessJarFile.writeEntry("META-INF/weblogic-application.xml", true);
            }
            object = this.getXMLWriter(this.weblogicAppDescr, outputStream);
            object.println(this.weblogicAppDescr.toXML(2));
            object.close();
        }
        if (properties != null) {
            if (file.isDirectory()) {
                object = new File(file.getPath() + File.separator + "META-INF", "_wl_dynamic_change_list.properties");
                outputStream = new FileOutputStream((File)object);
            } else {
                outputStream = randomAccessJarFile.writeEntry("META-INF/_wl_dynamic_change_list.properties", true);
            }
            properties.store(outputStream, "Dynamic DD change list");
            outputStream.close();
        }
        if (randomAccessJarFile != null) {
            randomAccessJarFile.close();
        }
    }

    private XMLWriter getXMLWriter(XMLDeclarationMBean xMLDeclarationMBean, OutputStream outputStream) throws IOException {
        String string = xMLDeclarationMBean.getEncoding();
        XMLWriter xMLWriter = null;
        if (string != null) {
            String string2 = Encoding.getIANA2JavaMapping(string);
            xMLWriter = new XMLWriter(outputStream, string2);
        } else {
            xMLWriter = new XMLWriter(outputStream);
        }
        return xMLWriter;
    }

    public void setWeblogicApplicationDescriptor(WeblogicApplicationMBean weblogicApplicationMBean) {
        this.weblogicAppDescr = weblogicApplicationMBean;
    }

    public WeblogicApplicationMBean getWeblogicApplicationDescriptor() {
        return this.weblogicAppDescr;
    }
}

