/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.injection;

import com.oracle.pitchfork.interfaces.MetadataParseException;
import com.oracle.pitchfork.interfaces.inject.ComponentContributor;
import com.oracle.pitchfork.interfaces.inject.EnricherI;
import com.oracle.pitchfork.interfaces.inject.InjectionI;
import com.oracle.pitchfork.interfaces.inject.Jsr250MetadataI;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import weblogic.deployment.descriptors.EnvironmentEntry;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.ejb.container.utils.ClassUtils;
import weblogic.ejb.container.utils.MethodUtils;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.injection.PitchforkContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseComponentContributor
implements ComponentContributor {
    protected static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;
    protected ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    protected PitchforkContext pitchforkContext;

    public BaseComponentContributor(PitchforkContext pitchforkContext) {
        this.pitchforkContext = pitchforkContext;
    }

    public Jsr250MetadataI buildJsr250MetaData(EnricherI enricherI, String string, String string2) {
        Class clazz = null;
        if (string2 != null) {
            clazz = this.loadClass(string2, this.classLoader);
        }
        return this.newJsr250Metadata(string, clazz, enricherI.getDeploymentUnitMetadata());
    }

    protected void buildInjectionMetadata(Jsr250MetadataI jsr250MetadataI, J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        this.debug("Convert environmentGroupBean to jsr250Metadata for : " + j2eeClientEnvironmentBean);
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getResourceEnvRefs()) {
            this.addResourceEnvRef(resourceEnvRefBean, jsr250MetadataI);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getEnvEntries()) {
            this.addEnvEntry((EnvEntryBean)resourceEnvRefBean, jsr250MetadataI);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getEjbRefs()) {
            this.addEjbRef((EjbRefBean)resourceEnvRefBean, jsr250MetadataI);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getServiceRefs()) {
            this.addServiceRef((ServiceRefBean)resourceEnvRefBean, jsr250MetadataI);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getResourceRefs()) {
            this.addResourceRef((ResourceRefBean)resourceEnvRefBean, jsr250MetadataI);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getMessageDestinationRefs()) {
            this.addMessageDestinationRef((MessageDestinationRefBean)resourceEnvRefBean, jsr250MetadataI);
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getPersistenceUnitRefs()) {
            this.addPersistenceUnitRef((PersistenceUnitRefBean)resourceEnvRefBean, jsr250MetadataI);
        }
    }

    protected Set getInjectableTargetClasses(J2eeClientEnvironmentBean j2eeClientEnvironmentBean) {
        HashSet hashSet = new HashSet();
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getResourceEnvRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getEnvEntries()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getEjbRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getServiceRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getResourceRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getMessageDestinationRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        for (ResourceEnvRefBean resourceEnvRefBean : j2eeClientEnvironmentBean.getPersistenceUnitRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(resourceEnvRefBean.getInjectionTargets()));
        }
        return hashSet;
    }

    protected Set getInjectableTargetClasses(InjectionTargetBean[] injectionTargetBeanArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (InjectionTargetBean injectionTargetBean : injectionTargetBeanArray) {
            hashSet.add(injectionTargetBean.getInjectionTargetClass());
        }
        return hashSet;
    }

    protected void addEnvEntry(EnvEntryBean envEntryBean, Jsr250MetadataI jsr250MetadataI) {
        String string = envEntryBean.getEnvEntryName();
        String string2 = envEntryBean.getEnvEntryValue();
        String string3 = envEntryBean.getEnvEntryType();
        if (string2 == null) {
            return;
        }
        InjectionTargetBean[] injectionTargetBeanArray = envEntryBean.getInjectionTargets();
        Object object = null;
        EnvironmentEntry environmentEntry = new EnvironmentEntry();
        environmentEntry.setValue(string3, string2);
        try {
            object = environmentEntry.getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string3, string);
        for (InjectionI injectionI : list) {
            injectionI.setValue(object);
        }
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addEjbRef(EjbRefBean ejbRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = ejbRefBean.getEjbRefName();
        String string2 = ejbRefBean.getEjbRefType();
        String string3 = ejbRefBean.getHome();
        if (string3 == null) {
            string3 = ejbRefBean.getRemote();
        }
        InjectionTargetBean[] injectionTargetBeanArray = ejbRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string3, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addLocalEjbRef(EjbLocalRefBean ejbLocalRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = ejbLocalRefBean.getEjbRefName();
        String string2 = ejbLocalRefBean.getEjbRefType();
        String string3 = ejbLocalRefBean.getLocalHome();
        if (string3 == null) {
            string3 = ejbLocalRefBean.getLocal();
        }
        InjectionTargetBean[] injectionTargetBeanArray = ejbLocalRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string3, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addServiceRef(ServiceRefBean serviceRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = serviceRefBean.getServiceRefName();
        String string2 = serviceRefBean.getServiceInterface();
        String string3 = serviceRefBean.getServiceRefType();
        InjectionTargetBean[] injectionTargetBeanArray = serviceRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string3, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addResourceRef(ResourceRefBean resourceRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = resourceRefBean.getResRefName();
        String string2 = resourceRefBean.getResType();
        InjectionTargetBean[] injectionTargetBeanArray = resourceRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string2, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addResourceEnvRef(ResourceEnvRefBean resourceEnvRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = resourceEnvRefBean.getResourceEnvRefName();
        String string2 = resourceEnvRefBean.getResourceEnvRefType();
        InjectionTargetBean[] injectionTargetBeanArray = resourceEnvRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string2, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addMessageDestinationRef(MessageDestinationRefBean messageDestinationRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = messageDestinationRefBean.getMessageDestinationRefName();
        String string2 = messageDestinationRefBean.getMessageDestinationType();
        InjectionTargetBean[] injectionTargetBeanArray = messageDestinationRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string2, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addPersistenceUnitRef(PersistenceUnitRefBean persistenceUnitRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = persistenceUnitRefBean.getPersistenceUnitRefName();
        InjectionTargetBean[] injectionTargetBeanArray = persistenceUnitRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, EntityManagerFactory.class.getName(), string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected List<InjectionI> parseInjectionTarget(Jsr250MetadataI jsr250MetadataI, InjectionTargetBean[] injectionTargetBeanArray, String string, String string2) {
        ArrayList<InjectionI> arrayList = new ArrayList<InjectionI>();
        if (injectionTargetBeanArray.length == 0) {
            return arrayList;
        }
        Class clazz = this.loadClass(string, this.classLoader);
        for (InjectionTargetBean injectionTargetBean : injectionTargetBeanArray) {
            Class clazz2;
            String string3 = injectionTargetBean.getInjectionTargetClass();
            String string4 = injectionTargetBean.getInjectionTargetName();
            Class clazz3 = this.loadClass(string3, this.classLoader);
            if (!clazz3.isAssignableFrom(clazz2 = jsr250MetadataI.getComponentClass())) {
                this.debug("Skipping injection for: targetClassName " + string3 + "; componentName " + jsr250MetadataI.getComponentName());
                continue;
            }
            Class clazz4 = ClassUtils.getPrimitiveClass(clazz);
            if (!(null == clazz4 ? !this.findTargetMethodOrField(arrayList, clazz3, string4, clazz, string2) : !this.findTargetMethodOrField(arrayList, clazz3, string4, clazz, string2) && !this.findTargetMethodOrField(arrayList, clazz3, string4, clazz4, string2))) continue;
            throw new IllegalArgumentException("No setter method or field named \"" + string4 + "\" found in inject target class " + clazz3.getName());
        }
        return arrayList;
    }

    private boolean findTargetMethodOrField(List<InjectionI> list, Class clazz, String string, Class clazz2, String string2) {
        if (list == null) {
            return false;
        }
        try {
            Method method = clazz.getMethod(MethodUtils.setMethodName(string), clazz2);
            InjectionI injectionI = this.pitchforkContext.getPitchforkUtils().createMethodInjection(method, string2, clazz2);
            this.debug("+++++adding method injection " + injectionI + " for " + string);
            list.add(injectionI);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Field field = clazz.getDeclaredField(string);
                InjectionI injectionI = this.pitchforkContext.getPitchforkUtils().createFieldInjection(field, string2, clazz2);
                this.debug("+++++adding field injection " + injectionI + " for " + string);
                list.add(injectionI);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return false;
            }
        }
        return true;
    }

    protected void insertOrOverwriteInjectionStrategy(List<InjectionI<?>> list, List<InjectionI> list2) {
        for (InjectionI injectionI : list2) {
            Member member = injectionI.getMember();
            Class clazz = injectionI.getType();
            boolean bl = false;
            for (InjectionI<?> injectionI2 : list) {
                Member member2 = injectionI2.getMember();
                Class clazz2 = injectionI2.getType();
                if (injectionI2.getName().equals(injectionI.getName()) && member2.equals(member)) {
                    list.remove(injectionI2);
                    break;
                }
                if (!clazz2.getName().equals(clazz.getName()) || !member2.getName().equals(member.getName())) continue;
                if (!Modifier.isPrivate(member2.getModifiers()) && member2.getDeclaringClass().isAssignableFrom(member.getDeclaringClass())) {
                    list.remove(injectionI2);
                    break;
                }
                if (Modifier.isPrivate(member.getModifiers()) || !member.getDeclaringClass().isAssignableFrom(member2.getDeclaringClass())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            list.add(injectionI);
        }
    }

    protected Class loadClass(String string, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MetadataParseException("Can't find class:" + string, (Throwable)classNotFoundException);
        }
    }

    protected Class forName(String string, ClassLoader classLoader) {
        return this.pitchforkContext.getPitchforkUtils().forName(string, classLoader);
    }

    protected void debug(String string) {
        if (debugLogger.isDebugEnabled()) {
            debugLogger.debug("[BaseComponentContributor] " + string);
        }
    }
}

