/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.injection;

import com.oracle.pitchfork.interfaces.MetadataParseException;
import com.oracle.pitchfork.interfaces.PitchforkUtils;
import com.oracle.pitchfork.interfaces.inject.EnricherI;
import com.oracle.pitchfork.interfaces.inject.InjectionI;
import com.oracle.pitchfork.interfaces.inject.Jsr250MetadataI;
import com.oracle.pitchfork.interfaces.inject.LifecycleEvent;
import com.oracle.pitchfork.interfaces.intercept.InterceptorMetadataI;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.j2ee.descriptor.EjbLocalRefBean;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2ee.descriptor.J2eeEnvironmentBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.PersistenceContextRefBean;
import weblogic.j2ee.extensions.ExtensionManager;
import weblogic.j2ee.extensions.InjectionExtension;
import weblogic.j2ee.injection.BaseComponentContributor;
import weblogic.j2ee.injection.PitchforkContext;

public abstract class J2eeComponentContributor
extends BaseComponentContributor {
    protected static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;

    public J2eeComponentContributor(PitchforkContext pitchforkContext) {
        super(pitchforkContext);
    }

    public void contribute(EnricherI enricherI, String string, String string2, J2eeEnvironmentBean j2eeEnvironmentBean) {
        Jsr250MetadataI jsr250MetadataI = this.buildJsr250MetaData(enricherI, string, string2);
        this.buildInjectionMetadata(jsr250MetadataI, j2eeEnvironmentBean);
        this.contribute(jsr250MetadataI, j2eeEnvironmentBean);
        this.addLifecycleMethods(jsr250MetadataI, j2eeEnvironmentBean);
        enricherI.attach(jsr250MetadataI, false);
        this.updateMetadataUsingExtensions(jsr250MetadataI, string, string2);
    }

    private void updateMetadataUsingExtensions(Jsr250MetadataI jsr250MetadataI, String string, String string2) {
        ArrayList<InjectionI> arrayList = new ArrayList<InjectionI>();
        Iterator iterator = jsr250MetadataI.getInjections().iterator();
        while (iterator.hasNext()) {
            InjectionI injectionI = (InjectionI)iterator.next();
            String string3 = injectionI.getInfo().getName();
            String string4 = injectionI.getInfo().getType().getName();
            InjectionExtension injectionExtension = ExtensionManager.instance.getFirstMatchingExtension(string4, string3);
            if (injectionExtension == null) continue;
            string3 = string3 == null || string3.length() == 0 ? injectionExtension.getName(string4) : injectionExtension.getName(string4, string3);
            InjectionI injectionI2 = null;
            PitchforkUtils pitchforkUtils = this.pitchforkContext.getPitchforkUtils();
            Member member = injectionI.getMember();
            if (member instanceof Field) {
                injectionI2 = pitchforkUtils.createFieldInjection((Field)member, string3, injectionI.getInfo().getType());
            } else if (member instanceof Method) {
                injectionI2 = pitchforkUtils.createMethodInjection((Method)member, string3, injectionI.getInfo().getType());
            }
            if (injectionI2 == null) continue;
            arrayList.add(injectionI2);
            iterator.remove();
        }
        if (arrayList.size() > 0) {
            jsr250MetadataI.getInjections().addAll(arrayList);
        }
    }

    protected abstract void contribute(Jsr250MetadataI var1, J2eeEnvironmentBean var2);

    protected void addLifecycleMethods(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeEnvironmentBean.getPostConstructs()) {
            this.addLifecycleMethods(jsr250MetadataI, lifecycleCallbackBean, LifecycleEvent.POST_CONSTRUCT);
        }
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeEnvironmentBean.getPreDestroys()) {
            this.addLifecycleMethods(jsr250MetadataI, lifecycleCallbackBean, LifecycleEvent.PRE_DESTROY);
        }
    }

    protected void addLifecycleMethods(Jsr250MetadataI jsr250MetadataI, LifecycleCallbackBean lifecycleCallbackBean, LifecycleEvent lifecycleEvent) {
        Method method;
        Class clazz = this.loadClass(lifecycleCallbackBean.getLifecycleCallbackClass(), this.classLoader);
        if (!clazz.isAssignableFrom(jsr250MetadataI.getComponentClass())) {
            return;
        }
        if (jsr250MetadataI instanceof InterceptorMetadataI) {
            method = this.getDeclaredMethod(clazz, lifecycleCallbackBean.getLifecycleCallbackMethod(), InvocationContext.class);
            ((InterceptorMetadataI)jsr250MetadataI).registerLifecycleEventListenerMethod(lifecycleEvent, method);
        } else {
            method = this.getDeclaredMethod(clazz, lifecycleCallbackBean.getLifecycleCallbackMethod(), new Class[0]);
            jsr250MetadataI.registerLifecycleEventCallbackMethod(lifecycleEvent, method);
        }
        this.debug("+++++adding lifecycleMethod=" + method.getName() + " for annotation " + lifecycleEvent);
    }

    protected void buildInjectionMetadata(Jsr250MetadataI jsr250MetadataI, J2eeEnvironmentBean j2eeEnvironmentBean) {
        super.buildInjectionMetadata(jsr250MetadataI, (J2eeClientEnvironmentBean)j2eeEnvironmentBean);
        for (PersistenceContextRefBean persistenceContextRefBean : j2eeEnvironmentBean.getPersistenceContextRefs()) {
            this.addPersistenceContextRef(persistenceContextRefBean, jsr250MetadataI);
        }
        for (PersistenceContextRefBean persistenceContextRefBean : j2eeEnvironmentBean.getEjbLocalRefs()) {
            this.addLocalEjbRef((EjbLocalRefBean)persistenceContextRefBean, jsr250MetadataI);
        }
    }

    protected Set getInjectableTargetClasses(J2eeEnvironmentBean j2eeEnvironmentBean) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(super.getInjectableTargetClasses((J2eeClientEnvironmentBean)j2eeEnvironmentBean));
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeEnvironmentBean.getPostConstructs()) {
            hashSet.add(lifecycleCallbackBean.getLifecycleCallbackClass());
        }
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeEnvironmentBean.getPreDestroys()) {
            hashSet.add(lifecycleCallbackBean.getLifecycleCallbackClass());
        }
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeEnvironmentBean.getPersistenceContextRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(lifecycleCallbackBean.getInjectionTargets()));
        }
        for (LifecycleCallbackBean lifecycleCallbackBean : j2eeEnvironmentBean.getEjbLocalRefs()) {
            hashSet.addAll(this.getInjectableTargetClasses(lifecycleCallbackBean.getInjectionTargets()));
        }
        return hashSet;
    }

    protected void addPersistenceContextRef(PersistenceContextRefBean persistenceContextRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = persistenceContextRefBean.getPersistenceContextRefName();
        InjectionTargetBean[] injectionTargetBeanArray = persistenceContextRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, EntityManager.class.getName(), string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected void addLocalEjbRef(EjbLocalRefBean ejbLocalRefBean, Jsr250MetadataI jsr250MetadataI) {
        String string = ejbLocalRefBean.getEjbRefName();
        String string2 = ejbLocalRefBean.getEjbRefType();
        String string3 = ejbLocalRefBean.getLocalHome();
        if (string3 == null) {
            string3 = ejbLocalRefBean.getLocal();
        }
        InjectionTargetBean[] injectionTargetBeanArray = ejbLocalRefBean.getInjectionTargets();
        List<InjectionI> list = this.parseInjectionTarget(jsr250MetadataI, injectionTargetBeanArray, string3, string);
        this.insertOrOverwriteInjectionStrategy(jsr250MetadataI.getInjections(), list);
    }

    protected Method getDeclaredMethod(Class clazz, String string, Class ... classArray) {
        Method method = null;
        try {
            method = clazz.getDeclaredMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new MetadataParseException("Can't get the method " + string + " on class " + clazz.getName(), (Throwable)exception);
        }
        return method;
    }
}

