/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.injection;

import com.oracle.pitchfork.interfaces.PitchforkRuntimeMode;
import com.oracle.pitchfork.interfaces.PitchforkUtils;
import weblogic.j2ee.injection.PitchforkRuntimeModeFactory;
import weblogic.utils.AssertionError;

public class PitchforkContext {
    private static final String SPRING_COMPONENT_FACTORY_CLASS_NAME = "com.oracle.pitchfork.interfaces.SpringComponentFactory";
    private static final String OLD_SPRING_COMPONENT_FACTORY_CLASS_NAME = "org.springframework.jee.interfaces.SpringComponentFactory";
    private PitchforkUtils pUtils;
    private boolean isWLSComponentFactoryClassName;
    private boolean isSpringComponentFactoryClassName;
    private String componentFactoryClassName;
    private final PitchforkRuntimeMode pitchforkRuntimeMode;

    public PitchforkContext(String string) {
        this.componentFactoryClassName = string;
        this.isWLSComponentFactoryClassName = string == null;
        this.isSpringComponentFactoryClassName = SPRING_COMPONENT_FACTORY_CLASS_NAME.equalsIgnoreCase(string) || OLD_SPRING_COMPONENT_FACTORY_CLASS_NAME.equalsIgnoreCase(string);
        this.pitchforkRuntimeMode = PitchforkRuntimeModeFactory.createPitchforkRuntimeMode(string);
    }

    public boolean isWLSComponentFactoryClassName() {
        return this.isWLSComponentFactoryClassName;
    }

    public boolean isSpringComponentFactoryClassName() {
        return this.isSpringComponentFactoryClassName;
    }

    public String getComponentFactoryClassName() {
        return this.componentFactoryClassName;
    }

    public static String getComponentFactoryClassName(String string) {
        if (string == null || SPRING_COMPONENT_FACTORY_CLASS_NAME.equalsIgnoreCase(string) || OLD_SPRING_COMPONENT_FACTORY_CLASS_NAME.equalsIgnoreCase(string)) {
            return null;
        }
        return string;
    }

    public PitchforkUtils getPitchforkUtils() {
        if (this.pUtils != null) {
            return this.pUtils;
        }
        Class clazz = this.getTargetClass("com.oracle.pitchfork.spi.PitchforkUtilsImpl");
        if (clazz != null) {
            try {
                this.pUtils = (PitchforkUtils)clazz.newInstance();
                return this.pUtils;
            }
            catch (Throwable throwable) {
                throw new AssertionError("Couldn't create instance for class " + clazz.getName(), throwable);
            }
        }
        return null;
    }

    private Class getTargetClass(String string) {
        try {
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                return clazz;
            }
        }
        catch (Throwable throwable) {
            throw new AssertionError("The following exception is thrown during loading class " + string + ": ", throwable);
        }
        return null;
    }

    public PitchforkRuntimeMode getPitchforkRuntimeMode() {
        return this.pitchforkRuntimeMode;
    }
}

