/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2ee.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import weblogic.ejb.spi.EJBValidationInfo;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.J2EEUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.wl.ApplicationEntityCacheBean;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JMSBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.validation.ComplianceException;
import weblogic.j2ee.validation.ModuleValidationInfo;
import weblogic.logging.Loggable;
import weblogic.utils.ErrorCollectionException;

public final class EARValidator {
    private static final boolean debug = false;
    ApplicationBean dd = null;
    WeblogicApplicationBean wldd = null;
    Map moduleInfos = new HashMap();
    Map name2ModuleInfos = new HashMap();

    public EARValidator(ApplicationBean applicationBean, WeblogicApplicationBean weblogicApplicationBean) {
        this.dd = applicationBean;
        this.wldd = weblogicApplicationBean;
    }

    public void addModuleValidationInfo(ModuleValidationInfo moduleValidationInfo) {
        this.moduleInfos.put(moduleValidationInfo.getURI(), moduleValidationInfo);
        if (moduleValidationInfo.getModuleName() != null) {
            this.name2ModuleInfos.put(moduleValidationInfo.getModuleName(), moduleValidationInfo);
        }
    }

    public void validate() throws ErrorCollectionException {
        ErrorCollectionException errorCollectionException;
        HashSet<String> hashSet = null;
        if (this.wldd != null) {
            hashSet = new HashSet<String>();
            errorCollectionException = this.wldd.getEjb();
            if (errorCollectionException != null) {
                ApplicationEntityCacheBean[] applicationEntityCacheBeanArray = errorCollectionException.getEntityCaches();
                for (int i = 0; i < applicationEntityCacheBeanArray.length; ++i) {
                    hashSet.add(applicationEntityCacheBeanArray[i].getEntityCacheName());
                }
            }
        }
        errorCollectionException = new ErrorCollectionException("");
        for (ModuleValidationInfo moduleValidationInfo : this.moduleInfos.values()) {
            this.validateEJBLinks(moduleValidationInfo, errorCollectionException);
            this.ValidateAppScopedCacheRefs(hashSet, moduleValidationInfo, errorCollectionException);
            this.validateJMSLinkRefs(moduleValidationInfo, errorCollectionException);
            this.validateJDBCLinkRefs(moduleValidationInfo, errorCollectionException);
        }
        if (!errorCollectionException.isEmpty()) {
            throw errorCollectionException;
        }
    }

    private void validateEJBLinks(ModuleValidationInfo moduleValidationInfo, ErrorCollectionException errorCollectionException) {
        Collection collection = moduleValidationInfo.getEJBRefs();
        for (ModuleValidationInfo.EJBRef eJBRef : collection) {
            try {
                EJBValidationInfo eJBValidationInfo;
                String string = eJBRef.getEJBLink();
                if (string.indexOf(35) < 0) {
                    this.validateUnqualifiedEJBLink(moduleValidationInfo, eJBRef, string);
                    continue;
                }
                if (string.startsWith("../")) {
                    string = J2EEUtils.makePathAbsolute(string, moduleValidationInfo.getURI());
                }
                int n = string.indexOf(35);
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1, string.length());
                ModuleValidationInfo moduleValidationInfo2 = (ModuleValidationInfo)this.moduleInfos.get(string2);
                if (moduleValidationInfo2 == null) {
                    if (eJBRef.getEJBName() != null) {
                        eJBValidationInfo = J2EELogger.logInvalidEJBLinkQualificationInEJBDescriptorLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)string2);
                        throw new ComplianceException(eJBValidationInfo.getMessage());
                    }
                    eJBValidationInfo = J2EELogger.logInvalidEJBLinkQualificationLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)string2);
                    throw new ComplianceException(eJBValidationInfo.getMessage());
                }
                eJBValidationInfo = moduleValidationInfo2.getEJBValidationInfo(string3);
                if (eJBValidationInfo == null) {
                    if (eJBRef.getEJBName() != null) {
                        Loggable loggable = J2EELogger.logInvalidQualifiedEJBLinkInEJBDescriptorLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)string2, (String)string3);
                        throw new ComplianceException(loggable.getMessage());
                    }
                    Loggable loggable = J2EELogger.logInvalidQualifiedEJBLinkLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)string2, (String)string3);
                    throw new ComplianceException(loggable.getMessage());
                }
                if (!eJBValidationInfo.isClientDriven()) {
                    if (eJBRef.getEJBName() != null) {
                        Loggable loggable = J2EELogger.logEJBLinkInEJBDescriptorPointsToInvalidBeanLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI());
                        throw new ComplianceException(loggable.getMessage());
                    }
                    Loggable loggable = J2EELogger.logEJBLinkPointsToInvalidBeanLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI());
                    throw new ComplianceException(loggable.getMessage());
                }
                this.validateResolvedEJBLink(moduleValidationInfo, eJBRef, eJBValidationInfo);
            }
            catch (ComplianceException complianceException) {
                errorCollectionException.add((Throwable)complianceException);
            }
        }
    }

    private void validateUnqualifiedEJBLink(ModuleValidationInfo moduleValidationInfo, ModuleValidationInfo.EJBRef eJBRef, String string) throws ComplianceException {
        Object object;
        Object object22;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object object22 : this.moduleInfos.values()) {
            object = ((ModuleValidationInfo)object22).getEJBValidationInfo(string);
            if (object == null || !object.isClientDriven()) continue;
            arrayList.add(object22);
        }
        if (arrayList.size() != 1) {
            if (arrayList.size() == 0) {
                if (eJBRef.getEJBName() != null) {
                    object22 = J2EELogger.logInvalidUnqualifiedEJBLinkInEJBDescriptorLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI());
                    throw new ComplianceException(object22.getMessage());
                }
                object22 = J2EELogger.logInvalidUnqualifiedEJBLinkLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI());
                throw new ComplianceException(object22.getMessage());
            }
            object22 = new StringBuffer();
            object = arrayList.iterator();
            while (object.hasNext()) {
                if (((StringBuffer)object22).length() > 0) {
                    ((StringBuffer)object22).append(", ");
                }
                ((StringBuffer)object22).append(((ModuleValidationInfo)object.next()).getURI());
            }
            if (eJBRef.getEJBName() != null) {
                Loggable loggable = J2EELogger.logAmbiguousEJBLinkInEJBDescriptorLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)((StringBuffer)object22).toString());
                throw new ComplianceException(loggable.getMessage());
            }
            Loggable loggable = J2EELogger.logAmbiguousEJBLinkLoggable((String)eJBRef.getEJBLink(), (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)((StringBuffer)object22).toString());
            throw new ComplianceException(loggable.getMessage());
        }
        object22 = (ModuleValidationInfo)arrayList.get(0);
        object = ((ModuleValidationInfo)object22).getEJBValidationInfo(string);
        this.validateResolvedEJBLink(moduleValidationInfo, eJBRef, (EJBValidationInfo)object);
    }

    private boolean ejbImplementsBusinessInterface(String string, boolean bl, EJBValidationInfo eJBValidationInfo) {
        Set set = null;
        set = bl ? eJBValidationInfo.getBusinessLocals() : eJBValidationInfo.getBusinessRemotes();
        for (Class clazz : set) {
            if (!string.equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private void validateResolvedEJBLink(ModuleValidationInfo moduleValidationInfo, ModuleValidationInfo.EJBRef eJBRef, EJBValidationInfo eJBValidationInfo) throws ComplianceException {
        this.validateEJBRefType(moduleValidationInfo, eJBRef, eJBValidationInfo);
        if (eJBRef.getHomeInterfaceName() == null) {
            if (!this.ejbImplementsBusinessInterface(eJBRef.getComponentInterfaceName(), true, eJBValidationInfo) && !this.ejbImplementsBusinessInterface(eJBRef.getComponentInterfaceName(), false, eJBValidationInfo)) {
                Loggable loggable = J2EELogger.logIncorrectInterfaceForEJBAnnotationTargetLoggable((String)moduleValidationInfo.getURI(), (String)eJBRef.getEJBLink(), (String)eJBRef.getComponentInterfaceName(), (String)eJBRef.getEJBRefName());
                throw new ComplianceException(loggable.getMessage());
            }
            return;
        }
        if (eJBRef.isLocal()) {
            String string;
            if (!eJBValidationInfo.hasLocalClientView()) {
                if (eJBRef.getEJBName() != null) {
                    Loggable loggable = J2EELogger.logIncorrectInterfacesForEJBRefTypeInEJBDescriptorLoggable((String)eJBRef.getEJBLink(), (String)"ejb-local-ref", (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"local");
                    throw new ComplianceException(loggable.getMessage());
                }
                Loggable loggable = J2EELogger.logIncorrectInterfacesForEJBRefTypeLoggable((String)eJBRef.getEJBLink(), (String)"ejb-local-ref", (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"local");
                throw new ComplianceException(loggable.getMessage());
            }
            String string2 = eJBRef.getComponentInterfaceName();
            if (string2 != null) {
                boolean bl = false;
                bl = string2.equals(eJBValidationInfo.getLocalInterfaceName());
                if (!bl) {
                    bl = this.ejbImplementsBusinessInterface(string2, true, eJBValidationInfo);
                }
                if (!bl) {
                    if (eJBRef.getEJBName() != null) {
                        J2EELogger.logIncorrectInterfaceNameForEJBRefInEJBDescriptor((String)"ejb-local-ref", (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"local", (String)string2);
                    } else {
                        J2EELogger.logIncorrectInterfaceNameForEJBRef((String)"ejb-local-ref", (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"local", (String)string2);
                    }
                }
            }
            if ((string = eJBRef.getHomeInterfaceName()) != null && !string.equals(eJBValidationInfo.getLocalHomeInterfaceName())) {
                if (eJBRef.getEJBName() != null) {
                    J2EELogger.logIncorrectInterfaceNameForEJBRefInEJBDescriptor((String)"ejb-local-ref", (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"local-home", (String)eJBRef.getHomeInterfaceName());
                } else {
                    J2EELogger.logIncorrectInterfaceNameForEJBRef((String)"ejb-local-ref", (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"local-home", (String)eJBRef.getHomeInterfaceName());
                }
            }
        } else {
            String string;
            if (!eJBValidationInfo.hasRemoteClientView()) {
                if (eJBRef.getEJBName() != null) {
                    Loggable loggable = J2EELogger.logIncorrectInterfacesForEJBRefTypeInEJBDescriptorLoggable((String)eJBRef.getEJBLink(), (String)"ejb-ref", (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"remote");
                    throw new ComplianceException(loggable.getMessage());
                }
                Loggable loggable = J2EELogger.logIncorrectInterfacesForEJBRefTypeLoggable((String)eJBRef.getEJBLink(), (String)"ejb-ref", (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"remote");
                throw new ComplianceException(loggable.getMessage());
            }
            String string3 = eJBRef.getComponentInterfaceName();
            if (string3 != null) {
                boolean bl = false;
                bl = string3.equals(eJBValidationInfo.getRemoteInterfaceName());
                if (!bl) {
                    bl = this.ejbImplementsBusinessInterface(string3, false, eJBValidationInfo);
                }
                if (!bl) {
                    if (eJBRef.getEJBName() != null) {
                        J2EELogger.logIncorrectInterfaceNameForEJBRefInEJBDescriptor((String)"ejb-ref", (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"remote", (String)eJBRef.getComponentInterfaceName());
                    } else {
                        J2EELogger.logIncorrectInterfaceNameForEJBRef((String)"ejb-ref", (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"remote", (String)eJBRef.getComponentInterfaceName());
                    }
                }
            }
            if ((string = eJBRef.getHomeInterfaceName()) != null && !string.equals(eJBValidationInfo.getHomeInterfaceName())) {
                if (eJBRef.getEJBName() != null) {
                    J2EELogger.logIncorrectInterfaceNameForEJBRefInEJBDescriptor((String)"ejb-ref", (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"home", (String)eJBRef.getHomeInterfaceName());
                } else {
                    J2EELogger.logIncorrectInterfaceNameForEJBRef((String)"ejb-ref", (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"home", (String)eJBRef.getHomeInterfaceName());
                }
            }
        }
    }

    private void validateEJBRefType(ModuleValidationInfo moduleValidationInfo, ModuleValidationInfo.EJBRef eJBRef, EJBValidationInfo eJBValidationInfo) {
        String string = eJBRef.getRefType();
        if ("Session".equalsIgnoreCase(string)) {
            if (!eJBValidationInfo.isSessionBean()) {
                String string2 = "ejb-local-ref";
                if (!eJBRef.isLocal()) {
                    string2 = "ejb-ref";
                }
                if (eJBRef.getEJBName() != null) {
                    J2EELogger.logIncorrectRefTypeForEJBRefInEJBDescriptor((String)string2, (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"Session");
                } else {
                    J2EELogger.logIncorrectRefTypeForEJBRef((String)string2, (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"Session");
                }
            }
        } else if ("Entity".equalsIgnoreCase(string) && !eJBValidationInfo.isEntityBean()) {
            String string3 = "ejb-local-ref";
            if (!eJBRef.isLocal()) {
                string3 = "ejb-ref";
            }
            if (eJBRef.getEJBName() != null) {
                J2EELogger.logIncorrectRefTypeForEJBRefInEJBDescriptor((String)string3, (String)eJBRef.getEJBRefName(), (String)eJBRef.getEJBName(), (String)moduleValidationInfo.getURI(), (String)"Entity");
            } else {
                J2EELogger.logIncorrectRefTypeForEJBRef((String)string3, (String)eJBRef.getEJBRefName(), (String)moduleValidationInfo.getURI(), (String)"Entity");
            }
        }
    }

    private void ValidateAppScopedCacheRefs(Collection collection, ModuleValidationInfo moduleValidationInfo, ErrorCollectionException errorCollectionException) {
        Map map = moduleValidationInfo.getAppScopedCacheReferences();
        if (map != null) {
            for (String string : map.keySet()) {
                Loggable loggable;
                if (collection != null) {
                    if (collection.contains(string)) continue;
                    loggable = J2EELogger.logInvalidEntityCacheRefDeclaredLoggable((String)((String)map.get(string)), (String)moduleValidationInfo.getURI(), (String)string);
                    errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
                    continue;
                }
                loggable = J2EELogger.logInvalidEntityCacheRefDeclaredLoggable((String)((String)map.get(string)), (String)moduleValidationInfo.getURI(), (String)string);
                errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
            }
        }
    }

    private void validateJMSLinkRefs(ModuleValidationInfo moduleValidationInfo, ErrorCollectionException errorCollectionException) {
        Collection collection = moduleValidationInfo.getJMSLinkRefs();
        for (ModuleValidationInfo.JLinkRef jLinkRef : collection) {
            Loggable loggable;
            JMSBean jMSBean;
            String string = jLinkRef.getAppComponentName();
            String string2 = jLinkRef.getAppComponentType();
            String string3 = jLinkRef.getResRefName();
            String string4 = jLinkRef.getResRefType();
            String string5 = jLinkRef.getResLinkName();
            if (string5.indexOf(35) <= 0) continue;
            int n = string5.indexOf(35);
            String string6 = string5.substring(0, n);
            String string7 = string5.substring(n + 1, string5.length());
            ModuleValidationInfo moduleValidationInfo2 = (ModuleValidationInfo)this.name2ModuleInfos.get(string6);
            if (moduleValidationInfo2 == null) {
                jMSBean = J2EELogger.logInvalidJMSResourceLinkInJ2EEComponentLoggable((String)string, (String)string2, (String)string6, (String)string5);
                errorCollectionException.add((Throwable)new ComplianceException(jMSBean.getMessage()));
                continue;
            }
            jMSBean = moduleValidationInfo2.getJMSBean();
            if (jMSBean == null) {
                loggable = J2EELogger.logInvalidJMSResourceLinkInJ2EEComponentLoggable((String)string, (String)string2, (String)string6, (String)string5);
                errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
                continue;
            }
            if (string4.equals("javax.jms.Queue")) {
                if (jMSBean.lookupQueue(string7) != null || jMSBean.lookupDistributedQueue(string7) != null || jMSBean.lookupUniformDistributedQueue(string7) != null) continue;
                loggable = J2EELogger.logJMSResourceSpecifiedInResourceLinkNotFoundLoggable((String)string, (String)string2, (String)string6, (String)string5, (String)string7, (String)"javax.jms.Queue");
                errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
                continue;
            }
            if (string4.equals("javax.jms.Topic")) {
                if (jMSBean.lookupTopic(string7) != null || jMSBean.lookupDistributedTopic(string7) != null || jMSBean.lookupUniformDistributedTopic(string7) != null) continue;
                loggable = J2EELogger.logJMSResourceSpecifiedInResourceLinkNotFoundLoggable((String)string, (String)string2, (String)string6, (String)string5, (String)string7, (String)"javax.jms.Topic");
                errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
                continue;
            }
            if (!string4.equals("javax.jms.ConnectionFactory") && !string4.equals("javax.jms.QueueConnectionFactory") && !string4.equals("javax.jms.TopicConnectionFactory") || jMSBean.lookupConnectionFactory(string7) != null) continue;
            loggable = J2EELogger.logJMSResourceSpecifiedInResourceLinkNotFoundLoggable((String)string, (String)string2, (String)string6, (String)string5, (String)string7, (String)"javax.jms.ConnectionFactory");
            errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
        }
    }

    private void validateJDBCLinkRefs(ModuleValidationInfo moduleValidationInfo, ErrorCollectionException errorCollectionException) {
        Collection collection = moduleValidationInfo.getJDBCLinkRefs();
        for (ModuleValidationInfo.JLinkRef jLinkRef : collection) {
            Loggable loggable;
            JDBCDataSourceBean jDBCDataSourceBean;
            String string = jLinkRef.getAppComponentName();
            String string2 = jLinkRef.getAppComponentType();
            String string3 = jLinkRef.getResRefName();
            String string4 = jLinkRef.getResRefType();
            String string5 = jLinkRef.getResLinkName();
            if (string5.indexOf(35) <= 0) continue;
            int n = string5.indexOf(35);
            String string6 = string5.substring(0, n);
            String string7 = string5.substring(n + 1, string5.length());
            ModuleValidationInfo moduleValidationInfo2 = (ModuleValidationInfo)this.name2ModuleInfos.get(string6);
            if (moduleValidationInfo2 == null) {
                jDBCDataSourceBean = J2EELogger.logInvalidJDBCResourceLinkInJ2EEComponentLoggable((String)string, (String)string2, (String)string6, (String)string5);
                errorCollectionException.add((Throwable)new ComplianceException(jDBCDataSourceBean.getMessage()));
                continue;
            }
            jDBCDataSourceBean = moduleValidationInfo2.getJDBCDataSourceBean();
            if (jDBCDataSourceBean == null) {
                loggable = J2EELogger.logInvalidJDBCResourceLinkInJ2EEComponentLoggable((String)string, (String)string2, (String)string6, (String)string5);
                errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
                continue;
            }
            if (!string4.equals("javax.sql.DataSource") || jDBCDataSourceBean.getName() != null && jDBCDataSourceBean.getName().equals(string7)) continue;
            loggable = J2EELogger.logJDBCResourceSpecifiedInResourceLinkNotFoundLoggable((String)string, (String)string2, (String)string6, (String)string5, (String)string7, (String)"javax.sql.DataSource");
            errorCollectionException.add((Throwable)new ComplianceException(loggable.getMessage()));
        }
    }
}

