/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2eeclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import weblogic.application.descriptor.AbstractDescriptorLoader2;
import weblogic.application.descriptor.VersionMunger;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.EditableDescriptorManager;
import weblogic.j2ee.descriptor.ApplicationClientBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationClientBean;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class ApplicationClientDescriptor {
    private final MyApplicationClientDescriptor appClientDescriptor;
    private final MyWlsApplicationClientDescriptor wlsAppClientDescriptor;
    private static final Map wlNameChanges = new HashMap();

    public ApplicationClientDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appClientDescriptor = new MyApplicationClientDescriptor(virtualJarFile);
        this.wlsAppClientDescriptor = new MyWlsApplicationClientDescriptor(virtualJarFile, file, deploymentPlanBean, string);
    }

    public ApplicationClientDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appClientDescriptor = new MyApplicationClientDescriptor(file);
        this.wlsAppClientDescriptor = new MyWlsApplicationClientDescriptor(file, file2, deploymentPlanBean, string);
    }

    public ApplicationClientDescriptor(GenericClassLoader genericClassLoader) {
        this.appClientDescriptor = new MyApplicationClientDescriptor(genericClassLoader);
        this.wlsAppClientDescriptor = new MyWlsApplicationClientDescriptor(genericClassLoader);
    }

    public ApplicationClientDescriptor(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appClientDescriptor = new MyApplicationClientDescriptor(genericClassLoader);
        this.wlsAppClientDescriptor = new MyWlsApplicationClientDescriptor(genericClassLoader, file, deploymentPlanBean, string);
    }

    public ApplicationClientDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
        this.appClientDescriptor = new MyApplicationClientDescriptor(descriptorManager, genericClassLoader);
        this.wlsAppClientDescriptor = new MyWlsApplicationClientDescriptor(descriptorManager, genericClassLoader);
    }

    public ApplicationClientDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
        this.appClientDescriptor = new MyApplicationClientDescriptor(descriptorManager, genericClassLoader);
        this.wlsAppClientDescriptor = new MyWlsApplicationClientDescriptor(descriptorManager, genericClassLoader, file, deploymentPlanBean, string);
    }

    public DeploymentPlanBean getDeploymentPlan() {
        return this.appClientDescriptor.getDeploymentPlan();
    }

    public ApplicationClientBean getApplicationClientBean() throws IOException, XMLStreamException {
        ApplicationClientBean applicationClientBean = (ApplicationClientBean)this.appClientDescriptor.loadDescriptorBean();
        if (applicationClientBean == null) {
            applicationClientBean = (ApplicationClientBean)new DescriptorManager().createDescriptorRoot(ApplicationClientBean.class).getRootBean();
        }
        return applicationClientBean;
    }

    public WeblogicApplicationClientBean getWeblogicApplicationClientBean() throws IOException, XMLStreamException {
        WeblogicApplicationClientBean weblogicApplicationClientBean = (WeblogicApplicationClientBean)this.wlsAppClientDescriptor.loadDescriptorBean();
        if (weblogicApplicationClientBean == null) {
            return (WeblogicApplicationClientBean)new EditableDescriptorManager().createDescriptorRoot(WeblogicApplicationClientBean.class).getRootBean();
        }
        return weblogicApplicationClientBean;
    }

    public AbstractDescriptorLoader2 getApplicationClientDescriptorLoader() {
        return this.appClientDescriptor;
    }

    public AbstractDescriptorLoader2 getWlsApplicationClientDescriptorLoader() {
        return this.wlsAppClientDescriptor;
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        File file;
        if (stringArray.length < 1) {
            ApplicationClientDescriptor.usage();
        }
        if ((file = new File(string = stringArray[0])).getName().endsWith(".jar")) {
            JarFile jarFile = new JarFile(string);
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((JarFile)jarFile);
            System.out.println("\n\n... getting ApplicationClientBean:");
            ApplicationClientDescriptor applicationClientDescriptor = new ApplicationClientDescriptor(virtualJarFile, null, null, null);
            ApplicationClientBean applicationClientBean = applicationClientDescriptor.getApplicationClientBean();
            ((DescriptorBean)applicationClientBean).getDescriptor().toXML((OutputStream)System.out);
            System.out.println("\n\n... getting WeblogicApplicationClientBean:");
            WeblogicApplicationClientBean weblogicApplicationClientBean = new ApplicationClientDescriptor(virtualJarFile, null, null, null).getWeblogicApplicationClientBean();
            ((DescriptorBean)weblogicApplicationClientBean).getDescriptor().toXML((OutputStream)System.out);
        } else if (file.getPath().endsWith("weblogic-application-client.xml")) {
            System.out.println("\n\n... getting WeblogicApplicationClientBean from: " + file);
            WeblogicApplicationClientBean weblogicApplicationClientBean = new ApplicationClientDescriptor(file, null, null, null).getWeblogicApplicationClientBean();
            ((DescriptorBean)weblogicApplicationClientBean).getDescriptor().toXML((OutputStream)System.out);
        } else if (file.getPath().endsWith("application-client.xml")) {
            System.out.println("\n\n... getting ApplicationClientBean:");
            ApplicationClientBean applicationClientBean = new ApplicationClientDescriptor(file, null, null, null).getApplicationClientBean();
            ((DescriptorBean)applicationClientBean).getDescriptor().toXML((OutputStream)System.out);
        } else {
            System.out.println("\n\n... neither application-client.xml nor weblogic-application-client.xml specified");
        }
    }

    private static void usage() {
        System.err.println("usage: java weblogic.j2eeclient.ApplicationClientDescriptor <descriptor file name>");
        System.err.println("\n\n example:\n java weblogic.j2eeclient.ApplicationClientDescriptor jar or altDD file name ");
        System.exit(0);
    }

    static {
        wlNameChanges.put("application-client", "weblogic-application-client");
        wlNameChanges.put("ejb-ref", "ejb-reference-description");
        wlNameChanges.put("resource-ref", "resource-description");
        wlNameChanges.put("resource-env-ref", "resource-env-description");
    }

    private class MyWlsApplicationClientDescriptor
    extends MyAbstractDescriptorLoader {
        MyWlsApplicationClientDescriptor(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            super(virtualJarFile, file, deploymentPlanBean, string, "META-INF/weblogic-application-client.xml");
        }

        MyWlsApplicationClientDescriptor(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string) {
            super(file, file2, deploymentPlanBean, string, "META-INF/weblogic-application-client.xml");
        }

        MyWlsApplicationClientDescriptor(GenericClassLoader genericClassLoader) {
            super(genericClassLoader, "META-INF/weblogic-application-client.xml");
        }

        MyWlsApplicationClientDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader, "META-INF/weblogic-application-client.xml");
        }

        MyWlsApplicationClientDescriptor(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            this(genericClassLoader);
        }

        MyWlsApplicationClientDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string) {
            this(genericClassLoader);
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new VersionMunger(inputStream, this, "weblogic.j2ee.descriptor.wl.WeblogicApplicationClientBeanImpl$SchemaHelper2", wlNameChanges, "http://xmlns.oracle.com/weblogic/weblogic-application-client"){

                public boolean hasDTD() {
                    return true;
                }

                protected boolean lookForDTD(AbstractDescriptorLoader2 abstractDescriptorLoader2) throws XMLStreamException {
                    return true;
                }
            };
        }
    }

    private class MyApplicationClientDescriptor
    extends MyAbstractDescriptorLoader {
        MyApplicationClientDescriptor(VirtualJarFile virtualJarFile) {
            super(virtualJarFile, "META-INF/application-client.xml");
        }

        MyApplicationClientDescriptor(File file) {
            super(file, "META-INF/application-client.xml");
        }

        MyApplicationClientDescriptor(GenericClassLoader genericClassLoader) {
            super(genericClassLoader, "META-INF/application-client.xml");
        }

        MyApplicationClientDescriptor(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader) {
            super(descriptorManager, genericClassLoader, "META-INF/application-client.xml");
        }

        protected XMLStreamReader createXMLStreamReader(InputStream inputStream) throws XMLStreamException {
            return new VersionMunger(inputStream, this, "weblogic.j2ee.descriptor.ApplicationClientBeanImpl$SchemaHelper2"){
                private boolean inEjbLink;
                {
                    this.inEjbLink = false;
                }

                public String getDtdNamespaceURI() {
                    return "http://java.sun.com/xml/ns/javaee";
                }

                protected boolean isOldSchema() {
                    String string = this.getNamespaceURI();
                    return string != null && string.indexOf("j2ee") != -1;
                }

                protected void transformOldSchema() {
                    if (this.currentEvent.getElementName().equals("application-client")) {
                        int n = this.currentEvent.getReaderEventInfo().getAttributeCount();
                        for (int i = 0; i < n; ++i) {
                            String string;
                            String string2 = this.currentEvent.getReaderEventInfo().getAttributeLocalName(i);
                            if (string2 == null || !string2.equals("version") || !(string = this.currentEvent.getReaderEventInfo().getAttributeValue(i)).equals("1.4")) continue;
                            this.versionInfo = string;
                            this.currentEvent.getReaderEventInfo().setAttributeValue("5", i);
                        }
                        this.transformNamespace("http://java.sun.com/xml/ns/javaee", this.currentEvent, "http://java.sun.com/xml/ns/j2ee");
                    }
                    this.tranformedNamespace = "http://java.sun.com/xml/ns/javaee";
                }

                public VersionMunger.Continuation onStartElement(String string) {
                    if ("ejb-link".equals(string)) {
                        this.inEjbLink = true;
                    }
                    return CONTINUE;
                }

                protected VersionMunger.Continuation onCharacters(String string) {
                    if (this.inEjbLink) {
                        this.replaceSlashWithPeriod(this.inEjbLink);
                    }
                    return CONTINUE;
                }

                public VersionMunger.Continuation onEndElement(String string) {
                    if ("ejb-link".equals(string)) {
                        this.inEjbLink = false;
                    }
                    return CONTINUE;
                }
            };
        }
    }

    private class MyAbstractDescriptorLoader
    extends AbstractDescriptorLoader2 {
        MyAbstractDescriptorLoader(VirtualJarFile virtualJarFile, String string) {
            super(virtualJarFile, string);
        }

        MyAbstractDescriptorLoader(File file, String string) {
            super(file, string);
        }

        MyAbstractDescriptorLoader(GenericClassLoader genericClassLoader, String string) {
            super(genericClassLoader, string);
        }

        MyAbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, String string) {
            super(descriptorManager, genericClassLoader, string);
        }

        MyAbstractDescriptorLoader(VirtualJarFile virtualJarFile, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(virtualJarFile, file, deploymentPlanBean, string, string2);
        }

        MyAbstractDescriptorLoader(File file, File file2, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            super(file, file2, deploymentPlanBean, string, string2);
        }

        MyAbstractDescriptorLoader(GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            this(genericClassLoader, string2);
        }

        MyAbstractDescriptorLoader(DescriptorManager descriptorManager, GenericClassLoader genericClassLoader, File file, DeploymentPlanBean deploymentPlanBean, String string, String string2) {
            this(genericClassLoader, string2);
        }

        protected DescriptorBean createDescriptorBean(InputStream inputStream) throws IOException, XMLStreamException {
            this.munger = (VersionMunger)this.createXMLStreamReader(inputStream);
            if (this.munger.hasDTD() || this.munger instanceof VersionMunger) {
                return this.getDescriptorManager().createDescriptor((XMLStreamReader)this.munger.getPlaybackReader(), false).getRootBean();
            }
            return this.getDescriptorManager().createDescriptor((XMLStreamReader)this.munger).getRootBean();
        }
    }
}

