/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2eeclient;

import java.io.OutputStream;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.dd.xml.AnnotationProcessor;
import weblogic.j2ee.descriptor.ApplicationClientBean;
import weblogic.j2ee.descriptor.J2eeClientEnvironmentBean;
import weblogic.j2eeclient.ApplicationClientDescriptor;
import weblogic.utils.Debug;
import weblogic.utils.classloaders.GenericClassLoader;

public class ApplicationClientUtils {
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.debug.DebugJ2EEClient");

    public static ApplicationClientBean getAnnotationProcessedDescriptor(GenericClassLoader genericClassLoader, ApplicationClientDescriptor applicationClientDescriptor, Class clazz) throws Exception {
        ApplicationClientBean applicationClientBean = applicationClientDescriptor.getApplicationClientBean();
        if (!applicationClientBean.isMetadataComplete()) {
            if (DEBUG) {
                Debug.say((String)" The Descriptor is not full. Processing annotations");
            }
            if (DEBUG) {
                Debug.say((String)"Before annotations the client bean is ");
                ((DescriptorBean)applicationClientBean).getDescriptor().toXML((OutputStream)System.out);
            }
            AnnotationProcessor annotationProcessor = ApplicationClientUtils.getAnnotationProcessor();
            annotationProcessor.processJ2eeAnnotations(clazz, (J2eeClientEnvironmentBean)applicationClientBean, true);
            annotationProcessor.validate((ClassLoader)genericClassLoader, (DescriptorBean)applicationClientBean, true);
            if (DEBUG) {
                Debug.say((String)"After annotations the client bean is ");
                ((DescriptorBean)applicationClientBean).getDescriptor().toXML((OutputStream)System.out);
            }
        }
        return applicationClientBean;
    }

    private static AnnotationProcessor getAnnotationProcessor() throws Exception {
        Class<?> clazz = Class.forName("weblogic.j2ee.dd.xml.BaseJ2eeAnnotationProcessor");
        return (AnnotationProcessor)clazz.newInstance();
    }
}

