/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2eeclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.j2eeclient.Descriptor;
import weblogic.utils.NestedError;
import weblogic.xml.jaxp.WebLogicSAXParserFactory;

public final class DDParser
extends HandlerBase {
    public static final String APPCLIENT_SUN_PUBLIC_ID = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN";
    public static final String APPCLIENT_SUN_SYSTEM_ID = "http://java.sun.com/dtd/application-client_1_3.dtd";
    public static final String APPCLIENT_SUN_LOCAL_ID = "application-client_1_3.dtd";
    public static final String APPCLIENT_SUN_PUBLIC_ID12 = "-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.2//EN";
    public static final String APPCLIENT_SUN_SYSTEM_ID12 = "http://java.sun.com/j2ee/dtds/application-client_1_2.dtd";
    public static final String APPCLIENT_SUN_LOCAL_ID12 = "application-client_1_2.dtd";
    public static final String APPCLIENT_BEA_PUBLIC_ID = "-//BEA Systems, Inc.//DTD WebLogic 7.0.0 J2EE Application Client//EN";
    public static final String APPCLIENT_BEA_SYSTEM_ID = "http://www.bea.com/servers/wls700/dtd/weblogic-appclient.dtd";
    public static final String APPCLIENT_BEA_LOCAL_ID = "weblogic-appclient.dtd";
    public static final String APPCLIENT_BEA_PUBLIC_ID12 = "-//BEA Systems, Inc.//DTD WebLogic 6.0.0 J2EE Application Client//EN";
    public static final String APPCLIENT_BEA_SYSTEM_ID12 = "http://www.bea.com/servers/wls600/dtd/weblogic-appclient.dtd";
    public static final String APPCLIENT_BEA_LOCAL_ID12 = "weblogic-appclient12.dtd";
    private static Map element2Field = new HashMap();
    private static int NAME_LENGTH;
    private SAXParser parser;
    private Map map = new HashMap();
    private String body;
    private Descriptor currentDescriptor;
    private boolean isJ2eeRi = false;
    private static final Map localMap;

    public DDParser() throws ParserConfigurationException, SAXException, IOException {
        WebLogicSAXParserFactory webLogicSAXParserFactory = new WebLogicSAXParserFactory();
        ((SAXParserFactory)webLogicSAXParserFactory).setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        this.parser = ((SAXParserFactory)webLogicSAXParserFactory).newSAXParser();
    }

    public Descriptor[] parse(InputStream inputStream) throws IOException, SAXException {
        this.parser.parse((InputStream)new FilterInputStream(inputStream){

            public void close() throws IOException {
            }
        }, (HandlerBase)this);
        return this.map.values().toArray(new Descriptor[this.map.size()]);
    }

    public Descriptor[] parse(File file) throws IOException, SAXException {
        return this.parse(new FileInputStream(file));
    }

    public void startElement(String string, AttributeList attributeList) {
        if ("j2ee-ri-specific-information".equals(string)) {
            this.isJ2eeRi = true;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2).trim();
        this.body = this.body != null ? this.body + string : string;
    }

    public void endElement(String string) throws SAXException {
        Field field = (Field)element2Field.get(string);
        if (field == Descriptor.NAME) {
            this.currentDescriptor = (Descriptor)this.map.get(this.body);
            if (this.currentDescriptor == null) {
                this.currentDescriptor = new Descriptor();
                this.currentDescriptor.type = string.substring(0, string.length() - NAME_LENGTH);
                this.map.put(this.body, this.currentDescriptor);
            }
        }
        if (field != null) {
            if (this.currentDescriptor == null) {
                throw new SAXException("Tag " + string + " without preceding naming tag");
            }
            if (this.isJ2eeRi && "jndi-name".equals(string) && !"java.net.URL".equals(this.currentDescriptor.type)) {
                this.body = this.body.replace('.', '_');
            }
            if ("ejb-link".equals(string)) {
                this.body = "link:" + this.body;
            }
            try {
                field.set(this.currentDescriptor, this.body);
            }
            catch (Exception exception) {
                throw new NestedError((Throwable)exception);
            }
        }
        this.body = null;
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        String string3 = (String)localMap.get(string);
        return string3 == null ? super.resolveEntity(string, string2) : new InputSource(this.getClass().getResourceAsStream(string3));
    }

    public static void main(String[] stringArray) throws Exception {
        DDParser dDParser = new DDParser();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(Arrays.asList((Object[])dDParser.parse(new File(stringArray[i]))));
        }
    }

    static {
        element2Field.put("ejb-link", Descriptor.VALUE);
        element2Field.put("ejb-ref-name", Descriptor.NAME);
        element2Field.put("env-entry-name", Descriptor.NAME);
        element2Field.put("env-entry-type", Descriptor.TYPE);
        element2Field.put("env-entry-value", Descriptor.VALUE);
        element2Field.put("jndi-name", Descriptor.VALUE);
        element2Field.put("res-ref-name", Descriptor.NAME);
        element2Field.put("res-type", Descriptor.TYPE);
        element2Field.put("resource-env-ref-name", Descriptor.NAME);
        element2Field.put("resource-env-ref-type", Descriptor.TYPE);
        element2Field.put("resource-env-ref-value", Descriptor.VALUE);
        NAME_LENGTH = "-name".length();
        localMap = new HashMap();
        localMap.put(APPCLIENT_SUN_PUBLIC_ID, APPCLIENT_SUN_LOCAL_ID);
        localMap.put(APPCLIENT_SUN_PUBLIC_ID12, APPCLIENT_SUN_LOCAL_ID12);
        localMap.put(APPCLIENT_BEA_PUBLIC_ID, APPCLIENT_BEA_LOCAL_ID);
        localMap.put(APPCLIENT_BEA_PUBLIC_ID12, APPCLIENT_BEA_LOCAL_ID12);
    }
}

