/*
 * Decompiled with CFR 0.152.
 */
package weblogic.j2eeclient;

import com.oracle.pitchfork.interfaces.inject.ComponentContributor;
import com.oracle.pitchfork.server.Bootstrap;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.xml.registry.ConnectionFactory;
import javax.xml.stream.XMLStreamException;
import org.omg.CORBA.ORB;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.utils.IOUtils;
import weblogic.deploy.internal.DeploymentPlanDescriptorLoader;
import weblogic.deployment.PersistenceUnitInfoImpl;
import weblogic.deployment.ServiceRefProcessor;
import weblogic.deployment.ServiceRefProcessorException;
import weblogic.deployment.ServiceRefProcessorFactory;
import weblogic.ejb20.internal.HandleDelegateImpl;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ApplicationClientBean;
import weblogic.j2ee.descriptor.EjbRefBean;
import weblogic.j2ee.descriptor.EnvEntryBean;
import weblogic.j2ee.descriptor.InjectionTargetBean;
import weblogic.j2ee.descriptor.LifecycleCallbackBean;
import weblogic.j2ee.descriptor.MessageDestinationRefBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.PersistenceUnitRefBean;
import weblogic.j2ee.descriptor.PortComponentRefBean;
import weblogic.j2ee.descriptor.ResourceEnvRefBean;
import weblogic.j2ee.descriptor.ResourceRefBean;
import weblogic.j2ee.descriptor.ServiceRefBean;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.EjbReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.MessageDestinationDescriptorBean;
import weblogic.j2ee.descriptor.wl.ResourceDescriptionBean;
import weblogic.j2ee.descriptor.wl.ResourceEnvDescriptionBean;
import weblogic.j2ee.descriptor.wl.ServiceReferenceDescriptionBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationClientBean;
import weblogic.j2ee.injection.PitchforkContext;
import weblogic.j2eeclient.AppClientPersistenceUnitRegistry;
import weblogic.j2eeclient.ApplicationClientDescriptor;
import weblogic.j2eeclient.ApplicationClientUtils;
import weblogic.j2eeclient.SimpleContext;
import weblogic.protocol.ClientEnvironment;
import weblogic.rmi.extensions.DisconnectMonitorListImpl;
import weblogic.security.acl.internal.Security;
import weblogic.utils.Debug;
import weblogic.utils.Getopt2;
import weblogic.utils.StackTraceUtils;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.classloaders.NullClassFinder;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;
import weblogic.workarea.WorkContextHelper;

public final class Main {
    private final File clientJar;
    private final String url;
    private final String[] argv;
    private final File configDir;
    private final DeploymentPlanBean plan;
    private String moduleName = null;
    private final File[] applicationLibraries;
    private final Context rootCtx;
    private static final boolean runningInsideWebStart = Boolean.getBoolean("weblogic.j2ee.client.isWebStart");
    private static final boolean DEBUG = Boolean.getBoolean("weblogic.debug.DebugJ2EEClient");
    private static final Context javaContext = new SimpleContext();
    private ApplicationClientBean stdDD;
    private Class mainClass;
    private static Collection lookupTypes = Arrays.asList((Object[])new String[]{"ejb-ref", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.jms.Queue", "javax.jms.Topic", "javax.sql.DataSource"});

    public Main(File file, String string, String[] stringArray, String string2, String string3, String string4, File[] fileArray) throws Exception {
        this.clientJar = file;
        this.url = string;
        this.argv = stringArray;
        this.configDir = string2 != null ? new File(string2) : null;
        this.plan = string3 != null ? new DeploymentPlanDescriptorLoader(new File(string3)).getDeploymentPlanBean() : null;
        this.moduleName = string4;
        this.applicationLibraries = fileArray;
        System.setProperty("java.naming.provider.url", string);
        System.setProperty("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
        System.setProperty("java.naming.factory.url.pkgs", "weblogic.j2eeclient");
        ClientEnvironment.loadEnvironment();
        this.rootCtx = new InitialContext();
    }

    public static Context getJavaContext() {
        return javaContext;
    }

    public void run() throws Exception {
        GenericClassLoader genericClassLoader = AugmentableClassLoaderManager.getAugmentableSystemClassLoader();
        ClassFinder classFinder = NullClassFinder.NULL_FINDER;
        if (DEBUG) {
            Debug.say((String)"Sarting");
        }
        if (DEBUG && runningInsideWebStart) {
            Debug.say((String)"JavaWebStart");
        }
        if (!runningInsideWebStart) {
            classFinder = new JarClassFinder(this.clientJar);
        }
        genericClassLoader.addClassFinder(classFinder);
        if (this.applicationLibraries != null) {
            for (int i = 0; i < this.applicationLibraries.length; ++i) {
                genericClassLoader.addClassFinder((ClassFinder)new JarClassFinder(this.applicationLibraries[i]));
            }
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)genericClassLoader);
        String string = this.readMainClassName((ClassLoader)genericClassLoader);
        this.mainClass = genericClassLoader.loadClass(string);
        AppClientPersistenceUnitRegistry appClientPersistenceUnitRegistry = new AppClientPersistenceUnitRegistry(this.clientJar, genericClassLoader, this.moduleName, this.configDir, this.plan);
        GenericClassLoader genericClassLoader2 = new GenericClassLoader(classFinder);
        this.fillEnvironment(genericClassLoader2, appClientPersistenceUnitRegistry);
        PitchforkContext pitchforkContext = new PitchforkContext(null);
        Bootstrap bootstrap = (Bootstrap)Class.forName("com.oracle.pitchfork.spi.WLSBootstrap").getConstructor(ClassLoader.class, String.class, String.class, Boolean.TYPE).newInstance(genericClassLoader2, null, null, Boolean.FALSE);
        bootstrap.deploy(this.getComponentContributor(pitchforkContext));
        this.processLifeCycle((ClassLoader)genericClassLoader, this.sortCallbackClasses((ClassLoader)genericClassLoader, this.stdDD.getPostConstructs()), "PostContruct");
        try {
            this.mainClass.getMethod("main", String[].class).invoke(null, new Object[]{this.argv});
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IOException("Main-Class " + string + " in client-jar " + this.clientJar.getPath() + " did not contain a public static void main(String[]) method");
        }
        this.processLifeCycle((ClassLoader)genericClassLoader, this.sortCallbackClasses((ClassLoader)genericClassLoader, this.stdDD.getPreDestroys()), "PreDestroy");
    }

    private ComponentContributor getComponentContributor(PitchforkContext pitchforkContext) throws Exception {
        Class<?> clazz = Class.forName("weblogic.j2ee.injection.J2eeClientComponentContributor");
        Constructor<?> constructor = clazz.getDeclaredConstructor(this.mainClass.getClass(), ApplicationClientBean.class, PitchforkContext.class);
        return (ComponentContributor)constructor.newInstance(this.mainClass, this.stdDD, pitchforkContext);
    }

    private LifecycleCallbackBean[] sortCallbackClasses(ClassLoader classLoader, LifecycleCallbackBean[] lifecycleCallbackBeanArray) throws ClassNotFoundException {
        if (lifecycleCallbackBeanArray.length <= 1) {
            return lifecycleCallbackBeanArray;
        }
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
            String string = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
            if (string == null || string.trim().length() == 0) {
                arrayList.add(this.mainClass);
                continue;
            }
            arrayList.add(classLoader.loadClass(string));
        }
        ArrayList<LifecycleCallbackBean> arrayList2 = new ArrayList<LifecycleCallbackBean>(Arrays.asList(lifecycleCallbackBeanArray));
        block1: for (int i = 1; i < arrayList.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                LifecycleCallbackBean lifecycleCallbackBean;
                Class clazz;
                Class clazz2 = (Class)arrayList.get(i);
                Class clazz3 = (Class)arrayList.get(j);
                if (clazz2.equals(Object.class) || clazz3.equals(Object.class)) continue block1;
                if (clazz2.isAssignableFrom(clazz3)) {
                    clazz = (Class)arrayList.remove(i);
                    arrayList.add(j, clazz);
                    lifecycleCallbackBean = (LifecycleCallbackBean)arrayList2.remove(i);
                    arrayList2.add(j, lifecycleCallbackBean);
                    continue block1;
                }
                if (!clazz3.isAssignableFrom(clazz2)) continue;
                while (j + 1 < i && ((Class)arrayList.get(j + 1)).isAssignableFrom(clazz2)) {
                    ++j;
                }
                clazz = (Class)arrayList.remove(i);
                arrayList.add(j + 1, clazz);
                lifecycleCallbackBean = (LifecycleCallbackBean)arrayList2.remove(i);
                arrayList2.add(j + 1, lifecycleCallbackBean);
                continue block1;
            }
        }
        return arrayList2.toArray(lifecycleCallbackBeanArray);
    }

    private void processLifeCycle(ClassLoader classLoader, LifecycleCallbackBean[] lifecycleCallbackBeanArray, String string) throws Exception {
        if (lifecycleCallbackBeanArray.length < 1) {
            return;
        }
        for (int i = 0; i < lifecycleCallbackBeanArray.length; ++i) {
            String string2 = lifecycleCallbackBeanArray[i].getLifecycleCallbackClass();
            String string3 = lifecycleCallbackBeanArray[i].getLifecycleCallbackMethod();
            Class<?> clazz = null;
            if (string2 == null || string2.trim().length() == 0) {
                clazz = this.mainClass;
            } else {
                try {
                    clazz = classLoader.loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new Exception("Unable to load " + string + " class " + string2);
                }
            }
            this.callLifeCycleMethod(clazz, string3, string);
        }
    }

    private void callLifeCycleMethod(Class clazz, String string, String string2) throws Exception {
        try {
            Method method = clazz.getDeclaredMethod(string, new Class[0]);
            method.setAccessible(true);
            if (Modifier.isStatic(method.getModifiers())) {
                method.invoke(null, new Object[0]);
            } else {
                Debug.say((String)(" the " + string2 + " method " + string + " in class" + clazz.getName() + " is not static. According to the common" + " annotations specification the j2ee client " + string2 + " method " + " should be static."));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Exception(string2 + "Class " + clazz.getName() + " in client-jar " + this.clientJar.getPath() + " did not contain the method " + string);
        }
    }

    private void fillEnvironment(GenericClassLoader genericClassLoader, AppClientPersistenceUnitRegistry appClientPersistenceUnitRegistry) throws Exception {
        ApplicationClientDescriptor applicationClientDescriptor = new ApplicationClientDescriptor(genericClassLoader, this.configDir, this.plan, this.moduleName);
        this.stdDD = ApplicationClientUtils.getAnnotationProcessedDescriptor(genericClassLoader, applicationClientDescriptor, this.mainClass);
        WeblogicApplicationClientBean weblogicApplicationClientBean = applicationClientDescriptor.getWeblogicApplicationClientBean();
        Context context = javaContext.createSubcontext("java:comp");
        context.bind("UserTransaction", this.rootCtx.lookup("javax.transaction.UserTransaction"));
        context.bind("HandleDelegate", (Object)new HandleDelegateImpl());
        WorkContextHelper.bind((Context)context);
        DisconnectMonitorListImpl.bindToJNDI((Context)context);
        context.bind("ORB", (Object)new SimpleContext.SimpleReference(){

            public Object get() throws NamingException {
                return ORB.init((String[])new String[0], null);
            }
        });
        this.loadCertificate();
        this.fillEnvContext(context.createSubcontext("env"), this.stdDD, weblogicApplicationClientBean, appClientPersistenceUnitRegistry);
    }

    private void loadCertificate() throws Exception {
        String string = System.getProperty("javax.net.ssl.keyStore");
        String string2 = System.getProperty("javax.net.ssl.keyStorePassword");
        if (string == null || string2 == null) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance("JKS");
        FileInputStream fileInputStream = new FileInputStream(string);
        if (string == null) {
            throw new SecurityException("Client authentication keystore not found");
        }
        char[] cArray = string2.toCharArray();
        keyStore.load(new FileInputStream(string), cArray);
        fileInputStream.close();
        String string3 = null;
        Enumeration<String> enumeration = keyStore.aliases();
        if (enumeration.hasMoreElements()) {
            string3 = enumeration.nextElement();
        }
        if (string3 == null) {
            throw new SecurityException("No alias found in keystore");
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(string3);
        if (certificateArray == null) {
            throw new SecurityException("Certificate chain with useralias " + string3 + " not found");
        }
        Key key = keyStore.getKey(string3, cArray);
        if (key == null) {
            throw new SecurityException("Key with useralias " + string3 + " not found");
        }
        Security.loadLocalIdentity(certificateArray, (PrivateKey)key);
    }

    private void fillEnvContext(Context context, ApplicationClientBean applicationClientBean, WeblogicApplicationClientBean weblogicApplicationClientBean, AppClientPersistenceUnitRegistry appClientPersistenceUnitRegistry) throws NamingException, IOException, Exception {
        this.envEntries(context, applicationClientBean.getEnvEntries());
        this.ejbRefs(context, applicationClientBean.getEjbRefs(), weblogicApplicationClientBean.getEjbReferenceDescriptions());
        this.serviceRefs(context, applicationClientBean.getServiceRefs(), weblogicApplicationClientBean.getServiceReferenceDescriptions());
        this.resourceRefs(context, applicationClientBean.getResourceRefs(), weblogicApplicationClientBean.getResourceDescriptions());
        this.resourceEnvRefs(context, applicationClientBean.getResourceEnvRefs(), weblogicApplicationClientBean.getResourceEnvDescriptions());
        this.persistenceUnitRefs(context, applicationClientBean.getPersistenceUnitRefs(), appClientPersistenceUnitRegistry);
        this.processMessageDestinationRefs(context, applicationClientBean, weblogicApplicationClientBean);
    }

    private void processMessageDestinationRefs(Context context, ApplicationClientBean applicationClientBean, WeblogicApplicationClientBean weblogicApplicationClientBean) throws IOException, NamingException {
        MessageDestinationRefBean[] messageDestinationRefBeanArray = applicationClientBean.getMessageDestinationRefs();
        if (messageDestinationRefBeanArray != null) {
            for (int i = 0; i < messageDestinationRefBeanArray.length; ++i) {
                Object object;
                MessageDestinationRefBean messageDestinationRefBean = messageDestinationRefBeanArray[i];
                String string = null;
                MessageDestinationDescriptorBean messageDestinationDescriptorBean = null;
                if (messageDestinationRefBean.getMessageDestinationLink() != null) {
                    object = applicationClientBean.lookupMessageDestination(messageDestinationRefBean.getMessageDestinationLink());
                    if (object == null) {
                        string = messageDestinationRefBean.getMessageDestinationRefName();
                        messageDestinationDescriptorBean = weblogicApplicationClientBean.lookupMessageDestinationDescriptor(string);
                        if (messageDestinationDescriptorBean == null) {
                            throw new IOException("Unable to find corresponding <message-destination> for the <message-destination-ref> with <message-destination-link " + messageDestinationRefBean.getMessageDestinationLink() + " in application-client.xml");
                        }
                    } else {
                        string = object.getMessageDestinationName();
                        messageDestinationDescriptorBean = weblogicApplicationClientBean.lookupMessageDestinationDescriptor(string);
                        if (messageDestinationDescriptorBean == null) {
                            throw new IOException("Unable to find <message-destinantion-descriptor> with <message-destination-name> " + string + " in weblogic-application-client.xml corresponding " + "to <message-destination> in application-client.xml");
                        }
                    }
                } else {
                    string = messageDestinationRefBean.getMessageDestinationRefName();
                    messageDestinationDescriptorBean = weblogicApplicationClientBean.lookupMessageDestinationDescriptor(string);
                    if (messageDestinationDescriptorBean == null) {
                        throw new IOException("Unable to find corresponding <message-destination-descriptor> for the <message-destination-ref> with <message-destination-name> " + string + " in weblogic-application-client.xml");
                    }
                }
                object = this.lookupMessageDestination(messageDestinationDescriptorBean);
                context.bind(string, object);
            }
        }
    }

    private Object lookupMessageDestination(MessageDestinationDescriptorBean messageDestinationDescriptorBean) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (messageDestinationDescriptorBean.getInitialContextFactory() != null) {
            hashtable.put("java.naming.factory.initial", messageDestinationDescriptorBean.getInitialContextFactory());
        }
        if (messageDestinationDescriptorBean.getProviderUrl() != null) {
            hashtable.put("java.naming.provider.url", messageDestinationDescriptorBean.getProviderUrl());
        }
        InitialContext initialContext = new InitialContext(hashtable);
        return initialContext.lookup(messageDestinationDescriptorBean.getDestinationJNDIName());
    }

    private void persistenceUnitRefs(Context context, PersistenceUnitRefBean[] persistenceUnitRefBeanArray, AppClientPersistenceUnitRegistry appClientPersistenceUnitRegistry) throws Exception {
        for (int i = 0; persistenceUnitRefBeanArray != null && i < persistenceUnitRefBeanArray.length; ++i) {
            EntityManagerFactory entityManagerFactory = this.getEntityManagerFactory(persistenceUnitRefBeanArray[i], appClientPersistenceUnitRegistry);
            context.bind(persistenceUnitRefBeanArray[i].getPersistenceUnitRefName(), (Object)entityManagerFactory);
        }
    }

    private EntityManagerFactory getEntityManagerFactory(PersistenceUnitRefBean persistenceUnitRefBean, AppClientPersistenceUnitRegistry appClientPersistenceUnitRegistry) throws Exception {
        String string = this.getPersistenceUnitName(persistenceUnitRefBean.getPersistenceUnitName(), persistenceUnitRefBean.getInjectionTargets());
        PersistenceUnitInfoImpl persistenceUnitInfoImpl = appClientPersistenceUnitRegistry.getPersistenceUnit(string);
        if (persistenceUnitInfoImpl == null) {
            throw new IllegalArgumentException("No persistence unit named '" + string + "' is available in scope ");
        }
        return persistenceUnitInfoImpl.getEntityManagerFactory();
    }

    private String getPersistenceUnitName(String string, InjectionTargetBean[] injectionTargetBeanArray) throws Exception {
        if (string != null && !"".equals(string)) {
            return string;
        }
        if (injectionTargetBeanArray != null && injectionTargetBeanArray.length == 1) {
            return injectionTargetBeanArray[0].getInjectionTargetName();
        }
        if (injectionTargetBeanArray == null || injectionTargetBeanArray.length == 0) {
            throw new Exception("PersistenceContext refs defined without any injection targets must explicitly name a persistence unit.");
        }
        throw new Exception("PersistenceContext refs defined with multiple injection targets must explicitly name a persistence unit.");
    }

    private Object resolveSimpleType(String string, String string2) throws IOException {
        if ("java.lang.String".equals(string)) {
            return string2;
        }
        try {
            return Class.forName(string).getConstructor(String.class).newInstance(string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to create an environment-entry of  type: " + string + " with value: " + string2 + instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Unable to create an environment-entry of  type: " + string + " with value: " + string2 + invocationTargetException.getTargetException());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new AssertionError((Object)classNotFoundException);
        }
    }

    private void envEntries(Context context, EnvEntryBean[] envEntryBeanArray) throws NamingException, IOException {
        if (envEntryBeanArray != null) {
            for (int i = 0; i < envEntryBeanArray.length; ++i) {
                EnvEntryBean envEntryBean = envEntryBeanArray[i];
                context.bind(envEntryBean.getEnvEntryName(), this.resolveSimpleType(envEntryBean.getEnvEntryType(), envEntryBean.getEnvEntryValue()));
            }
        }
    }

    private String findEJBJNDIName(EjbRefBean ejbRefBean, EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray) throws IOException {
        String string = ejbRefBean.getEjbRefName();
        if (ejbReferenceDescriptionBeanArray != null) {
            for (int i = 0; i < ejbReferenceDescriptionBeanArray.length; ++i) {
                if (!string.equals(ejbReferenceDescriptionBeanArray[i].getEjbRefName())) continue;
                return ejbReferenceDescriptionBeanArray[i].getJNDIName();
            }
        }
        throw new IOException("There is no jndi-name specified in the weblogic-application-client.xml for the ejb-ref " + string);
    }

    private Object resolveResource(String string, String string2, ResourceDescriptionBean[] resourceDescriptionBeanArray) throws NamingException, IOException {
        String string3 = null;
        if (resourceDescriptionBeanArray != null) {
            for (int i = 0; i < resourceDescriptionBeanArray.length; ++i) {
                if (!string.equals(resourceDescriptionBeanArray[i].getResRefName())) continue;
                string3 = resourceDescriptionBeanArray[i].getJNDIName();
                break;
            }
        }
        if (string3 == null) {
            throw new IOException("There is no jndi-name specified in the weblogic-application-client.xml for the resource-ref " + string);
        }
        if (lookupTypes.contains(string2)) {
            return this.rootCtx.lookup(string3);
        }
        if (string2.equals("javax.xml.registry.ConnectionFactory")) {
            try {
                return ConnectionFactory.newInstance();
            }
            catch (Exception exception) {
                throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }
        if (string2.equals("javax.mail.Session")) {
            try {
                return Session.getDefaultInstance((Properties)new Properties());
            }
            catch (Exception exception) {
                throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
        }
        try {
            return Class.forName(string2).getConstructor(String.class).newInstance(string3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(StackTraceUtils.throwable2StackTrace((Throwable)exception));
        }
    }

    private String findResourceEnvJNDIName(String string, ResourceEnvDescriptionBean[] resourceEnvDescriptionBeanArray) throws IOException {
        if (resourceEnvDescriptionBeanArray != null) {
            for (int i = 0; i < resourceEnvDescriptionBeanArray.length; ++i) {
                if (!string.equals(resourceEnvDescriptionBeanArray[i].getResourceEnvRefName())) continue;
                return resourceEnvDescriptionBeanArray[i].getJNDIName();
            }
        }
        throw new IOException("There is no jndi-name specified in the weblogic-application-client.xml for the resource-env-ref " + string);
    }

    private void ejbRefs(Context context, EjbRefBean[] ejbRefBeanArray, EjbReferenceDescriptionBean[] ejbReferenceDescriptionBeanArray) throws NamingException, IOException {
        if (ejbRefBeanArray == null || ejbRefBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < ejbRefBeanArray.length; ++i) {
            String string = ejbRefBeanArray[i].getEjbRefName();
            String string2 = this.findEJBJNDIName(ejbRefBeanArray[i], ejbReferenceDescriptionBeanArray);
            if (DEBUG) {
                Debug.say((String)("Adding ejb link: " + string + "->" + string2));
            }
            context.bind(string, (Object)new LinkRef(string2));
        }
    }

    private void serviceRefs(Context context, ServiceRefBean[] serviceRefBeanArray, ServiceReferenceDescriptionBean[] serviceReferenceDescriptionBeanArray) throws NamingException, ServiceRefProcessorException {
        int n;
        if (serviceReferenceDescriptionBeanArray == null) {
            serviceReferenceDescriptionBeanArray = new ServiceReferenceDescriptionBean[]{};
        }
        HashMap<String, ServiceReferenceDescriptionBean> hashMap = new HashMap<String, ServiceReferenceDescriptionBean>();
        for (n = 0; n < serviceReferenceDescriptionBeanArray.length; ++n) {
            hashMap.put(serviceReferenceDescriptionBeanArray[n].getServiceRefName(), serviceReferenceDescriptionBeanArray[n]);
        }
        for (n = 0; n < serviceRefBeanArray.length; ++n) {
            ServiceReferenceDescriptionBean serviceReferenceDescriptionBean = (ServiceReferenceDescriptionBean)hashMap.get(serviceRefBeanArray[n].getServiceRefName());
            this.removePortComponentLink(serviceRefBeanArray[n]);
            ServiceRefProcessor serviceRefProcessor = ServiceRefProcessorFactory.getInstance().getProcessor(serviceRefBeanArray[n], serviceReferenceDescriptionBean, null);
            serviceRefProcessor.bindServiceRef(this.rootCtx, context, this.clientJar.getName());
        }
    }

    private void removePortComponentLink(ServiceRefBean serviceRefBean) {
        PortComponentRefBean[] portComponentRefBeanArray = serviceRefBean.getPortComponentRefs();
        for (int i = 0; i < portComponentRefBeanArray.length; ++i) {
            PortComponentRefBean portComponentRefBean = portComponentRefBeanArray[i];
            portComponentRefBean.setPortComponentLink(null);
        }
    }

    private void resourceRefs(Context context, ResourceRefBean[] resourceRefBeanArray, ResourceDescriptionBean[] resourceDescriptionBeanArray) throws NamingException, IOException {
        if (resourceRefBeanArray == null || resourceRefBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < resourceRefBeanArray.length; ++i) {
            if ("org.omg.CORBA.ORB".equals(resourceRefBeanArray[i].getResType())) continue;
            String string = resourceRefBeanArray[i].getResRefName();
            context.bind(string, this.resolveResource(resourceRefBeanArray[i].getResRefName(), resourceRefBeanArray[i].getResType(), resourceDescriptionBeanArray));
        }
    }

    private void resourceEnvRefs(Context context, ResourceEnvRefBean[] resourceEnvRefBeanArray, ResourceEnvDescriptionBean[] resourceEnvDescriptionBeanArray) throws NamingException, IOException {
        if (resourceEnvRefBeanArray == null || resourceEnvRefBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < resourceEnvRefBeanArray.length; ++i) {
            String string = resourceEnvRefBeanArray[i].getResourceEnvRefName();
            context.bind(string, this.rootCtx.lookup(this.findResourceEnvJNDIName(string, resourceEnvDescriptionBeanArray)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readMainClassName(ClassLoader classLoader) throws IOException {
        String string = null;
        if (runningInsideWebStart) {
            URL uRL;
            InputStream inputStream;
            Manifest manifest;
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements() && ((string = (String)(manifest = new Manifest(inputStream = (uRL = enumeration.nextElement()).openStream())).getMainAttributes().get(Attributes.Name.MAIN_CLASS)) == null || string.length() <= 0)) {
            }
        } else {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(this.clientJar);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    throw new IOException("Client jar file " + this.clientJar.getPath() + " did not contain a manifest");
                }
                string = (String)manifest.getMainAttributes().get(Attributes.Name.MAIN_CLASS);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (string == null) {
            throw new IOException("No " + Attributes.Name.MAIN_CLASS + " was specified in your client-jar file: " + this.clientJar.getPath());
        }
        if (DEBUG) {
            Debug.say((String)("Main Class: " + string));
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        Getopt2 getopt2 = new Getopt2();
        getopt2.setUsageArgs("[clientjar|exploded ear containing clientjar] URL [client-args]...");
        getopt2.setUsageFooter("Example: java weblogic.j2eeclient.Main appclient.jar t3://localhost:7001");
        getopt2.addOption("clientName", "client-jar-name", "Name of the client-jar to be invoked. This option should be used when passing in an exploded ear.");
        getopt2.grok(stringArray);
        String string = getopt2.getOption("clientName");
        stringArray = getopt2.args();
        if (stringArray.length < 2) {
            System.out.println(getopt2.fullUsageMessage(Main.class.getName()));
            System.exit(1);
        }
        File file = new File(stringArray[0]);
        ArrayList arrayList = new ArrayList();
        String string2 = Main.processExplodedEar(file, arrayList);
        if (string != null && !"".equals(string.trim())) {
            string2 = string;
        }
        File file2 = null;
        file2 = string2 == null ? file : new File(file, string2);
        String string3 = stringArray[1];
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Object object = stringArray;
        stringArray = new String[((String[])object).length - 2];
        System.arraycopy(object, 2, stringArray, 0, stringArray.length);
        object = new Main(file2, string3, stringArray, string4, string5, string6, arrayList.toArray(new File[arrayList.size()]));
        ((Main)object).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String processExplodedEar(File file, List list) throws IOException, XMLStreamException {
        String string = null;
        if (file.isDirectory()) {
            VirtualJarFile virtualJarFile = VirtualJarFactory.createVirtualJar((File)file);
            try {
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(virtualJarFile);
                ApplicationBean applicationBean = applicationDescriptor.getApplicationDescriptor();
                if (applicationBean != null) {
                    File[] fileArray;
                    File file2;
                    String string2;
                    ModuleBean[] moduleBeanArray = applicationBean.getModules();
                    for (int i = 0; i < moduleBeanArray.length && string == null; ++i) {
                        string = moduleBeanArray[i].getJava();
                    }
                    if (string != null && (string2 = applicationBean.getLibraryDirectory()) != null && (file2 = new File(file, string2)).isDirectory() && (fileArray = file2.listFiles(new FileFilter(){

                        public boolean accept(File file) {
                            return !file.isDirectory() && file.getName().endsWith(".jar");
                        }
                    })) != null) {
                        list.addAll(Arrays.asList(fileArray));
                    }
                }
            }
            finally {
                IOUtils.forceClose(virtualJarFile);
            }
        }
        return string;
    }
}

