/*
 * Decompiled with CFR 0.152.
 */
package weblogic.javaee;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum IsolationLevel {
    READ_UNCOMMITTED(1, "TransactionReadUncommitted"),
    READ_COMMITTED(2, "TransactionReadCommitted"),
    REPEATABLE_READ(4, "TransactionRepeatableRead"),
    SERIALIZABLE(8, "TransactionSerializable");

    private final int _connectionConstant;
    private final String _weblogicIsolationString;

    private IsolationLevel(int n2, String string2) {
        this._connectionConstant = n2;
        this._weblogicIsolationString = string2;
    }

    public int getConnectionConstant() {
        return this._connectionConstant;
    }

    public static IsolationLevel fromConnectionConstant(int n) {
        switch (n) {
            case 1: {
                return READ_UNCOMMITTED;
            }
            case 2: {
                return READ_COMMITTED;
            }
            case 4: {
                return REPEATABLE_READ;
            }
            case 8: {
                return SERIALIZABLE;
            }
        }
        throw new IllegalArgumentException(Integer.valueOf(n).toString());
    }

    public String getWeblogicIsolationString() {
        return this._weblogicIsolationString;
    }
}

