/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.NoSuchObjectException;
import java.util.HashMap;
import java.util.Map;
import weblogic.jdbc.JDBCLogger;
import weblogic.jdbc.common.internal.BlockGetter;
import weblogic.jdbc.common.internal.InputStreamContainer;
import weblogic.rmi.server.UnicastRemoteObject;

public class BlockGetterImpl
implements BlockGetter {
    private int lastId = 0;
    private final Map streams = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register(InputStream inputStream, int n) {
        InputStreamContainer inputStreamContainer = new InputStreamContainer(inputStream, n);
        BlockGetterImpl blockGetterImpl = this;
        synchronized (blockGetterImpl) {
            ++this.lastId;
            this.streams.put(new Integer(this.lastId), inputStreamContainer);
            return this.lastId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getStream(int n) {
        InputStreamContainer inputStreamContainer = null;
        InputStream inputStream = null;
        BlockGetterImpl blockGetterImpl = this;
        synchronized (blockGetterImpl) {
            inputStreamContainer = (InputStreamContainer)this.streams.get(new Integer(n));
        }
        if (inputStreamContainer != null) {
            inputStream = inputStreamContainer.is;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlock(int n) {
        InputStreamContainer inputStreamContainer = null;
        Object object = this;
        synchronized (object) {
            inputStreamContainer = (InputStreamContainer)this.streams.get(new Integer(n));
        }
        if (inputStreamContainer == null) {
            return null;
        }
        object = inputStreamContainer;
        synchronized (object) {
            byte[] byArray = new byte[inputStreamContainer.block_size];
            int n2 = -1;
            try {
                n2 = inputStreamContainer.is.read(byArray);
            }
            catch (IOException iOException) {
                JDBCLogger.logStackTrace((Throwable)iOException);
            }
            if (n2 < 0) {
                return null;
            }
            if (n2 >= inputStreamContainer.block_size) {
                return byArray;
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
    }

    public boolean markSupported(int n) {
        InputStream inputStream = this.getStream(n);
        return inputStream.markSupported();
    }

    public void mark(int n, int n2) {
        InputStream inputStream = this.getStream(n);
        inputStream.mark(n2);
    }

    public int available(int n) throws IOException {
        InputStream inputStream = this.getStream(n);
        return inputStream.available();
    }

    public void reset(int n) throws IOException {
        InputStream inputStream = this.getStream(n);
        inputStream.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n) {
        block8: {
            InputStreamContainer inputStreamContainer = null;
            Object object = this;
            synchronized (object) {
                inputStreamContainer = (InputStreamContainer)this.streams.remove(new Integer(n));
            }
            try {
                if (inputStreamContainer == null) break block8;
                object = inputStreamContainer;
                synchronized (object) {
                    inputStreamContainer.is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void close() {
        try {
            UnicastRemoteObject.unexportObject((Object)this, (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }
}

