/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.util.Properties;
import weblogic.common.ResourceException;
import weblogic.jdbc.common.internal.ConnectionEnv;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.ProfileStorage;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JDBCConnectionLeakProfile;
import weblogic.management.runtime.JDBCConnectionPoolRuntimeMBean;
import weblogic.management.runtime.JDBCStatementProfile;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WorkManagerRuntimeMBean;
import weblogic.utils.StackTraceUtils;

public final class ConnectionPoolRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements JDBCConnectionPoolRuntimeMBean {
    private static final long serialVersionUID = 6620033273282151271L;
    private ConnectionPool pool;

    public ConnectionPoolRuntimeMBeanImpl(ConnectionPool connectionPool, String string, RuntimeMBean runtimeMBean) throws ManagementException {
        super(string, runtimeMBean);
        this.pool = connectionPool;
    }

    public int getConnectionLeakProfileCount() {
        return ProfileStorage.ConnectionLeakProfileCount((String)this.pool.getResourceName());
    }

    public int getDeploymentState() {
        String string = this.getState();
        if (string.equals("Shutdown")) {
            return 1;
        }
        return 2;
    }

    public void setDeploymentState(int n) {
    }

    public boolean addWorkManagerRuntime(WorkManagerRuntimeMBean workManagerRuntimeMBean) {
        return true;
    }

    public WorkManagerRuntimeMBean[] getWorkManagerRuntimes() {
        return null;
    }

    public String getModuleId() {
        return this.getName();
    }

    public JDBCConnectionLeakProfile[] getConnectionLeakProfiles(int n, int n2) {
        return ProfileStorage.getConnectionLeakProfiles((int)n, (int)n2, (String)this.pool.getResourceName());
    }

    public void resetConnectionLeakProfile() {
        ProfileStorage.resetConnectionLeakProfile();
    }

    public int getStatementProfileCount() {
        return ProfileStorage.StatementProfileCount((String)this.pool.getResourceName());
    }

    public JDBCStatementProfile[] getStatementProfiles(int n, int n2) {
        return ProfileStorage.getStatementProfiles((int)n, (int)n2, (String)this.pool.getResourceName());
    }

    public void resetStatementProfile() {
        ProfileStorage.resetStatementProfile();
    }

    public void resetPreparedStatementCacheProfile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String testPool() {
        ConnectionEnv connectionEnv;
        String string;
        block8: {
            string = null;
            connectionEnv = null;
            connectionEnv = this.pool.reserve(null, -1);
            if (connectionEnv == null || connectionEnv.isConnTested()) break block8;
            string = "Warning! Connectivity to backend database not verified. This is either because required connection pool attribute \"TestConnectionsOnReserve\" has not been enabled, or an invalid value has been specified for attribute \"TestTableName\". Please check the server log for more details..";
        }
        Object var5_3 = null;
        if (connectionEnv == null) return string;
        try {
            this.pool.release(connectionEnv);
            return string;
        }
        catch (Exception exception) {
            return StackTraceUtils.throwable2StackTrace((Throwable)exception);
        }
        {
            catch (Exception exception) {
                string = StackTraceUtils.throwable2StackTrace((Throwable)exception);
                Object var5_4 = null;
                if (connectionEnv == null) return string;
                try {
                    this.pool.release(connectionEnv);
                    return string;
                }
                catch (Exception exception2) {
                    return StackTraceUtils.throwable2StackTrace((Throwable)exception2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connectionEnv == null) throw throwable;
            try {
                this.pool.release(connectionEnv);
                throw throwable;
            }
            catch (Exception exception) {
                string = StackTraceUtils.throwable2StackTrace((Throwable)exception);
            }
            throw throwable;
        }
    }

    public int getLeakedConnectionCount() {
        return this.pool.getNumLeaked();
    }

    public boolean getPoolState() {
        return this.isEnabled();
    }

    public boolean isEnabled() {
        return this.pool.isEnabled();
    }

    public String getState() {
        return this.pool.getDerivedState();
    }

    public int getFailuresToReconnectCount() {
        return this.pool.getNumFailuresToRefresh();
    }

    public int getConnectionDelayTime() {
        return this.pool.getCreationDelayTime();
    }

    public int getPrepStmtCacheHitCount() {
        return this.pool.getPrepStmtCacheHitCount();
    }

    public int getPrepStmtCacheMissCount() {
        return this.pool.getPrepStmtCacheMissCount();
    }

    public int getActiveConnectionsCurrentCount() {
        return this.pool.getNumReserved();
    }

    public int getWaitingForConnectionCurrentCount() {
        int n = this.pool.getNumWaiters();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public String getVersionJDBCDriver() {
        return this.pool.getDriverVersion();
    }

    public int getActiveConnectionsHighCount() {
        return this.pool.getHighestNumReserved();
    }

    public int getWaitingForConnectionHighCount() {
        return this.pool.getHighestNumWaiters();
    }

    public int getWaitSecondsHighCount() {
        return this.pool.getHighestWaitSeconds();
    }

    public int getConnectionsTotalCount() {
        return this.pool.getTotalNumAllocated();
    }

    public int getMaxCapacity() {
        return this.pool.getMaxCapacity();
    }

    public int getCurrCapacity() {
        return this.pool.getCurrCapacity();
    }

    public int getNumAvailable() {
        return this.pool.getNumAvailable();
    }

    public int getHighestNumAvailable() {
        return this.pool.getHighestNumAvailable();
    }

    public int getNumUnavailable() {
        return this.pool.getNumUnavailable();
    }

    public int getHighestNumUnavailable() {
        return this.pool.getHighestNumUnavailable();
    }

    public int getActiveConnectionsAverageCount() {
        return this.pool.getAverageReserved();
    }

    public void shrink() throws ResourceException {
        this.pool.shrink();
    }

    public void reset() throws ResourceException {
        this.pool.reset();
    }

    public void suspend() throws ResourceException {
        this.pool.suspendExternal();
    }

    public void forceSuspend() throws ResourceException {
        this.pool.forceSuspendExternal();
    }

    public void resume() throws ResourceException {
        this.pool.resumeExternal();
    }

    public void shutdown() throws ResourceException {
        this.pool.shutdownExternal();
    }

    public void forceShutdown() throws ResourceException {
        this.pool.forceShutdownExternal();
    }

    public void disableDroppingUsers() throws ResourceException, Exception {
        this.pool.disableDroppingUsers();
    }

    public void disableFreezingUsers() throws ResourceException, Exception {
        this.pool.disableFreezingUsers();
    }

    public void enable() throws ResourceException {
        this.pool.enable();
    }

    public Properties getProperties() throws ResourceException {
        Properties properties = (Properties)this.pool.getProperties().clone();
        properties.remove("password");
        return properties;
    }

    public boolean poolExists(String string) throws Exception {
        return this.pool.poolExists(string);
    }

    public void clearStatementCache() throws Exception {
        this.pool.clearStatementCache();
    }

    public void dumpPool() throws Exception {
        this.pool.dumpPool(null);
    }
}

