/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.rmi.RemoteException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import weblogic.common.ResourceException;
import weblogic.descriptor.DescriptorBean;
import weblogic.jdbc.common.internal.ConnectionEnv;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.JDBCDataSourceTaskRuntimeMBeanImpl;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.management.ManagementException;
import weblogic.management.runtime.JDBCDataSourceRuntimeMBean;
import weblogic.management.runtime.JDBCDataSourceTaskRuntimeMBean;
import weblogic.management.runtime.JDBCDriverRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.management.runtime.WorkManagerRuntimeMBean;

public class DataSourceRuntimeMBeanImpl
extends RuntimeMBeanDelegate
implements JDBCDataSourceRuntimeMBean {
    protected ConnectionPool pool;
    private JDBCDriverRuntimeMBean driverRTMBean;
    private ReentrantLock metaDataLock = new ReentrantLock();
    private DatabaseMetaData metaData;
    JDBCDataSourceTaskRuntimeMBeanImpl lastTask = null;

    public DataSourceRuntimeMBeanImpl(ConnectionPool connectionPool, String string, RuntimeMBean runtimeMBean, DescriptorBean descriptorBean) throws ManagementException {
        super(string, runtimeMBean, true, descriptorBean);
        this.pool = connectionPool;
    }

    public int getDeploymentState() {
        if (this.pool != null) {
            String string = this.getState();
            if (string.equals("Shutdown")) {
                return 1;
            }
            return 2;
        }
        return 2;
    }

    public void setDeploymentState(int n) {
    }

    public boolean addWorkManagerRuntime(WorkManagerRuntimeMBean workManagerRuntimeMBean) {
        return true;
    }

    public WorkManagerRuntimeMBean[] getWorkManagerRuntimes() {
        return null;
    }

    public String getModuleId() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String testPool() {
        var1_1 = null;
        var2_2 = null;
        try {
            var2_2 = this.pool.reserve(null, -1);
            if (var2_2 == null || var2_2.isConnTested()) ** GOTO lbl73
            var3_3 = this.pool.getResourceFactory().getTestQuery();
            if (var3_3 == null) ** GOTO lbl-1000
            var4_5 = var2_2.testInternal(var3_3);
            switch (var4_5) {
                case 1: {
                    var5_6 = null;
                    var7_9 = null;
                    if (var2_2 == null) return var5_6;
                    ** GOTO lbl51
                }
                case -1: {
                    var5_7 = var1_1 = JDBCUtil.getTextFormatter().testPoolQueryFailed(this.pool.getResourceFactory().getTestQuery());
                    ** GOTO lbl57
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (!var2_2.supportIsValid()) break;
                    var4_5 = (int)var2_2.conn.jconn.isValid(15);
                    if (var4_5 == 0) ** GOTO lbl28
                    var5_8 = null;
                    ** GOTO lbl65
lbl28:
                    // 1 sources

                    var1_1 = JDBCUtil.getTextFormatter().testPoolIsValid();
                    break;
                }
            }
            ** GOTO lbl73
        }
        catch (Exception var3_4) {
            var1_1 = JDBCUtil.getTextFormatter().testPoolException(var3_4.toString());
            var7_13 = null;
            if (var2_2 == null) return var1_1;
            try {
                this.pool.release(var2_2);
                return var1_1;
            }
            catch (Exception var8_19) {
                return JDBCUtil.getTextFormatter().testPoolException(var8_19.toString());
            }
        }
        {
            catch (Throwable var6_21) {
                var7_14 = null;
                if (var2_2 == null) throw var6_21;
                ** try [egrp 2[TRYBLOCK] [10 : 195->206)] { 
lbl46:
                // 1 sources

                this.pool.release(var2_2);
                throw var6_21;
lbl48:
                // 1 sources

                catch (Exception var8_20) {
                    var1_1 = JDBCUtil.getTextFormatter().testPoolException(var8_20.toString());
                }
                throw var6_21;
            }
lbl51:
            // 1 sources

            ** try [egrp 2[TRYBLOCK] [10 : 195->206)] { 
lbl52:
            // 1 sources

            this.pool.release(var2_2);
            return var5_6;
lbl54:
            // 1 sources

            catch (Exception var8_15) {
                var1_1 = JDBCUtil.getTextFormatter().testPoolException(var8_15.toString());
            }
            return var5_6;
lbl57:
            // 1 sources

            var7_10 = null;
            if (var2_2 == null) return var5_7;
            ** try [egrp 2[TRYBLOCK] [10 : 195->206)] { 
lbl60:
            // 1 sources

            this.pool.release(var2_2);
            return var5_7;
lbl62:
            // 1 sources

            catch (Exception var8_16) {
                var1_1 = JDBCUtil.getTextFormatter().testPoolException(var8_16.toString());
            }
            return var5_7;
lbl65:
            // 1 sources

            var7_11 = null;
            if (var2_2 == null) return var5_8;
            ** try [egrp 2[TRYBLOCK] [10 : 195->206)] { 
lbl68:
            // 1 sources

            this.pool.release(var2_2);
            return var5_8;
lbl70:
            // 1 sources

            catch (Exception var8_17) {
                var1_1 = JDBCUtil.getTextFormatter().testPoolException(var8_17.toString());
            }
            return var5_8;
lbl73:
            // 2 sources

            var7_12 = null;
            if (var2_2 == null) return var1_1;
            try {}
            catch (Exception var8_18) {}
            return JDBCUtil.getTextFormatter().testPoolException(var8_18.toString());
            this.pool.release(var2_2);
            return var1_1;
        }
    }

    public int getLeakedConnectionCount() {
        return this.pool.getNumLeaked();
    }

    public boolean isEnabled() {
        return this.pool.isEnabled();
    }

    public String getState() {
        return this.pool.getDerivedState();
    }

    public int getFailuresToReconnectCount() {
        return this.pool.getNumFailuresToRefresh();
    }

    public int getConnectionDelayTime() {
        return this.pool.getCreationDelayTime();
    }

    public long getPrepStmtCacheAccessCount() {
        return this.pool.getPrepStmtCacheAccessCount();
    }

    public long getPrepStmtCacheAddCount() {
        return this.pool.getPrepStmtCacheAddCount();
    }

    public long getPrepStmtCacheDeleteCount() {
        return this.pool.getPrepStmtCacheDeleteCount();
    }

    public int getPrepStmtCacheCurrentSize() {
        return this.pool.getPrepStmtCacheCurrentSize();
    }

    public int getPrepStmtCacheHitCount() {
        return this.pool.getPrepStmtCacheHitCount();
    }

    public int getPrepStmtCacheMissCount() {
        return this.pool.getPrepStmtCacheMissCount();
    }

    public int getActiveConnectionsCurrentCount() {
        return this.pool.getNumReserved();
    }

    public int getWaitingForConnectionCurrentCount() {
        int n = this.pool.getNumWaiters();
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public String getVersionJDBCDriver() {
        return this.pool.getDriverVersion();
    }

    public int getActiveConnectionsHighCount() {
        return this.pool.getHighestNumReserved();
    }

    public int getWaitingForConnectionHighCount() {
        return this.pool.getHighestNumWaiters();
    }

    public long getWaitingForConnectionTotal() {
        return this.pool.getTotalWaitingForConnection();
    }

    public long getWaitingForConnectionSuccessTotal() {
        return this.pool.getTotalWaitingForConnectionSuccess();
    }

    public long getWaitingForConnectionFailureTotal() {
        return this.pool.getTotalWaitingForConnectionFailure();
    }

    public int getWaitSecondsHighCount() {
        return this.pool.getHighestWaitSeconds();
    }

    public int getConnectionsTotalCount() {
        return this.pool.getTotalNumAllocated();
    }

    public int getCurrCapacity() {
        return this.pool.getCurrCapacity();
    }

    public int getCurrCapacityHighCount() {
        return this.pool.getHighestCurrCapacity();
    }

    public int getNumAvailable() {
        return this.pool.getNumAvailable();
    }

    public int getHighestNumAvailable() {
        return this.pool.getHighestNumAvailable();
    }

    public int getNumUnavailable() {
        return this.pool.getNumUnavailable();
    }

    public int getHighestNumUnavailable() {
        return this.pool.getHighestNumUnavailable();
    }

    public int getActiveConnectionsAverageCount() {
        return this.pool.getAverageReserved();
    }

    public long getReserveRequestCount() {
        return this.pool.getNumReserveRequests();
    }

    public long getFailedReserveRequestCount() {
        return this.pool.getNumFailedReserveRequests();
    }

    public void shrink() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("Shrink-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.shrink();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("Shrink JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.shrink();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void reset() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("Reset-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.reset();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("Reset JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.reset();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void suspend() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("Suspend-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.suspendExternal();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("Suspend JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.suspendExternal();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void forceSuspend() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("ForceSuspend-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.forceSuspendExternal();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("ForceSuspend JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.forceSuspendExternal();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void resume() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("Resume-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.resumeExternal();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("Resume JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.resumeExternal();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void shutdown() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("Shutdown-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.shutdownExternal();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("Shutdown JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.shutdownExternal();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void forceShutdown() throws ResourceException {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("ForceShutdown-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.forceShutdownExternal();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("ForceShutdown JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.forceShutdownExternal();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public Properties getProperties() throws ResourceException {
        Properties properties = (Properties)this.pool.getProperties().clone();
        properties.remove("password");
        return properties;
    }

    public boolean poolExists(String string) throws Exception {
        return this.pool.poolExists(string);
    }

    public void clearStatementCache() throws Exception {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("ClearStatementCache-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.clearStatementCache();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("ClearStatementCache JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.clearStatementCache();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public void dumpPool() throws Exception {
        this.pool.dumpPool(null);
    }

    public void dumpPoolProfile() throws Exception {
        this.pool.getProfiler().dumpData();
    }

    public void setJDBCDriverRuntime(JDBCDriverRuntimeMBean jDBCDriverRuntimeMBean) {
        this.driverRTMBean = jDBCDriverRuntimeMBean;
    }

    public JDBCDriverRuntimeMBean getJDBCDriverRuntime() {
        return this.driverRTMBean;
    }

    public JDBCDataSourceTaskRuntimeMBean getLastTask() {
        return this.lastTask;
    }

    public void start() throws Exception {
        try {
            if (this.lastTask != null) {
                this.lastTask.unregister();
            }
            this.lastTask = new JDBCDataSourceTaskRuntimeMBeanImpl("Start-JDBCDataSource", this, true);
        }
        catch (Exception exception) {
            this.pool.startExternal();
            return;
        }
        this.lastTask.setBeginTime(System.currentTimeMillis());
        this.lastTask.setDescription("Start JDBCDataSource: " + this.getName());
        try {
            try {
                this.pool.startExternal();
                this.lastTask.setStatus("SUCCESS");
            }
            catch (ResourceException resourceException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError((Exception)((Object)resourceException));
                throw resourceException;
            }
            catch (RuntimeException runtimeException) {
                this.lastTask.setStatus("FAILURE");
                this.lastTask.setError(runtimeException);
                throw runtimeException;
            }
            Object var3_4 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.lastTask.setEndTime(System.currentTimeMillis());
            throw throwable;
        }
    }

    public boolean isOperationAllowed(String string) throws IllegalArgumentException {
        int n = this.pool.getStateAsInt();
        if ("Start".equalsIgnoreCase(string)) {
            if (n == 100) {
                return true;
            }
        } else if ("Shutdown".equalsIgnoreCase(string)) {
            if (n == 101 || n == 102) {
                return true;
            }
        } else if ("Suspend".equalsIgnoreCase(string)) {
            if (n == 101) {
                return true;
            }
        } else if ("Resume".equalsIgnoreCase(string)) {
            if (n == 102) {
                return true;
            }
        } else if ("Reset".equalsIgnoreCase(string)) {
            if (n == 101 || n == 102) {
                return true;
            }
        } else if ("Shrink".equalsIgnoreCase(string)) {
            if (n == 101 || n == 102) {
                return true;
            }
        } else if ("Clear".equalsIgnoreCase(string)) {
            if (n == 101 || n == 102) {
                return true;
            }
        } else {
            throw new IllegalArgumentException("Invalid argument: " + string);
        }
        return false;
    }

    private DatabaseMetaData lookupMetaData() throws ResourceException, SQLException {
        block3: {
            DatabaseMetaData databaseMetaData;
            block4: {
                ConnectionEnv connectionEnv = null;
                try {
                    connectionEnv = this.pool.reserve(null, -1);
                    if (connectionEnv == null) break block3;
                    databaseMetaData = connectionEnv.conn.jconn.getMetaData();
                    Object var4_3 = null;
                    if (connectionEnv == null) break block4;
                }
                catch (Throwable throwable) {
                    block5: {
                        Object var4_4 = null;
                        if (connectionEnv == null) break block5;
                        this.pool.release(connectionEnv);
                    }
                    throw throwable;
                }
                this.pool.release(connectionEnv);
            }
            return databaseMetaData;
        }
        throw new ResourceException("Unable to obtain a connection for data source " + this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseMetaData getMetaData() throws ResourceException, SQLException {
        try {
            if (!this.metaDataLock.tryLock(60L, TimeUnit.SECONDS)) {
                throw new ResourceException("Operation timed out waiting to get JDBC meta data");
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ResourceException(interruptedException.getMessage());
        }
        try {
            if (this.metaData == null) {
                this.metaData = this.lookupMetaData();
            }
            Object var3_2 = null;
            this.metaDataLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.metaDataLock.unlock();
            throw throwable;
        }
        return this.metaData;
    }

    public String getDatabaseProductName() throws RemoteException {
        try {
            DatabaseMetaData databaseMetaData = this.getMetaData();
            return databaseMetaData.getDatabaseProductName();
        }
        catch (ResourceException resourceException) {
            throw new RemoteException(resourceException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage());
        }
    }

    public String getDatabaseProductVersion() throws RemoteException {
        try {
            DatabaseMetaData databaseMetaData = this.getMetaData();
            return databaseMetaData.getDatabaseProductVersion();
        }
        catch (ResourceException resourceException) {
            throw new RemoteException(resourceException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage());
        }
    }

    public String getDriverName() throws RemoteException {
        try {
            DatabaseMetaData databaseMetaData = this.getMetaData();
            return databaseMetaData.getDriverName();
        }
        catch (ResourceException resourceException) {
            throw new RemoteException(resourceException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage());
        }
    }

    public String getDriverVersion() throws RemoteException {
        try {
            DatabaseMetaData databaseMetaData = this.getMetaData();
            return databaseMetaData.getDriverVersion();
        }
        catch (ResourceException resourceException) {
            throw new RemoteException(resourceException.getMessage());
        }
        catch (SQLException sQLException) {
            throw new RemoteException(sQLException.getMessage());
        }
    }
}

