/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import com.bea.logging.LogFileConfigBean;
import com.bea.logging.RotatingFileStreamHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.jdbc.common.internal.DataSourceServiceImpl;
import weblogic.management.configuration.CommonLogMBean;
import weblogic.management.configuration.DataSourceLogFileMBean;
import weblogic.management.configuration.LogFileMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class DataSourceServiceFullImpl
extends DataSourceServiceImpl
implements BeanUpdateListener {
    private static final AuthenticatedSubject KERNELID = DataSourceServiceFullImpl.getKernelID();
    static RotatingFileStreamHandler rotatingFileStreamHandler = null;
    private static final String DEFAULT_ROTATION_TIME = "00:00";

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    public OutputStream getLogFileOutputStream() throws Exception {
        if (rotatingFileStreamHandler == null) {
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(KERNELID).getServer();
            DataSourceLogFileMBean dataSourceLogFileMBean = serverMBean.getDataSource().getDataSourceLogFile();
            LogFileConfigBean logFileConfigBean = DataSourceServiceFullImpl.getLogFileConfig(dataSourceLogFileMBean);
            rotatingFileStreamHandler = new RotatingFileStreamHandler(logFileConfigBean);
            dataSourceLogFileMBean.addBeanUpdateListener(this);
        }
        return rotatingFileStreamHandler.getRotatingFileOutputStream();
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        Object object = beanUpdateEvent.getSource();
        if (object instanceof DataSourceLogFileMBean) {
            DataSourceLogFileMBean dataSourceLogFileMBean = (DataSourceLogFileMBean)object;
            try {
                LogFileConfigBean logFileConfigBean = DataSourceServiceFullImpl.getLogFileConfig(dataSourceLogFileMBean);
                rotatingFileStreamHandler.initialize(logFileConfigBean, true);
            }
            catch (IOException iOException) {
                throw new BeanUpdateFailedException("Failed to update log configuration for " + dataSourceLogFileMBean.getName(), (Throwable)iOException);
            }
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    private static LogFileConfigBean getLogFileConfig(LogFileMBean logFileMBean) {
        String string;
        LogFileConfigBean logFileConfigBean = new LogFileConfigBean();
        logFileConfigBean.setBaseLogFileName(logFileMBean.computeLogFilePath());
        logFileConfigBean.setRotateLogOnStartupEnabled(logFileMBean.getRotateLogOnStartup());
        if (logFileMBean instanceof CommonLogMBean && (string = ((CommonLogMBean)logFileMBean).getLogFileSeverity()) != null) {
            logFileConfigBean.setLogFileSeverity(string);
        }
        logFileConfigBean.setRotatedFileCount(logFileMBean.getFileCount());
        logFileConfigBean.setRotationSize(logFileMBean.getFileMinSize());
        string = logFileMBean.getLogFileRotationDir();
        if (string != null && string.length() > 0) {
            logFileConfigBean.setLogFileRotationDir(string);
        }
        logFileConfigBean.setNumberOfFilesLimited(logFileMBean.isNumberOfFilesLimited());
        String string2 = logFileMBean.getRotationTime();
        if (string2 == null || string2.equals("")) {
            string2 = DEFAULT_ROTATION_TIME;
        }
        logFileConfigBean.setRotationTime(string2);
        String string3 = logFileMBean.getRotationType();
        if (string3 == null || string3.equals("")) {
            string3 = "bySize";
        }
        logFileConfigBean.setRotationType(string3);
        logFileConfigBean.setRotationTimeSpan(logFileMBean.getFileTimeSpan());
        logFileConfigBean.setRotationTimeSpanFactor(logFileMBean.getFileTimeSpanFactor());
        logFileConfigBean.setBufferSizeKB(logFileMBean.getBufferSizeKB());
        return logFileConfigBean;
    }
}

