/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import weblogic.jdbc.common.internal.BlockGetter;

public final class InputStreamHandler
extends InputStream {
    private byte[] bytes = null;
    private int idx = 0;
    private boolean eof = false;
    private boolean closed = false;
    private BlockGetter bg = null;
    private int id = 0;
    private boolean marked = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlockGetter(BlockGetter blockGetter, int n) {
        InputStreamHandler inputStreamHandler = this;
        synchronized (inputStreamHandler) {
            this.bg = blockGetter;
            this.id = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        InputStreamHandler inputStreamHandler = this;
        synchronized (inputStreamHandler) {
            this.checkIfClosed();
            if (this.eof) {
                return -1;
            }
            this.refreshCacheIfNeeded();
            if (this.eof) {
                return -1;
            }
            return this.bytes[this.idx++] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        InputStreamHandler inputStreamHandler = this;
        synchronized (inputStreamHandler) {
            this.checkIfClosed();
            if (this.eof) {
                return -1;
            }
            int n3 = 0;
            try {
                int n4 = n2 - n3;
                while (n4 > 0) {
                    this.refreshCacheIfNeeded();
                    if (this.eof) {
                        return n3;
                    }
                    int n5 = Math.min(this.bytes.length - this.idx, n4);
                    System.arraycopy(this.bytes, this.idx, byArray, n, n5);
                    this.idx += n5;
                    n += n5;
                    n4 = n2 - (n3 += n5);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return n3;
        }
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        int n = -1;
        try {
            n = this.read(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return n;
    }

    public long skip(long l) throws IOException {
        if (l <= 0L) {
            return 0L;
        }
        this.checkIfClosed();
        int n = 0;
        try {
            if (!this.eof) {
                while ((long)n < l && this.read() != -1) {
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return n;
    }

    public int available() throws IOException {
        int n = 0;
        try {
            n = this.bg.available(this.id);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return n;
    }

    public void mark(int n) {
        if (this.bg.markSupported(this.id)) {
            this.bg.mark(this.id, n);
            this.marked = true;
        }
    }

    public void reset() throws IOException {
        if (this.marked) {
            try {
                this.bg.reset(this.id);
                this.resetCache();
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
        } else {
            throw new IOException("Stream was not marked.");
        }
    }

    public boolean markSupported() {
        return this.bg.markSupported(this.id);
    }

    private void refreshCacheIfNeeded() throws IOException {
        if (this.bytes == null || this.idx >= this.bytes.length) {
            try {
                this.bytes = this.bg.getBlock(this.id);
                this.idx = 0;
                if (this.bytes == null) {
                    this.eof = true;
                }
            }
            catch (RemoteException remoteException) {
                this.resetCache();
                throw new IOException(remoteException.toString());
            }
        }
    }

    private void resetCache() {
        this.bytes = null;
        this.eof = false;
        this.closed = false;
        this.idx = 0;
    }

    private void checkIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InputStreamHandler inputStreamHandler = this;
        synchronized (inputStreamHandler) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.bg.close(this.id);
            this.eof = true;
            this.bytes = null;
            this.bg = null;
        }
    }
}

