/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import weblogic.diagnostics.image.ImageSource;
import weblogic.diagnostics.image.ImageSourceCreationException;
import weblogic.jdbc.common.internal.ConnectionPool;
import weblogic.jdbc.common.internal.ConnectionPoolManager;

public final class JDBCImageSource
implements ImageSource {
    private boolean imageCreationTimeout = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDiagnosticImage(OutputStream outputStream) throws ImageSourceCreationException {
        this.imageCreationTimeout = false;
        PrintWriter printWriter = new PrintWriter(outputStream);
        Object object = ConnectionPoolManager.getLockObject();
        synchronized (object) {
            Iterator iterator = ConnectionPoolManager.getConnectionPools();
            while (iterator.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)iterator.next();
                connectionPool.dumpPool(printWriter);
                if (!this.imageCreationTimeout) continue;
                printWriter.println("ImageSource timed out.");
                break;
            }
        }
        printWriter.flush();
    }

    public void timeoutImageCreation() {
        this.imageCreationTimeout = true;
    }
}

