/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import weblogic.descriptor.DescriptorManager;
import weblogic.j2ee.descriptor.wl.JDBCDataSourceBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertiesBean;
import weblogic.j2ee.descriptor.wl.JDBCPropertyBean;
import weblogic.jdbc.common.internal.DataSourceUtil;
import weblogic.jdbc.common.internal.JDBCUtil;
import weblogic.jdbc.module.JDBCDeploymentHelper;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCConnectionPoolMBean;
import weblogic.management.configuration.JDBCDataSourceMBean;
import weblogic.management.configuration.JDBCMultiPoolMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.JDBCTxDataSourceMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.internal.SerializedSystemIni;
import weblogic.security.internal.encryption.ClearOrEncryptedService;
import weblogic.security.internal.encryption.EncryptionService;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;

public final class JDBCMBeanConverter {
    protected static JDBCConnectionPoolMBean myPoolMBean;
    private static DescriptorManager dm;
    private static final AuthenticatedSubject KERNELID;

    private static AuthenticatedSubject getKernelID() {
        return (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    }

    public static JDBCDataSourceBean getJDBCDataSourceDescriptor(JDBCConnectionPoolMBean jDBCConnectionPoolMBean, JDBCDataSourceBean jDBCDataSourceBean) {
        if (jDBCDataSourceBean == null) {
            jDBCDataSourceBean = (JDBCDataSourceBean)dm.createDescriptorRoot(JDBCDataSourceBean.class).getRootBean();
        }
        JDBCMBeanConverter.init(jDBCDataSourceBean, jDBCConnectionPoolMBean, 1);
        JDBCMBeanConverter.initDriverParams(jDBCDataSourceBean, jDBCConnectionPoolMBean);
        JDBCMBeanConverter.initPoolParams(jDBCDataSourceBean, jDBCConnectionPoolMBean);
        JDBCMBeanConverter.initXAParams(jDBCDataSourceBean, jDBCConnectionPoolMBean);
        return jDBCDataSourceBean;
    }

    public static JDBCDataSourceBean getJDBCDataSourceDescriptor(JDBCMultiPoolMBean jDBCMultiPoolMBean, JDBCDataSourceBean jDBCDataSourceBean) {
        if (jDBCDataSourceBean == null) {
            jDBCDataSourceBean = (JDBCDataSourceBean)dm.createDescriptorRoot(JDBCDataSourceBean.class).getRootBean();
        }
        JDBCMBeanConverter.init(jDBCDataSourceBean, jDBCMultiPoolMBean, 2);
        JDBCMBeanConverter.initDataSourceParams(jDBCDataSourceBean, jDBCMultiPoolMBean);
        if (jDBCMultiPoolMBean.isSet("HealthCheckFrequencySeconds")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setTestFrequencySeconds(jDBCMultiPoolMBean.getHealthCheckFrequencySeconds());
        }
        return jDBCDataSourceBean;
    }

    public static JDBCDataSourceBean getJDBCDataSourceDescriptor(JDBCDataSourceMBean jDBCDataSourceMBean, JDBCDataSourceBean jDBCDataSourceBean) {
        if (jDBCDataSourceBean == null) {
            jDBCDataSourceBean = (JDBCDataSourceBean)dm.createDescriptorRoot(JDBCDataSourceBean.class).getRootBean();
        }
        JDBCMBeanConverter.init(jDBCDataSourceBean, jDBCDataSourceMBean, 3);
        JDBCMBeanConverter.initDataSourceParams(jDBCDataSourceBean, jDBCDataSourceMBean);
        jDBCDataSourceBean.getJDBCDataSourceParams().setGlobalTransactionsProtocol("None");
        return jDBCDataSourceBean;
    }

    public static JDBCDataSourceBean getJDBCDataSourceDescriptor(JDBCTxDataSourceMBean jDBCTxDataSourceMBean, JDBCDataSourceBean jDBCDataSourceBean, DomainMBean domainMBean) {
        String string;
        JDBCSystemResourceMBean jDBCSystemResourceMBean;
        if (jDBCDataSourceBean == null) {
            jDBCDataSourceBean = (JDBCDataSourceBean)dm.createDescriptorRoot(JDBCDataSourceBean.class).getRootBean();
        }
        JDBCMBeanConverter.init(jDBCDataSourceBean, jDBCTxDataSourceMBean, 4);
        JDBCMBeanConverter.initDataSourceParams(jDBCDataSourceBean, jDBCTxDataSourceMBean);
        String string2 = JDBCMBeanConverter.getInternalProperty(jDBCDataSourceBean, "LegacyPoolName");
        if (string2 != null && (jDBCSystemResourceMBean = domainMBean.lookupJDBCSystemResource(string = JDBCDeploymentHelper.getSystemResourceName(string2, 1))) != null) {
            String string3 = jDBCSystemResourceMBean.getJDBCResource().getJDBCDriverParams().getDriverName();
            if (DataSourceUtil.isXADataSource((String)string3)) {
                jDBCDataSourceBean.getJDBCDataSourceParams().setGlobalTransactionsProtocol("TwoPhaseCommit");
            } else if (jDBCTxDataSourceMBean.getEnableTwoPhaseCommit()) {
                jDBCDataSourceBean.getJDBCDataSourceParams().setGlobalTransactionsProtocol("EmulateTwoPhaseCommit");
            } else {
                jDBCDataSourceBean.getJDBCDataSourceParams().setGlobalTransactionsProtocol("OnePhaseCommit");
            }
        }
        return jDBCDataSourceBean;
    }

    public static void setDriverProperties(JDBCDataSourceBean jDBCDataSourceBean, Properties properties) {
        JDBCPropertiesBean jDBCPropertiesBean = jDBCDataSourceBean.getJDBCDriverParams().getProperties();
        JDBCPropertyBean[] jDBCPropertyBeanArray = jDBCPropertiesBean.getProperties();
        if (properties == null) {
            if (jDBCPropertyBeanArray == null) {
                return;
            }
            for (int i = 0; i < jDBCPropertyBeanArray.length; ++i) {
                jDBCPropertiesBean.destroyProperty(jDBCPropertyBeanArray[i]);
            }
            return;
        }
        if (jDBCPropertyBeanArray != null) {
            for (int i = 0; i < jDBCPropertyBeanArray.length; ++i) {
                jDBCPropertiesBean.destroyProperty(jDBCPropertyBeanArray[i]);
            }
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if ("password".equals(string)) {
                jDBCDataSourceBean.getJDBCDriverParams().setPassword(properties.getProperty(string));
                continue;
            }
            JDBCPropertyBean jDBCPropertyBean = jDBCPropertiesBean.createProperty(string, properties.getProperty(string));
        }
    }

    public static boolean isInternalPropertySet(JDBCDataSourceBean jDBCDataSourceBean, String string) {
        if (jDBCDataSourceBean == null) {
            return false;
        }
        JDBCPropertyBean jDBCPropertyBean = jDBCDataSourceBean.getInternalProperties().lookupProperty(string);
        if (jDBCPropertyBean == null) {
            return false;
        }
        return Boolean.valueOf(jDBCPropertyBean.getValue());
    }

    public static int getLegacyType(JDBCDataSourceBean jDBCDataSourceBean) {
        int n = 0;
        String string = JDBCMBeanConverter.getInternalProperty(jDBCDataSourceBean, "LegacyType");
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    public static String getInternalProperty(JDBCDataSourceBean jDBCDataSourceBean, String string) {
        JDBCPropertyBean jDBCPropertyBean = null;
        try {
            jDBCPropertyBean = jDBCDataSourceBean.getInternalProperties().lookupProperty(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jDBCPropertyBean == null) {
            return null;
        }
        return jDBCPropertyBean.getValue();
    }

    public static void setInternalProperty(JDBCDataSourceBean jDBCDataSourceBean, String string, String string2) {
        JDBCPropertiesBean jDBCPropertiesBean = jDBCDataSourceBean.getInternalProperties();
        JDBCPropertyBean jDBCPropertyBean = jDBCPropertiesBean.lookupProperty(string);
        if (jDBCPropertyBean == null) {
            jDBCPropertyBean = jDBCPropertiesBean.createProperty(string, string2);
        } else {
            jDBCPropertyBean.setValue(string2);
        }
    }

    private static void init(JDBCDataSourceBean jDBCDataSourceBean, DeploymentMBean deploymentMBean, int n) {
        jDBCDataSourceBean.setName(deploymentMBean.getName());
        JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "LegacyType", Integer.toString(n));
    }

    private static void initDriverParams(JDBCDataSourceBean jDBCDataSourceBean, JDBCConnectionPoolMBean jDBCConnectionPoolMBean) {
        EncryptionService encryptionService;
        ClearOrEncryptedService clearOrEncryptedService;
        String string;
        byte[] byArray;
        Object object;
        if (jDBCConnectionPoolMBean.isSet("URL")) {
            jDBCDataSourceBean.getJDBCDriverParams().setUrl(jDBCConnectionPoolMBean.getURL());
        }
        if (jDBCConnectionPoolMBean.isSet("DriverName")) {
            jDBCDataSourceBean.getJDBCDriverParams().setDriverName(jDBCConnectionPoolMBean.getDriverName());
        }
        if (jDBCConnectionPoolMBean.isSet("Properties")) {
            object = null;
            myPoolMBean = jDBCConnectionPoolMBean;
            try {
                object = (Properties)SecurityServiceManager.runAs((AuthenticatedSubject)KERNELID, (AuthenticatedSubject)KERNELID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return JDBCMBeanConverter.getProperties();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                // empty catch block
            }
            if (object != null) {
                JDBCMBeanConverter.setDriverProperties(jDBCDataSourceBean, (Properties)object);
            }
        }
        if ((object = jDBCConnectionPoolMBean.getPassword()) != null) {
            jDBCDataSourceBean.getJDBCDriverParams().setPassword((String)object);
        }
        if ((byArray = jDBCConnectionPoolMBean.getPasswordEncrypted()) != null && !"".equals(string = (clearOrEncryptedService = new ClearOrEncryptedService(encryptionService = SerializedSystemIni.getEncryptionService())).decrypt(new String(byArray)))) {
            jDBCDataSourceBean.getJDBCDriverParams().setPassword(string);
        }
    }

    private static Properties getProperties() {
        return myPoolMBean.getProperties();
    }

    private static void initPoolParams(JDBCDataSourceBean jDBCDataSourceBean, JDBCConnectionPoolMBean jDBCConnectionPoolMBean) {
        int n;
        int n2;
        if (jDBCConnectionPoolMBean.isSet("SqlStmtProfilingEnabled") && jDBCConnectionPoolMBean.isSqlStmtProfilingEnabled()) {
            n2 = jDBCDataSourceBean.getJDBCConnectionPoolParams().getProfileType();
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setProfileType(n2 |= 0x20);
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "SqlStmtProfilingEnabled", Boolean.toString(jDBCConnectionPoolMBean.isSqlStmtProfilingEnabled()));
        }
        if (jDBCConnectionPoolMBean.isSet("ConnLeakProfilingEnabled") && jDBCConnectionPoolMBean.isConnLeakProfilingEnabled()) {
            n2 = jDBCDataSourceBean.getJDBCConnectionPoolParams().getProfileType();
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setProfileType(n2 |= 4);
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "ConnLeakProfilingEnabled", Boolean.toString(jDBCConnectionPoolMBean.isConnLeakProfilingEnabled()));
        }
        if (jDBCConnectionPoolMBean.isSet("ConnProfilingEnabled") && jDBCConnectionPoolMBean.isConnProfilingEnabled()) {
            n2 = jDBCDataSourceBean.getJDBCConnectionPoolParams().getProfileType();
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setProfileType(n2 |= 0x40);
        }
        if (jDBCConnectionPoolMBean.isSet("InitialCapacity")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setInitialCapacity(jDBCConnectionPoolMBean.getInitialCapacity());
        }
        if (jDBCConnectionPoolMBean.isSet("MaxCapacity")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setMaxCapacity(jDBCConnectionPoolMBean.getMaxCapacity());
        }
        if (jDBCConnectionPoolMBean.isSet("CapacityIncrement")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setCapacityIncrement(jDBCConnectionPoolMBean.getCapacityIncrement());
        }
        n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = 0;
        if (jDBCConnectionPoolMBean.isSet("ShrinkPeriodMinutes")) {
            n2 = 1;
            n3 = jDBCConnectionPoolMBean.getShrinkPeriodMinutes() * 60;
        }
        if (jDBCConnectionPoolMBean.isSet("ShrinkFrequencySeconds")) {
            n2 = 1;
            n3 = jDBCConnectionPoolMBean.getShrinkFrequencySeconds();
        }
        if (jDBCConnectionPoolMBean.isSet("ShrinkingEnabled")) {
            bl = true;
            bl2 = jDBCConnectionPoolMBean.isShrinkingEnabled();
        }
        if (bl) {
            n = 900;
            if (bl2) {
                if (n2 != 0 && n3 > 0) {
                    n = n3;
                }
            } else {
                n = 0;
            }
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setShrinkFrequencySeconds(n);
        }
        if (jDBCConnectionPoolMBean.isSet("RefreshMinutes")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setTestFrequencySeconds(jDBCConnectionPoolMBean.getRefreshMinutes() * 60);
        }
        if (jDBCConnectionPoolMBean.isSet("TestFrequencySeconds")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setTestFrequencySeconds(jDBCConnectionPoolMBean.getTestFrequencySeconds());
        }
        if (jDBCConnectionPoolMBean.isSet("TestConnectionsOnReserve")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setTestConnectionsOnReserve(jDBCConnectionPoolMBean.getTestConnectionsOnReserve());
        }
        if (jDBCConnectionPoolMBean.isSet("TestConnectionsOnRelease")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "TestConnectionsOnRelease", Boolean.toString(jDBCConnectionPoolMBean.getTestConnectionsOnRelease()));
        }
        if (jDBCConnectionPoolMBean.isSet("TestConnectionsOnCreate")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "TestConnectionsOnCreate", Boolean.toString(jDBCConnectionPoolMBean.getTestConnectionsOnCreate()));
        }
        if (jDBCConnectionPoolMBean.isSet("JDBCXADebugLevel")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setJDBCXADebugLevel(jDBCConnectionPoolMBean.getJDBCXADebugLevel());
        }
        if (jDBCConnectionPoolMBean.isSet("ConnectionReserveTimeoutSeconds")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setConnectionReserveTimeoutSeconds(jDBCConnectionPoolMBean.getConnectionReserveTimeoutSeconds());
        }
        if (jDBCConnectionPoolMBean.isSet("ConnectionCreationRetryFrequencySeconds")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setConnectionCreationRetryFrequencySeconds(jDBCConnectionPoolMBean.getConnectionCreationRetryFrequencySeconds());
        }
        if (jDBCConnectionPoolMBean.isSet("InactiveConnectionTimeoutSeconds")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setInactiveConnectionTimeoutSeconds(jDBCConnectionPoolMBean.getInactiveConnectionTimeoutSeconds());
        }
        if (jDBCConnectionPoolMBean.isSet("HighestNumWaiters")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setHighestNumWaiters(jDBCConnectionPoolMBean.getHighestNumWaiters());
        }
        if (jDBCConnectionPoolMBean.isSet("HighestNumUnavailable")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "HighestNumUnavailable", Integer.toString(jDBCConnectionPoolMBean.getHighestNumUnavailable()));
        }
        if (jDBCConnectionPoolMBean.isSet("TestTableName")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setTestTableName(jDBCConnectionPoolMBean.getTestTableName());
        }
        if (jDBCConnectionPoolMBean.isSet("LoginDelaySeconds")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setLoginDelaySeconds(jDBCConnectionPoolMBean.getLoginDelaySeconds());
        }
        if (jDBCConnectionPoolMBean.isSet("InitSQL")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setInitSql(jDBCConnectionPoolMBean.getInitSQL());
        }
        if (jDBCConnectionPoolMBean.isSet("PreparedStatementCacheSize")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setStatementCacheSize(jDBCConnectionPoolMBean.getPreparedStatementCacheSize());
        }
        if (jDBCConnectionPoolMBean.isSet("XAPreparedStatementCacheSize")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setStatementCacheSize(jDBCConnectionPoolMBean.getXAPreparedStatementCacheSize());
        }
        if (jDBCConnectionPoolMBean.isSet("StatementCacheSize")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setStatementCacheSize(jDBCConnectionPoolMBean.getStatementCacheSize());
        }
        if (jDBCConnectionPoolMBean.isSet("StatementCacheType")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setStatementCacheType(jDBCConnectionPoolMBean.getStatementCacheType());
        }
        if (jDBCConnectionPoolMBean.isSet("RemoveInfectedConnectionsEnabled")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setRemoveInfectedConnections(jDBCConnectionPoolMBean.isRemoveInfectedConnectionsEnabled());
        }
        if (jDBCConnectionPoolMBean.isSet("SecondsToTrustAnIdlePoolConnection")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setSecondsToTrustAnIdlePoolConnection(jDBCConnectionPoolMBean.getSecondsToTrustAnIdlePoolConnection());
        }
        boolean bl3 = false;
        boolean bl4 = false;
        int n4 = -1;
        int n5 = -1;
        n = -1;
        if (jDBCConnectionPoolMBean.isSet("TestStatementTimeout")) {
            bl3 = true;
            n4 = jDBCConnectionPoolMBean.getTestStatementTimeout();
        }
        if (jDBCConnectionPoolMBean.isSet("StatementTimeout")) {
            bl4 = true;
            n5 = jDBCConnectionPoolMBean.getStatementTimeout();
        }
        if (bl3 && bl4) {
            n = Math.min(n5, n4);
        } else if (bl4) {
            n = n5;
        } else if (bl3) {
            n = n4;
        }
        if (n > -1) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setStatementTimeout(n);
        }
        if (jDBCConnectionPoolMBean.isSet("IgnoreInUseConnectionsEnabled")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setIgnoreInUseConnectionsEnabled(jDBCConnectionPoolMBean.isIgnoreInUseConnectionsEnabled());
        }
        if (jDBCConnectionPoolMBean.isSet("CredentialMappingEnabled")) {
            jDBCDataSourceBean.getJDBCConnectionPoolParams().setCredentialMappingEnabled(jDBCConnectionPoolMBean.isCredentialMappingEnabled());
        }
        if (jDBCConnectionPoolMBean.isSet("CountOfTestFailuresTillFlush")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "CountOfTestFailuresTillFlush", Integer.toString(jDBCConnectionPoolMBean.getCountOfTestFailuresTillFlush()));
        }
        if (jDBCConnectionPoolMBean.isSet("CountOfRefreshFailuresTillDisable")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "CountOfRefreshFailuresTillDisable", Integer.toString(jDBCConnectionPoolMBean.getCountOfRefreshFailuresTillDisable()));
        }
    }

    private static void initXAParams(JDBCDataSourceBean jDBCDataSourceBean, JDBCConnectionPoolMBean jDBCConnectionPoolMBean) {
        if (jDBCConnectionPoolMBean.isSet("KeepXAConnTillTxComplete")) {
            jDBCDataSourceBean.getJDBCXAParams().setKeepXaConnTillTxComplete(jDBCConnectionPoolMBean.getKeepXAConnTillTxComplete());
        }
        if (jDBCConnectionPoolMBean.isSet("NeedTxCtxOnClose")) {
            jDBCDataSourceBean.getJDBCXAParams().setNeedTxCtxOnClose(jDBCConnectionPoolMBean.getNeedTxCtxOnClose());
        }
        if (jDBCConnectionPoolMBean.isSet("XAEndOnlyOnce")) {
            jDBCDataSourceBean.getJDBCXAParams().setXaEndOnlyOnce(jDBCConnectionPoolMBean.getXAEndOnlyOnce());
        }
        if (jDBCConnectionPoolMBean.isSet("NewXAConnForCommit")) {
            jDBCDataSourceBean.getJDBCXAParams().setNewXaConnForCommit(jDBCConnectionPoolMBean.getNewXAConnForCommit());
        }
        if (jDBCConnectionPoolMBean.isSet("KeepLogicalConnOpenOnRelease")) {
            jDBCDataSourceBean.getJDBCXAParams().setKeepLogicalConnOpenOnRelease(jDBCConnectionPoolMBean.getKeepLogicalConnOpenOnRelease());
        }
        if (jDBCConnectionPoolMBean.isSet("EnableResourceHealthMonitoring")) {
            jDBCDataSourceBean.getJDBCXAParams().setResourceHealthMonitoring(jDBCConnectionPoolMBean.getEnableResourceHealthMonitoring());
        }
        if (jDBCConnectionPoolMBean.isSet("RecoverOnlyOnce")) {
            jDBCDataSourceBean.getJDBCXAParams().setRecoverOnlyOnce(jDBCConnectionPoolMBean.getRecoverOnlyOnce());
        }
        if (jDBCConnectionPoolMBean.isSet("XASetTransactionTimeout")) {
            jDBCDataSourceBean.getJDBCXAParams().setXaSetTransactionTimeout(jDBCConnectionPoolMBean.getXASetTransactionTimeout());
        }
        if (jDBCConnectionPoolMBean.isSet("XATransactionTimeout")) {
            jDBCDataSourceBean.getJDBCXAParams().setXaTransactionTimeout(jDBCConnectionPoolMBean.getXATransactionTimeout());
        }
        if (jDBCConnectionPoolMBean.isSet("RollbackLocalTxUponConnClose")) {
            jDBCDataSourceBean.getJDBCXAParams().setRollbackLocalTxUponConnClose(jDBCConnectionPoolMBean.getRollbackLocalTxUponConnClose());
        }
        if (jDBCConnectionPoolMBean.isSet("XARetryDurationSeconds")) {
            jDBCDataSourceBean.getJDBCXAParams().setXaRetryDurationSeconds(jDBCConnectionPoolMBean.getXARetryDurationSeconds());
        }
        if (jDBCConnectionPoolMBean.isSet("XARetryIntervalSeconds")) {
            jDBCDataSourceBean.getJDBCXAParams().setXaRetryIntervalSeconds(jDBCConnectionPoolMBean.getXARetryIntervalSeconds());
        }
    }

    private static void initDataSourceParams(JDBCDataSourceBean jDBCDataSourceBean, JDBCMultiPoolMBean jDBCMultiPoolMBean) {
        String string;
        if (jDBCMultiPoolMBean.isSet("AlgorithmType")) {
            string = jDBCMultiPoolMBean.getAlgorithmType();
            if ("High-Availability".equals(string)) {
                jDBCDataSourceBean.getJDBCDataSourceParams().setAlgorithmType("Failover");
            } else {
                jDBCDataSourceBean.getJDBCDataSourceParams().setAlgorithmType(string);
            }
        }
        if ((string = JDBCMBeanConverter.getDataSources(jDBCMultiPoolMBean)) != null) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setDataSourceList(string);
        }
    }

    private static void initDataSourceParams(JDBCDataSourceBean jDBCDataSourceBean, JDBCDataSourceMBean jDBCDataSourceMBean) {
        String string = ";";
        if (jDBCDataSourceMBean.isSet("JNDINameSeparator")) {
            string = jDBCDataSourceMBean.getJNDINameSeparator();
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "JNDINameSeparator", string);
        }
        if (jDBCDataSourceMBean.isSet("JNDIName")) {
            String string2 = jDBCDataSourceMBean.getJNDIName();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            jDBCDataSourceBean.getJDBCDataSourceParams().setJNDINames(stringArray);
        }
        if (jDBCDataSourceMBean.isSet("PoolName")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "LegacyPoolName", jDBCDataSourceMBean.getPoolName());
        }
        if (jDBCDataSourceMBean.isSet("RowPrefetchEnabled")) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setRowPrefetch(jDBCDataSourceMBean.isRowPrefetchEnabled());
        }
        if (jDBCDataSourceMBean.isSet("RowPrefetchSize")) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setRowPrefetchSize(jDBCDataSourceMBean.getRowPrefetchSize());
        }
        if (jDBCDataSourceMBean.isSet("StreamChunkSize")) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setStreamChunkSize(jDBCDataSourceMBean.getStreamChunkSize());
        }
    }

    private static void initDataSourceParams(JDBCDataSourceBean jDBCDataSourceBean, JDBCTxDataSourceMBean jDBCTxDataSourceMBean) {
        String string = ";";
        if (jDBCTxDataSourceMBean.isSet("JNDINameSeparator")) {
            string = jDBCTxDataSourceMBean.getJNDINameSeparator();
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "JNDINameSeparator", string);
        }
        if (jDBCTxDataSourceMBean.isSet("JNDIName")) {
            String string2 = jDBCTxDataSourceMBean.getJNDIName();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string);
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n++] = stringTokenizer.nextToken();
            }
            jDBCDataSourceBean.getJDBCDataSourceParams().setJNDINames(stringArray);
        }
        if (jDBCTxDataSourceMBean.isSet("PoolName")) {
            JDBCMBeanConverter.setInternalProperty(jDBCDataSourceBean, "LegacyPoolName", jDBCTxDataSourceMBean.getPoolName());
        }
        if (jDBCTxDataSourceMBean.isSet("RowPrefetchEnabled")) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setRowPrefetch(jDBCTxDataSourceMBean.isRowPrefetchEnabled());
        }
        if (jDBCTxDataSourceMBean.isSet("RowPrefetchSize")) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setRowPrefetchSize(jDBCTxDataSourceMBean.getRowPrefetchSize());
        }
        if (jDBCTxDataSourceMBean.isSet("StreamChunkSize")) {
            jDBCDataSourceBean.getJDBCDataSourceParams().setStreamChunkSize(jDBCTxDataSourceMBean.getStreamChunkSize());
        }
    }

    private static String getDataSources(JDBCMultiPoolMBean jDBCMultiPoolMBean) {
        JDBCConnectionPoolMBean[] jDBCConnectionPoolMBeanArray = jDBCMultiPoolMBean.getPoolList();
        int n = jDBCConnectionPoolMBeanArray.length;
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(jDBCConnectionPoolMBeanArray[i].getName());
            stringBuffer.append(",");
        }
        stringBuffer.deleteCharAt(stringBuffer.lastIndexOf(","));
        return stringBuffer.toString();
    }

    public static Properties getProperties(JDBCPropertyBean[] jDBCPropertyBeanArray) {
        return JDBCUtil.getProperties((JDBCPropertyBean[])jDBCPropertyBeanArray);
    }

    static {
        dm = new DescriptorManager();
        KERNELID = JDBCMBeanConverter.getKernelID();
    }
}

