/*
 * Decompiled with CFR 0.152.
 */
package weblogic.jdbc.common.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import weblogic.jdbc.common.internal.JDBCOutputStream;
import weblogic.jdbc.common.internal.JDBCOutputStreamStub;
import weblogic.rmi.extensions.server.SmartStubInfo;
import weblogic.rmi.server.UnicastRemoteObject;

public class JDBCOutputStreamImpl
extends OutputStream
implements JDBCOutputStream,
SmartStubInfo {
    OutputStream t2_os;
    boolean verbose = false;
    boolean closed = false;
    int block_size;
    private transient JDBCOutputStreamStub osstub = null;

    public JDBCOutputStreamImpl(OutputStream outputStream, boolean bl, int n) {
        this.t2_os = outputStream;
        this.verbose = bl;
        this.block_size = n;
    }

    public void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        this.t2_os.write(n);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        this.t2_os.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        this.t2_os.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        this.t2_os.flush();
    }

    public void close() throws IOException {
        try {
            UnicastRemoteObject.unexportObject((Object)this, (boolean)true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        if (this.closed) {
            return;
        }
        this.t2_os.close();
        this.closed = true;
        this.t2_os = null;
        this.osstub = null;
    }

    public void writeBlock(byte[] byArray) throws IOException {
        if (this.closed) {
            throw new IOException("ERROR OutputStream has been closed and cannot be used");
        }
        this.t2_os.write(byArray);
    }

    public Object getSmartStub(Object object) {
        if (this.osstub == null) {
            this.osstub = new JDBCOutputStreamStub((JDBCOutputStream)object, this.verbose, this.block_size);
        }
        return this.osstub;
    }
}

